/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic.data;

import hudson.model.JDK;
import java.io.Serializable;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeploymentTask
implements Serializable {
    private static final long serialVersionUID = 3924420945973321189L;
    private String id;
    private String weblogicEnvironmentTargetedName;
    private String deploymentName;
    private String deploymentTargets = "AdminServer";
    private boolean isLibrary;
    private String builtResourceRegexToDeploy;
    private String baseResourcesGeneratedDirectory;
    private String taskName;
    private JDK jdk;

    @DataBoundConstructor
    public DeploymentTask(String id, String taskName, String weblogicEnvironmentTargetedName, String deploymentName, String deploymentTargets, boolean isLibrary, String builtResourceRegexToDeploy, String baseResourcesGeneratedDirectory, String jdkName, String jdkHome) {
        this.id = id == null ? RandomStringUtils.randomAlphanumeric((int)10) : id;
        this.taskName = taskName;
        this.weblogicEnvironmentTargetedName = weblogicEnvironmentTargetedName;
        this.deploymentName = deploymentName;
        this.deploymentTargets = deploymentTargets;
        this.isLibrary = isLibrary;
        this.builtResourceRegexToDeploy = builtResourceRegexToDeploy;
        this.baseResourcesGeneratedDirectory = baseResourcesGeneratedDirectory;
        if (StringUtils.isNotBlank((String)jdkName)) {
            this.jdk = new JDK(jdkName, jdkHome);
        }
    }

    public String getWeblogicEnvironmentTargetedName() {
        return this.weblogicEnvironmentTargetedName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public String getDeploymentTargets() {
        return this.deploymentTargets;
    }

    public boolean getIsLibrary() {
        return this.isLibrary;
    }

    public String getBuiltResourceRegexToDeploy() {
        return this.builtResourceRegexToDeploy;
    }

    public void setBuiltResourceRegexToDeploy(String builtResourceRegexToDeploy) {
        this.builtResourceRegexToDeploy = builtResourceRegexToDeploy;
    }

    public String getBaseResourcesGeneratedDirectory() {
        return this.baseResourcesGeneratedDirectory;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public JDK getJdk() {
        return this.jdk;
    }
}

