/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.deploy.weblogic;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.maven.AbstractMavenProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jenkinsci.plugins.deploy.weblogic.MavenJobArtifactSelectorImpl;
import org.jenkinsci.plugins.deploy.weblogic.Messages;
import org.jenkinsci.plugins.deploy.weblogic.PrintingWebLogicDeploymentLastSuccessResultAction;
import org.jenkinsci.plugins.deploy.weblogic.WatchingWeblogicDeploymentLogsAction;
import org.jenkinsci.plugins.deploy.weblogic.configuration.WeblogicDeploymentConfiguration;
import org.jenkinsci.plugins.deploy.weblogic.data.TransfertConfiguration;
import org.jenkinsci.plugins.deploy.weblogic.data.WebLogicDeploymentStatus;
import org.jenkinsci.plugins.deploy.weblogic.data.WeblogicEnvironment;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicCommand;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicDeployer;
import org.jenkinsci.plugins.deploy.weblogic.deployer.WebLogicDeployerParameters;
import org.jenkinsci.plugins.deploy.weblogic.exception.RequiredJDKNotFoundException;
import org.jenkinsci.plugins.deploy.weblogic.util.DeployerClassPathUtils;
import org.jenkinsci.plugins.deploy.weblogic.util.FTPUtils;
import org.jenkinsci.plugins.deploy.weblogic.util.JdkUtils;
import org.jenkinsci.plugins.deploy.weblogic.util.URLUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeblogicDeploymentPlugin
extends Recorder {
    public static final transient String NON_DEPLOYMENT_STRATEGY_VALUE_SPECIFIED = "unknown";
    public static final transient String DEFAULT_JAVA_OPTIONS_DEPLOYER = "-Xms256M -Xmx256M";
    private final String weblogicEnvironmentTargetedName;
    private final String deploymentName;
    private String deploymentTargets = "AdminServer";
    private boolean isLibrary;
    private transient JDK usedJdk = null;
    private boolean mustExitOnFailure = true;
    private List<String> selectedDeploymentStrategyIds;
    private boolean isDeployingOnlyWhenUpdates;
    private String deployedProjectsDependencies;

    @DataBoundConstructor
    public WeblogicDeploymentPlugin(String weblogicEnvironmentTargetedName, String deploymentName, String deploymentTargets, boolean isLibrary, boolean mustExitOnFailure, List<String> selectedDeploymentStrategyIds, String deployedProjectsDependencies, boolean isDeployingOnlyWhenUpdates) {
        this.weblogicEnvironmentTargetedName = weblogicEnvironmentTargetedName;
        this.deploymentName = deploymentName;
        this.deploymentTargets = deploymentTargets;
        this.isLibrary = isLibrary;
        this.mustExitOnFailure = mustExitOnFailure;
        this.selectedDeploymentStrategyIds = selectedDeploymentStrategyIds;
        this.deployedProjectsDependencies = deployedProjectsDependencies;
        this.isDeployingOnlyWhenUpdates = isDeployingOnlyWhenUpdates;
    }

    public String getWeblogicEnvironmentTargetedName() {
        return this.weblogicEnvironmentTargetedName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public String getDeploymentTargets() {
        return this.deploymentTargets;
    }

    public boolean getIsLibrary() {
        return this.isLibrary;
    }

    public boolean getMustExitOnFailure() {
        return this.mustExitOnFailure;
    }

    public List<String> getSelectedDeploymentStrategyIds() {
        return this.selectedDeploymentStrategyIds;
    }

    public String getDeployedProjectsDependencies() {
        return this.deployedProjectsDependencies;
    }

    public boolean getIsDeployingOnlyWhenUpdates() {
        return this.isDeployingOnlyWhenUpdates;
    }

    public void setDeployingOnlyWhenUpdates(boolean isDeployingOnlyWhenUpdates) {
        this.isDeployingOnlyWhenUpdates = isDeployingOnlyWhenUpdates;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PrintingWebLogicDeploymentLastSuccessResultAction(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FileOutputStream deploymentLogOut = new FileOutputStream(WeblogicDeploymentPlugin.getDeploymentLogFile(build));
        if (!this.checkPreRequisites(build, launcher, listener)) {
            return this.exitPerformAction(build, listener, WebLogicDeploymentStatus.DISABLED, null);
        }
        FilePath archivedArtifact = null;
        String artifactName = null;
        String fullArtifactFinalName = null;
        try {
            MavenJobArtifactSelectorImpl artifactSelector = new MavenJobArtifactSelectorImpl();
            Run.Artifact selectedArtifact = artifactSelector.selectArtifactRecorded(build, listener);
            artifactName = StringUtils.substringBeforeLast((String)selectedArtifact.getFileName(), (String)".");
            archivedArtifact = new FilePath(selectedArtifact.getFile());
            fullArtifactFinalName = selectedArtifact.getFileName();
        }
        catch (Throwable e) {
            listener.error("[HudsonWeblogicDeploymentPlugin] - Failed to get artifact from archive directory : " + e.getMessage());
            return this.exitPerformAction(build, listener, WebLogicDeploymentStatus.ABORTED, null);
        }
        String sourceFile = null;
        String remoteFilePath = null;
        WeblogicEnvironment weblogicEnvironmentTargeted = null;
        try {
            Pattern pattern = Pattern.compile(this.getDescriptor().getExcludedArtifactNamePattern());
            Matcher matcher = pattern.matcher(artifactName);
            if (matcher.matches()) {
                listener.error("[HudsonWeblogicDeploymentPlugin] - The artifact Name " + artifactName + " is excluded from deployment (see exclusion list).");
                boolean bl = this.exitPerformAction(build, listener, WebLogicDeploymentStatus.ABORTED, weblogicEnvironmentTargeted);
                return bl;
            }
            weblogicEnvironmentTargeted = this.getWeblogicEnvironmentTargeted(listener);
            if (weblogicEnvironmentTargeted == null) {
                listener.error("[HudsonWeblogicDeploymentPlugin] - WebLogic environment Name " + this.weblogicEnvironmentTargetedName + " not found in the list. Please check the configuration file.");
                boolean bl = this.exitPerformAction(build, listener, WebLogicDeploymentStatus.ABORTED, weblogicEnvironmentTargeted);
                return bl;
            }
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - Deploying the artifact on the following target : (name=" + this.weblogicEnvironmentTargetedName + ") (host=" + weblogicEnvironmentTargeted.getHost() + ") (port=" + weblogicEnvironmentTargeted.getPort() + ")");
            WebLogicDeployerParameters undeployWebLogicDeployerParameters = new WebLogicDeployerParameters(build, launcher, listener, this.usedJdk, this.deploymentName, this.isLibrary, this.deploymentTargets, weblogicEnvironmentTargeted, artifactName, null, WebLogicCommand.UNDEPLOY, true, this.getDescriptor().getJavaOpts(), this.getDescriptor().getExtraClasspath());
            String[] undeployCommand = WebLogicDeployer.getWebLogicCommandLine(undeployWebLogicDeployerParameters);
            deploymentLogOut.write("------------------------------------  ARTIFACT UNDEPLOYMENT ------------------------------------------------\r\n".getBytes());
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - UNDEPLOYING ARTIFACT...");
            Proc undeploymentProc = launcher.launch().cmds(undeployCommand).stdout((OutputStream)deploymentLogOut).start();
            undeploymentProc.join();
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - ARTIFACT UNDEPLOYED SUCCESSFULLY.");
            if (this.isLibrary) {
                String ftpHost = StringUtils.isBlank((String)weblogicEnvironmentTargeted.getFtpHost()) ? weblogicEnvironmentTargeted.getHost() : weblogicEnvironmentTargeted.getFtpHost();
                remoteFilePath = weblogicEnvironmentTargeted.getRemoteDir() + "/" + fullArtifactFinalName;
                String localFilePath = archivedArtifact.getRemote();
                listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - TRANSFERING LIBRARY : (local=" + fullArtifactFinalName + ") (remote=" + remoteFilePath + ") to (ftp=" + ftpHost + "@" + weblogicEnvironmentTargeted.getFtpUser() + ") ...");
                FTPUtils.transfertFile(new TransfertConfiguration(ftpHost, weblogicEnvironmentTargeted.getFtpUser(), weblogicEnvironmentTargeted.getFtpPassowrd(), localFilePath, remoteFilePath), listener.getLogger());
                listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - LIBRARY TRANSFERED SUCCESSFULLY.");
            }
            sourceFile = this.isLibrary ? remoteFilePath : archivedArtifact.getRemote();
            WebLogicDeployerParameters deployWebLogicDeployerParameters = new WebLogicDeployerParameters(build, launcher, listener, this.usedJdk, this.deploymentName, this.isLibrary, this.deploymentTargets, weblogicEnvironmentTargeted, artifactName, sourceFile, WebLogicCommand.DEPLOY, false, this.getDescriptor().getJavaOpts(), this.getDescriptor().getExtraClasspath());
            Object[] deployCommand = WebLogicDeployer.getWebLogicCommandLine(deployWebLogicDeployerParameters);
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - DEPLOYING ARTIFACT...");
            deploymentLogOut.write("------------------------------------  ARTIFACT DEPLOYMENT ------------------------------------------------\r\n".getBytes());
            Proc deploymentProc = launcher.launch().cmds((String[])deployCommand).stdout((OutputStream)deploymentLogOut).start();
            int exitStatus = deploymentProc.join();
            if (exitStatus != 0) {
                listener.error("[HudsonWeblogicDeploymentPlugin] - Command " + StringUtils.join((Object[])deployCommand, (char)'|') + " completed abnormally (exit code = " + exitStatus + ")");
                throw new RuntimeException("Command " + StringUtils.join((Object[])deployCommand, (char)'|') + " completed abnormally (exit code = " + exitStatus + ")");
            }
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - ARTIFACT DEPLOYED SUCCESSFULLY.");
        }
        catch (Throwable e) {
            e.printStackTrace(listener.getLogger());
            listener.error("[HudsonWeblogicDeploymentPlugin] - Failed to deploy.");
            boolean bl = this.exitPerformAction(build, listener, WebLogicDeploymentStatus.FAILED, weblogicEnvironmentTargeted);
            return bl;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)deploymentLogOut);
        }
        return this.exitPerformAction(build, listener, WebLogicDeploymentStatus.SUCCEEDED, weblogicEnvironmentTargeted);
    }

    private boolean checkPreRequisites(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.getDescriptor().isPluginDisabled()) {
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - The plugin execution is disabled.");
            return false;
        }
        boolean isSpecifiedDeploymentStrategyValue = true;
        if (CollectionUtils.isEmpty(this.selectedDeploymentStrategyIds) || this.selectedDeploymentStrategyIds.size() == 1 && this.selectedDeploymentStrategyIds.contains(NON_DEPLOYMENT_STRATEGY_VALUE_SPECIFIED)) {
            isSpecifiedDeploymentStrategyValue = false;
        }
        if (isSpecifiedDeploymentStrategyValue && !this.hasAtLeastOneBuildCauseChecked(build, this.selectedDeploymentStrategyIds)) {
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - Not properly build causes expected (configured=" + StringUtils.join(this.selectedDeploymentStrategyIds, (char)';') + ") (currents=" + StringUtils.join((Collection)build.getCauses(), (char)';') + ") : The plugin execution is disabled.");
            return false;
        }
        if (this.isDeployingOnlyWhenUpdates && build.getChangeSet().isEmptySet()) {
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - No changes : The plugin execution is disabled.");
            return false;
        }
        boolean satisfiedDependenciesDeployments = true;
        if (StringUtils.isNotBlank((String)this.deployedProjectsDependencies)) {
            String[] listeDependances = StringUtils.split((String)StringUtils.trim((String)this.deployedProjectsDependencies), (char)',');
            for (int i = 0; i < listeDependances.length; ++i) {
                TopLevelItem item = Hudson.getInstance().getItem(listeDependances[i]);
                if (!(item instanceof Job)) continue;
                WatchingWeblogicDeploymentLogsAction deploymentAction = (WatchingWeblogicDeploymentLogsAction)((Job)item).getLastBuild().getAction(WatchingWeblogicDeploymentLogsAction.class);
                listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - satisfying dependencies project involved : " + item.getName() + " deploymentAction : " + (Object)((Object)deploymentAction.getDeploymentActionStatus()));
                if (deploymentAction == null || !WebLogicDeploymentStatus.FAILED.equals((Object)deploymentAction.getDeploymentActionStatus())) continue;
                satisfiedDependenciesDeployments = false;
            }
            if (!satisfiedDependenciesDeployments) {
                listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - Not satisfied project dependencies deployment : The plugin execution is disabled.");
                return false;
            }
        }
        if (build.getResult().isWorseThan(Result.SUCCESS)) {
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - build didn't finished successfully. The plugin execution is disabled.");
            return false;
        }
        try {
            this.usedJdk = JdkUtils.getSelectedJDK(this.getDescriptor().getJdkSelected(), listener.getLogger());
        }
        catch (RequiredJDKNotFoundException rjnfe) {
            listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - No JDK found. The plugin execution is disabled.");
            return false;
        }
        String valueJdk = this.usedJdk != null ? "the JDK " + this.usedJdk.getHome() + " will be used." : "no JDK retrieved.";
        listener.getLogger().println("[HudsonWeblogicDeploymentPlugin] - " + valueJdk);
        return true;
    }

    private WeblogicEnvironment getWeblogicEnvironmentTargeted(BuildListener listener) {
        WeblogicEnvironment out = null;
        WeblogicEnvironment[] targets = this.getDescriptor().getWeblogicEnvironments();
        if (targets == null) {
            return out;
        }
        for (int i = 0; i < targets.length; ++i) {
            if (!this.weblogicEnvironmentTargetedName.equalsIgnoreCase(targets[i].getName())) continue;
            out = targets[i];
            break;
        }
        return out;
    }

    public HudsonWeblogicDeploymentPluginDescriptor getDescriptor() {
        return (HudsonWeblogicDeploymentPluginDescriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private boolean hasAtLeastOneBuildCauseChecked(AbstractBuild<?, ?> build, List<String> deploymentStrategies) {
        boolean isProperlyBuildCause = false;
        ArrayList<String> searchedCauseIds = new ArrayList<String>();
        for (String elt : deploymentStrategies) {
            searchedCauseIds.add(StringUtils.remove((String)elt, (char)'\\'));
        }
        List causes = build.getCauses();
        for (Cause cause : causes) {
            if (!searchedCauseIds.contains(cause.getClass().getName())) continue;
            isProperlyBuildCause = true;
        }
        return isProperlyBuildCause;
    }

    private boolean exitPerformAction(AbstractBuild<?, ?> build, BuildListener listener, WebLogicDeploymentStatus status, WeblogicEnvironment weblogicEnvironment) {
        if (!WebLogicDeploymentStatus.SUCCEEDED.equals((Object)status)) {
            if (this.mustExitOnFailure) {
                build.setResult(Result.FAILURE);
            } else {
                build.setResult(Result.SUCCESS);
            }
        } else {
            build.setResult(Result.SUCCESS);
        }
        build.addAction((Action)new WatchingWeblogicDeploymentLogsAction(status, build, weblogicEnvironment));
        listener.getLogger().println("[INFO] ------------------------------------------------------------------------");
        listener.getLogger().println("[INFO] DEPLOYMENT " + status.name());
        listener.getLogger().println("[INFO] ------------------------------------------------------------------------");
        return true;
    }

    public static File getDeploymentLogFile(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "deploymentLog.txt");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class HudsonWeblogicDeploymentPluginDescriptor
    extends BuildStepDescriptor<Publisher> {
        public static final transient String PLUGIN_XSD_SCHEMA_CONFIG_FILE_PATH = "/plugin/weblogic-deployer-plugin/defaultConfig/plugin-configuration.xsd";
        private String configurationFilePath;
        private boolean pluginDisabled;
        private transient WeblogicEnvironment[] weblogicEnvironments;
        private String excludedArtifactNamePattern;
        private String jdkSelected;
        private String extraClasspath;
        private String javaOpts;

        public HudsonWeblogicDeploymentPluginDescriptor() {
            super(WeblogicDeploymentPlugin.class);
            Hudson.XSTREAM.processAnnotations(new Class[]{WeblogicDeploymentConfiguration.class, WeblogicEnvironment.class});
            this.load();
            this.init();
        }

        private void init() {
            if (StringUtils.isBlank((String)this.javaOpts)) {
                this.javaOpts = WeblogicDeploymentPlugin.DEFAULT_JAVA_OPTIONS_DEPLOYER;
            }
        }

        public WeblogicEnvironment[] getWeblogicEnvironments() {
            if (this.weblogicEnvironments == null) {
                this.loadWeblogicEnvironments();
            }
            return this.weblogicEnvironments;
        }

        public String getDisplayName() {
            return Messages.HudsonWeblogicDeploymentPluginDescriptor_DisplayName();
        }

        public String getConfigurationFilePath() {
            return this.configurationFilePath;
        }

        public void setConfigurationFilePath(String configurationFilePath) {
            this.configurationFilePath = configurationFilePath;
        }

        public boolean isPluginDisabled() {
            return this.pluginDisabled;
        }

        public void setPluginDisabled(boolean pluginDisabled) {
            this.pluginDisabled = pluginDisabled;
        }

        public String getExcludedArtifactNamePattern() {
            return this.excludedArtifactNamePattern;
        }

        public String getExtraClasspath() {
            return this.extraClasspath;
        }

        public void setExtraClasspath(String extraClasspath) {
            this.extraClasspath = extraClasspath;
        }

        public String getJavaOpts() {
            return this.javaOpts;
        }

        public void setJavaOpts(String javaOpts) {
            this.javaOpts = javaOpts;
        }

        public String getJdkSelected() {
            return this.jdkSelected;
        }

        public void setJdkSelected(String jdkSelected) {
            this.jdkSelected = jdkSelected;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.pluginDisabled = json.getBoolean("pluginDisabled");
            this.excludedArtifactNamePattern = json.getString("excludedArtifactNamePattern");
            this.extraClasspath = StringUtils.isNotBlank((String)json.getString("extraClasspath")) ? json.getString("extraClasspath") : DeployerClassPathUtils.getDefaultPathToWebLogicJar();
            this.javaOpts = json.getString("javaOpts");
            this.jdkSelected = json.getString("jdkSelected");
            this.configurationFilePath = json.getString("configurationFilePath");
            this.loadWeblogicEnvironments();
            this.save();
            return true;
        }

        private void loadWeblogicEnvironments() {
            try {
                WeblogicDeploymentConfiguration weblogicDeploymentConfiguration = null;
                if (StringUtils.isBlank((String)this.configurationFilePath)) {
                    return;
                }
                if (this.configurationFilePath.startsWith("http")) {
                    URI uri = new URI(this.configurationFilePath);
                    URL url = uri.toURL();
                    weblogicDeploymentConfiguration = (WeblogicDeploymentConfiguration)Hudson.XSTREAM.fromXML(url.openStream());
                } else if (FileUtils.fileExists((String)this.configurationFilePath)) {
                    weblogicDeploymentConfiguration = (WeblogicDeploymentConfiguration)Hudson.XSTREAM.fromXML((InputStream)new FileInputStream(FileUtils.getFile((String)this.configurationFilePath)));
                }
                if (weblogicDeploymentConfiguration != null && !ArrayUtils.isEmpty((Object[])weblogicDeploymentConfiguration.getWeblogicEnvironments())) {
                    this.weblogicEnvironments = weblogicDeploymentConfiguration.getWeblogicEnvironments();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public FormValidation doCheckConfigurationFilePath(@QueryParameter String value) throws IOException, ServletException {
            if (value.startsWith("http")) {
                if (!URLUtils.exists(value)) {
                    return FormValidation.error((String)("The url " + value + " can't be reached."));
                }
                return FormValidation.ok();
            }
            if (!FileUtils.fileExists((String)value)) {
                return FormValidation.error((String)("The file " + value + " does not exists."));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExtraClasspath(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                if (DeployerClassPathUtils.checkDefaultPathToWebLogicJar()) {
                    return FormValidation.warning((String)("By default, the weblogic.jar library found into " + System.getenv("WL_HOME") + "/server/lib/" + " will be used."));
                }
                return FormValidation.error((String)"The weblogic library has to be filled in.");
            }
            if (!FileUtils.fileExists((String)value)) {
                return FormValidation.error((String)("The file " + value + " does not exists."));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckJavaOpts(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.warning((String)"The default options -Xms256M -Xmx256M will be used.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return AbstractMavenProject.class.isAssignableFrom(jobType);
        }
    }
}

