/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.builders.ReconfigureStep;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ReconfigureCpu
extends ReconfigureStep {
    private final String cpuCores;
    private final String coresPerSocket;

    @DataBoundConstructor
    public ReconfigureCpu(String cpuCores, String coresPerSocket) throws VSphereException {
        this.cpuCores = cpuCores;
        this.coresPerSocket = coresPerSocket;
    }

    public String getCpuCores() {
        return this.cpuCores;
    }

    public String getCoresPerSocket() {
        return this.coresPerSocket;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedCPUCores = env.expand(this.cpuCores);
        String expandedCoresPerSocket = env.expand(this.coresPerSocket);
        VSphereLogger.vsLogger(jLogger, "Preparing reconfigure: CPU");
        this.spec.setNumCPUs(Integer.valueOf(expandedCPUCores));
        this.spec.setNumCoresPerSocket(Integer.valueOf(expandedCoresPerSocket));
        VSphereLogger.vsLogger(jLogger, "Finished!");
        return true;
    }

    @Extension
    public static final class ReconfigureCpuDescriptor
    extends ReconfigureStep.ReconfigureStepDescriptor {
        public ReconfigureCpuDescriptor() {
            this.load();
        }

        public FormValidation doCheckCpuCores(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("CPU Cores"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCoresPerSocket(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("Cores per socket"));
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.vm_title_ReconfigureCpu();
        }

        public FormValidation doTestData(@QueryParameter String cpuCores, @QueryParameter String coresPerSocket) {
            try {
                if (Integer.valueOf(coresPerSocket) > Integer.valueOf(cpuCores)) {
                    return FormValidation.error((String)Messages.validation_maxValue(Integer.valueOf(cpuCores) + 1));
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

