/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.cli.declarative.CLIMethod;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.slaves.OfflineCause;
import hudson.slaves.SlaveComputer;
import hudson.util.Futures;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudLauncher;
import org.jenkinsci.plugins.vSphereCloudSlave;
import org.jenkinsci.plugins.vSphereCloudSlaveComputer;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class vSphereCloudSlaveTemplateComputer
extends SlaveComputer {
    public static final Logger logger = Logger.getLogger(vSphereCloudSlaveTemplateComputer.class.getName());
    private final vSphereCloudSlave vSlave;
    private final AtomicBoolean hasBegunDisconnecting = new AtomicBoolean(false);

    public vSphereCloudSlaveTemplateComputer(Slave slave) {
        super(slave);
        this.vSlave = (vSphereCloudSlave)slave;
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        vSphereCloudSlave.removeAcceptedItem(task);
        if (this.countBusy() + 1 >= this.countExecutors()) {
            this.setAcceptingTasks(false);
        }
        super.taskAccepted(executor, task);
    }

    public boolean isConnecting() {
        return this.vSlave.slaveIsStarting == Boolean.TRUE || super.isConnecting();
    }

    public Future<?> disconnect(OfflineCause cause) {
        Future future;
        if (!this.hasBegunDisconnecting.get()) {
            if (this.getTerminatedBy().isEmpty()) {
                try {
                    Jenkins.getInstance().removeNode((Node)this.vSlave);
                }
                catch (IOException ex) {
                    logger.throwing(vSphereCloudSlaveTemplateComputer.class.getName(), "disconnect", ex);
                }
            }
            future = Futures.precomputed(null);
        } else {
            future = super.disconnect(cause);
        }
        this.hasBegunDisconnecting.compareAndSet(false, true);
        return future;
    }

    protected void onRemoved() {
        logger.info("onRemoved is being called on a template.");
        this.unProvision();
    }

    @CLIMethod(name="delete-node")
    @RequirePOST
    public HttpResponse doDoDelete() throws IOException {
        HttpResponse response = super.doDoDelete();
        logger.info("doDoDelete is being called on.");
        this.unProvision();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unProvision() {
        vSphereCloud cloud;
        vSphereCloudLauncher launcher = (vSphereCloudLauncher)this.getLauncher();
        if (launcher != null && (cloud = launcher.findOurVsInstance()) != null) {
            VSphere vSphere = null;
            try {
                vSphere = cloud.vSphereInstance();
                vSphere.destroyVm(this.nodeName, false);
            }
            catch (VSphereException ex) {
                Logger.getLogger(vSphereCloudSlaveComputer.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (vSphere != null) {
                    vSphere.disconnect();
                }
            }
        }
    }
}

