/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.slaves.iterators.api.NodeIterator;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jenkinsci.plugins.vSphereCloudSlave;
import org.jenkinsci.plugins.vSphereCloudSlaveTemplate;
import org.jenkinsci.plugins.vsphere.VSphereConnectionConfig;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class vSphereCloud
extends Cloud {
    @Deprecated
    private transient String vsHost;
    private final String vsDescription;
    @Deprecated
    private transient String username;
    @Deprecated
    private transient String password;
    private final int maxOnlineSlaves;
    @CheckForNull
    private VSphereConnectionConfig vsConnectionConfig;
    private final int instanceCap;
    private final List<? extends vSphereCloudSlaveTemplate> templates;
    private transient int currentOnlineSlaveCount = 0;
    private transient ConcurrentHashMap<String, String> currentOnline;
    private static Logger VSLOG = Logger.getLogger("vsphere-cloud");

    private static void InternalLog(Slave slave, SlaveComputer slaveComputer, TaskListener listener, String format, Object ... args) {
        String s = "";
        if (slave != null) {
            s = String.format("[%s] ", slave.getNodeName());
        }
        if (slaveComputer != null) {
            s = String.format("[%s] ", slaveComputer.getName());
        }
        s = s + String.format(format, args);
        s = s + "\n";
        if (listener != null) {
            listener.getLogger().print(s);
        }
        VSLOG.log(Level.INFO, s);
    }

    public static void Log(String msg) {
        vSphereCloud.InternalLog(null, null, null, msg, null);
    }

    public static void Log(String format, Object ... args) {
        vSphereCloud.InternalLog(null, null, null, format, args);
    }

    public static void Log(TaskListener listener, String msg) {
        vSphereCloud.InternalLog(null, null, listener, msg, null);
    }

    public static void Log(TaskListener listener, String format, Object ... args) {
        vSphereCloud.InternalLog(null, null, listener, format, args);
    }

    public static void Log(Slave slave, TaskListener listener, String msg) {
        vSphereCloud.InternalLog(slave, null, listener, msg, null);
    }

    public static void Log(Slave slave, TaskListener listener, String format, Object ... args) {
        vSphereCloud.InternalLog(slave, null, listener, format, args);
    }

    public static void Log(SlaveComputer slave, TaskListener listener, String msg) {
        vSphereCloud.InternalLog(null, slave, listener, msg, null);
    }

    public static void Log(SlaveComputer slave, TaskListener listener, String format, Object ... args) {
        vSphereCloud.InternalLog(null, slave, listener, format, args);
    }

    @Deprecated
    public vSphereCloud(String vsHost, String vsDescription, String username, String password, int maxOnlineSlaves) {
        this(null, vsDescription, maxOnlineSlaves, 0, null);
    }

    @DataBoundConstructor
    public vSphereCloud(VSphereConnectionConfig vsConnectionConfig, String vsDescription, int maxOnlineSlaves, int instanceCap, List<? extends vSphereCloudSlaveTemplate> templates) {
        super("vSphereCloud");
        this.vsDescription = vsDescription;
        this.maxOnlineSlaves = maxOnlineSlaves;
        this.vsConnectionConfig = vsConnectionConfig;
        this.templates = templates == null ? Collections.emptyList() : templates;
        this.instanceCap = instanceCap == 0 ? Integer.MAX_VALUE : instanceCap;
        try {
            this.readResolve();
        }
        catch (IOException ioex) {
            // empty catch block
        }
        vSphereCloud.Log("STARTING VSPHERE CLOUD");
    }

    public Object readResolve() throws IOException {
        if (this.vsConnectionConfig == null) {
            this.vsConnectionConfig = new VSphereConnectionConfig(this.vsHost, null);
        }
        if (this.templates != null) {
            for (vSphereCloudSlaveTemplate vSphereCloudSlaveTemplate2 : this.templates) {
                vSphereCloudSlaveTemplate2.parent = this;
            }
        }
        return this;
    }

    protected void EnsureLists() {
        if (this.currentOnline == null) {
            this.currentOnline = new ConcurrentHashMap();
        }
    }

    public int getMaxOnlineSlaves() {
        return this.maxOnlineSlaves;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public List<? extends vSphereCloudSlaveTemplate> getTemplates() {
        return this.templates;
    }

    public vSphereCloudSlaveTemplate getTemplate(String template) {
        for (vSphereCloudSlaveTemplate vSphereCloudSlaveTemplate2 : this.templates) {
            if (!vSphereCloudSlaveTemplate2.getCloneNamePrefix().equals(template)) continue;
            return vSphereCloudSlaveTemplate2;
        }
        return null;
    }

    public vSphereCloudSlaveTemplate getTemplate(Label label) {
        for (vSphereCloudSlaveTemplate vSphereCloudSlaveTemplate2 : this.templates) {
            if (!(vSphereCloudSlaveTemplate2.getMode() == Node.Mode.NORMAL ? label == null || label.matches(vSphereCloudSlaveTemplate2.getLabelSet()) : vSphereCloudSlaveTemplate2.getMode() == Node.Mode.EXCLUSIVE && label != null && label.matches(vSphereCloudSlaveTemplate2.getLabelSet()))) continue;
            return vSphereCloudSlaveTemplate2;
        }
        return null;
    }

    @CheckForNull
    public String getPassword() {
        return this.vsConnectionConfig != null ? this.vsConnectionConfig.getPassword() : null;
    }

    @CheckForNull
    public String getUsername() {
        return this.vsConnectionConfig != null ? this.vsConnectionConfig.getUsername() : null;
    }

    public String getVsDescription() {
        return this.vsDescription;
    }

    @CheckForNull
    public String getVsHost() {
        return this.vsConnectionConfig != null ? this.vsConnectionConfig.getVsHost() : null;
    }

    @CheckForNull
    public VSphereConnectionConfig getVsConnectionConfig() {
        return this.vsConnectionConfig;
    }

    public final int getHash() {
        return new HashCodeBuilder(67, 89).append((Object)this.getVsDescription()).append((Object)this.getVsHost()).toHashCode();
    }

    public VSphere vSphereInstance() throws VSphereException {
        String effectiveVsHost = this.getVsHost();
        if (effectiveVsHost == null) {
            throw new VSphereException("vSphere host is not specified");
        }
        String effectiveUserName = this.getUsername();
        if (effectiveUserName == null) {
            throw new VSphereException("vSphere username is not specified");
        }
        return VSphere.connect(effectiveVsHost + "/sdk", effectiveUserName, this.getPassword());
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    private boolean addProvisionedSlave(String cloneNamePrefix, int templateInstanceCap) throws VSphereException {
        VSphere vSphere = this.vSphereInstance();
        int totalVms = vSphere.countVms();
        int totalVmsWithPrefix = vSphere.countVmsByPrefix(cloneNamePrefix);
        VSLOG.info("There are " + totalVms + " number of VMs in this bucket. The instance cap for the bucket is: " + this.instanceCap);
        VSLOG.info("There are " + totalVmsWithPrefix + " number of VMs with the prefix " + cloneNamePrefix + ". The instance cap for VMs with that prefix is: " + templateInstanceCap);
        if (totalVms >= this.instanceCap) {
            return false;
        }
        return templateInstanceCap == 0 || totalVmsWithPrefix < templateInstanceCap;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        try {
            int templateInstanceCap;
            for (vSphereCloudSlave n : NodeIterator.nodes(vSphereCloudSlave.class)) {
                if (!n.getComputer().isOffline() || !label.matches((Collection)n.getAssignedLabels())) continue;
                n.getComputer().tryReconnect();
                excessWorkload -= n.getNumExecutors();
            }
            VSLOG.log(Level.INFO, "Excess workload after pending provision instances: " + excessWorkload);
            ArrayList<NodeProvisioner.PlannedNode> plannedNodes = new ArrayList<NodeProvisioner.PlannedNode>();
            final vSphereCloudSlaveTemplate template = this.getTemplate(label);
            int n = templateInstanceCap = template.getTemplateInstanceCap() == 0 ? Integer.MAX_VALUE : template.getTemplateInstanceCap();
            while (excessWorkload > 0 && this.addProvisionedSlave(template.getCloneNamePrefix(), templateInstanceCap)) {
                plannedNodes.add(new NodeProvisioner.PlannedNode(template.getCloneNamePrefix(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                    @Override
                    public Node call() throws Exception {
                        vSphereCloudSlave slave = template.provision((TaskListener)StreamTaskListener.fromStdout());
                        Hudson.getInstance().addNode((Node)slave);
                        slave.toComputer().connect(false).get();
                        return slave;
                    }
                }), template.getNumberOfExceutors()));
                excessWorkload -= template.getNumberOfExceutors();
            }
            return plannedNodes;
        }
        catch (Exception ex) {
            VSLOG.log(Level.WARNING, "Failed to count the # of live instances in VSphere", ex);
            return Collections.emptySet();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("vSphereCloud");
        sb.append("{Host='").append(this.getVsHost()).append('\'');
        sb.append(", Description='").append(this.vsDescription).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public synchronized Boolean canMarkVMOnline(String slaveName, String vmName) {
        this.EnsureLists();
        if (this.maxOnlineSlaves > 0 && this.currentOnline.size() == this.maxOnlineSlaves) {
            return Boolean.FALSE;
        }
        if (this.currentOnline.containsValue(vmName)) {
            return Boolean.FALSE;
        }
        if (this.currentOnline.containsKey(slaveName)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public synchronized Boolean markVMOnline(String slaveName, String vmName) {
        this.EnsureLists();
        if (this.currentOnline.containsKey(slaveName) && this.currentOnline.get(slaveName).equals(vmName)) {
            return Boolean.TRUE;
        }
        if (!this.canMarkVMOnline(slaveName, vmName).booleanValue()) {
            return Boolean.FALSE;
        }
        this.currentOnline.put(slaveName, vmName);
        ++this.currentOnlineSlaveCount;
        return Boolean.TRUE;
    }

    public synchronized void markVMOffline(String slaveName, String vmName) {
        this.EnsureLists();
        if (this.currentOnline.remove(slaveName) != null) {
            --this.currentOnlineSlaveCount;
        }
    }

    public static List<vSphereCloud> findAllVsphereClouds() {
        ArrayList<vSphereCloud> vSphereClouds = new ArrayList<vSphereCloud>();
        for (Cloud cloud : Hudson.getInstance().clouds) {
            if (!(cloud instanceof vSphereCloud)) continue;
            vSphereClouds.add((vSphereCloud)cloud);
        }
        return vSphereClouds;
    }

    public static List<String> finaAllVsphereCloudNames() {
        ArrayList<String> cloudNames = new ArrayList<String>();
        for (vSphereCloud vSphereCloud2 : vSphereCloud.findAllVsphereClouds()) {
            cloudNames.add(vSphereCloud2.getVsDescription());
        }
        return cloudNames;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        @Deprecated
        public final ConcurrentMap<String, vSphereCloud> hypervisors = new ConcurrentHashMap<String, vSphereCloud>();
        @Deprecated
        private String vsHost;
        @Deprecated
        private String username;
        @Deprecated
        private String password;
        @Deprecated
        private int maxOnlineSlaves;

        public String getDisplayName() {
            return "vSphere Cloud";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.vsHost = o.getString("vsHost");
            this.username = o.getString("username");
            this.password = o.getString("password");
            this.maxOnlineSlaves = o.getInt("maxOnlineSlaves");
            this.save();
            return super.configure(req, o);
        }

        public FormValidation doTestConnection(@QueryParameter String vsHost, @QueryParameter String vsDescription, @QueryParameter String credentialsId, @QueryParameter int maxOnlineSlaves) {
            try {
                if (vsHost.length() == 0) {
                    return FormValidation.error((String)"vSphere Host is not specified");
                }
                if (!vsHost.startsWith("https://")) {
                    return FormValidation.error((String)"vSphere host must start with https://");
                }
                if (vsHost.endsWith("/")) {
                    return FormValidation.error((String)"vSphere host name must NOT end with a trailing slash");
                }
                VSphereConnectionConfig config = new VSphereConnectionConfig(vsHost, credentialsId);
                String effectiveUsername = config.getUsername();
                String effectivePassword = config.getPassword();
                if (StringUtils.isEmpty((String)effectiveUsername)) {
                    return FormValidation.error((String)"Username is not specified");
                }
                if (StringUtils.isEmpty((String)effectivePassword)) {
                    return FormValidation.error((String)"Password is not specified");
                }
                VSphere.connect(vsHost + "/sdk", effectiveUsername, effectivePassword).disconnect();
                return FormValidation.ok((String)"Connected successfully");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

