/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.google.common.base.Stopwatch;
import com.vmware.vim25.mo.VirtualMachine;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerOn
extends VSphereBuildStep {
    private final String vm;
    private final int timeoutInSeconds;

    @DataBoundConstructor
    public PowerOn(String vm, int timeoutInSeconds) throws VSphereException {
        this.vm = vm;
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public String getVm() {
        return this.vm;
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        return this.powerOn(build, launcher, listener);
    }

    private boolean powerOn(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String expandedVm = env.expand(this.vm);
        VSphereLogger.vsLogger(jLogger, "Waiting for VM " + expandedVm + " to start (VM may be restarted during this time)");
        VSphereLogger.vsLogger(jLogger, "Timeout set to " + this.timeoutInSeconds + " seconds");
        Stopwatch stopwatch = new Stopwatch().start();
        this.vsphere.startVm(expandedVm, this.timeoutInSeconds);
        long elapsedTime = stopwatch.elapsedTime(TimeUnit.SECONDS);
        VSphereLogger.vsLogger(jLogger, "VM started in " + elapsedTime + " seconds");
        int secondsToWaitForIp = (int)((long)this.timeoutInSeconds - elapsedTime);
        String vmIP = this.vsphere.getIp(this.vsphere.getVmByName(expandedVm), secondsToWaitForIp);
        if (vmIP == null) {
            VSphereLogger.vsLogger(jLogger, "Error: Timed out after waiting " + secondsToWaitForIp + " seconds to get IP for \"" + expandedVm + "\" ");
            return false;
        }
        VSphereLogger.vsLogger(jLogger, "Successfully retrieved IP for \"" + expandedVm + "\" : " + vmIP);
        VSphereLogger.vsLogger(jLogger, "Complete startup took " + stopwatch.elapsedTime(TimeUnit.SECONDS) + " seconds");
        stopwatch.stop();
        VSphereLogger.vsLogger(jLogger, "Exposing " + vmIP + " as environment variable VSPHERE_IP");
        VSphereEnvAction envAction = new VSphereEnvAction();
        envAction.add("VSPHERE_IP", vmIP);
        build.addAction((Action)envAction);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VSphereEnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private VSphereEnvAction() {
        }

        private void add(String key, String val) {
            if (this.data == null) {
                return;
            }
            this.data.put(key, val);
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    @Extension
    public static class PowerOnDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public String getDisplayName() {
            return Messages.vm_title_PowerOn();
        }

        public FormValidation doCheckTimeoutInSeconds(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("Timeout"));
            }
            if (!value.matches("\\d+")) {
                return FormValidation.error((String)Messages.validation_positiveInteger("Timeout"));
            }
            if (Integer.parseInt(value) > 3600) {
                return FormValidation.error((String)Messages.validation_maxValue(3600));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm) {
            try {
                if (vm.length() == 0 || serverName.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = PowerOnDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                if (vmObj.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_notActually("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

