/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.GuestInfo;
import com.vmware.vim25.mo.VirtualMachine;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExposeGuestInfo
extends VSphereBuildStep {
    private final String vm;
    private final String envVariablePrefix;

    @DataBoundConstructor
    public ExposeGuestInfo(String vm, String envVariablePrefix) throws VSphereException {
        this.vm = vm;
        this.envVariablePrefix = envVariablePrefix;
    }

    public String getVm() {
        return this.vm;
    }

    public String getEnvVariablePrefix() {
        return this.envVariablePrefix;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws Exception {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        env.overrideAll(build.getBuildVariables());
        String vmName = env.expand(this.vm);
        VSphereLogger.vsLogger(jLogger, "Exposing guest info for VM \"" + vmName + "\" as environment variables");
        VirtualMachine vsphereVm = this.vsphere.getVmByName(vmName);
        VSphereEnvAction envAction = this.createGuestInfoEnvAction(vsphereVm, jLogger);
        build.addAction((Action)envAction);
        VSphereLogger.vsLogger(jLogger, "Successfully exposed guest info for VM \"" + vmName + "\"");
        return true;
    }

    private VSphereEnvAction createGuestInfoEnvAction(VirtualMachine vsphereVm, PrintStream jLogger) throws InvocationTargetException, IllegalAccessException {
        GuestInfo guestInfo = vsphereVm.getGuest();
        VSphereEnvAction envAction = new VSphereEnvAction();
        List<Class> USABLE_CLASS_TYPES = Arrays.asList(String.class, Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class);
        for (Method method : GuestInfo.class.getDeclaredMethods()) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length > 0) continue;
            String variableName = method.getName().substring(3);
            Class<?> returnType = method.getReturnType();
            if (!USABLE_CLASS_TYPES.contains(returnType) && !returnType.isEnum()) {
                VSphereLogger.vsLogger(jLogger, "Skipped \"" + variableName + "\" as it is of type " + returnType.toString());
                continue;
            }
            Object value = method.invoke((Object)guestInfo, new Object[0]);
            if (value == null) {
                VSphereLogger.vsLogger(jLogger, "Skipped \"" + variableName + "\" as it is a null value");
                continue;
            }
            String environmentVariableName = this.envVariablePrefix + "_" + variableName;
            String environmentVariableValue = String.valueOf(value);
            envAction.add(environmentVariableName, environmentVariableValue);
            VSphereLogger.vsLogger(jLogger, "Added environmental variable \"" + environmentVariableName + "\" with a value of \"" + environmentVariableValue + "\"");
        }
        return envAction;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VSphereEnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private VSphereEnvAction() {
        }

        private void add(String key, String val) {
            if (this.data == null) {
                return;
            }
            this.data.put(key, val);
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }
    }

    @Extension
    public static class ExposeGuestInfoDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public String getDisplayName() {
            return Messages.vm_title_ExposeGuestInfo();
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEnvVariablePrefix(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the environment variable prefix"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm) {
            try {
                if (vm.length() == 0 || serverName.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = ExposeGuestInfoDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                if (vmObj.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_notActually("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

