/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineToolsStatus;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Calendar;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudSlave;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class vSphereCloudLauncher
extends ComputerLauncher {
    private ComputerLauncher delegate;
    private Boolean overrideLaunchSupported;
    private String vsDescription;
    private String vmName;
    private Boolean waitForVMTools;
    private String snapName;
    private int launchDelay;
    private MACHINE_ACTION idleAction;
    private int LimitedTestRunCount = 0;

    @DataBoundConstructor
    public vSphereCloudLauncher(ComputerLauncher delegate, String vsDescription, String vmName, Boolean overrideLaunchSupported, Boolean waitForVMTools, String snapName, String launchDelay, String idleOption, String LimitedTestRunCount) {
        this.delegate = delegate;
        this.overrideLaunchSupported = overrideLaunchSupported;
        this.vsDescription = vsDescription;
        this.vmName = vmName;
        this.waitForVMTools = waitForVMTools;
        this.snapName = snapName;
        this.launchDelay = Util.tryParseNumber((String)launchDelay, (Number)60).intValue();
        this.idleAction = "Shutdown".equals(idleOption) ? MACHINE_ACTION.SHUTDOWN : ("Shutdown and Revert".equals(idleOption) ? MACHINE_ACTION.REVERT : ("Revert and Restart".equals(idleOption) ? MACHINE_ACTION.REVERT_AND_RESTART : ("Revert and Reset".equals(idleOption) ? MACHINE_ACTION.REVERT_AND_RESET : ("Reset".equals(idleOption) ? MACHINE_ACTION.RESET : ("Suspend".equals(idleOption) ? MACHINE_ACTION.SUSPEND : MACHINE_ACTION.NOTHING)))));
        this.LimitedTestRunCount = Util.tryParseNumber((String)LimitedTestRunCount, (Number)0).intValue();
    }

    public vSphereCloud findOurVsInstance() throws RuntimeException {
        if (this.vsDescription != null && this.vmName != null) {
            vSphereCloud vs = null;
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof vSphereCloud) || !((vSphereCloud)cloud).getVsDescription().equals(this.vsDescription)) continue;
                vs = (vSphereCloud)cloud;
                return vs;
            }
        }
        vSphereCloud.Log("Could not find our vSphere Cloud instance!");
        throw new RuntimeException("Could not find our vSphere Cloud instance!");
    }

    public void launch(SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException {
        vSphereCloudSlave vsSlave = (vSphereCloudSlave)slaveComputer.getNode();
        try {
            if (slaveComputer.isTemporarilyOffline()) {
                vSphereCloud.Log(slaveComputer, taskListener, "Not launching VM because it's not accepting tasks; temporarily offline");
                return;
            }
            if (vsSlave.slaveIsStarting == Boolean.TRUE) {
                vSphereCloud.Log(slaveComputer, taskListener, "Ignoring additional attempt to start the slave; it's already being started");
                return;
            }
            if (vsSlave.slaveIsDisconnecting == Boolean.TRUE) {
                vSphereCloud.Log(slaveComputer, taskListener, "Ignoring connect attempt to start the slave; it's being shutdown");
                return;
            }
            vSphereCloudSlave.ProbableLaunchCleanup();
            vSphereCloud vsC = this.findOurVsInstance();
            vsSlave.slaveIsStarting = Boolean.TRUE;
            VSphere v = null;
            try {
                vSphereCloud.Log(slaveComputer, taskListener, "Starting Virtual Machine...");
                Calendar cal = Calendar.getInstance();
                cal.add(12, 5);
                vSphereCloudSlave.AddProbableLaunch(vsSlave, cal.getTime());
                v = vsC.vSphereInstance();
                VirtualMachine vm = v.getVmByName(this.vmName);
                if (vm == null) {
                    throw new IOException("Virtual Machine could not be found");
                }
                if (!this.snapName.isEmpty()) {
                    VirtualMachineSnapshot snap = v.getSnapshotInTree(vm, this.snapName);
                    if (snap == null) {
                        throw new IOException("Virtual Machine snapshot cannot be found");
                    }
                    vSphereCloud.Log(slaveComputer, taskListener, "Reverting to snapshot:" + this.snapName);
                    Task task = snap.revertToSnapshot_Task(null);
                    if (!task.waitForTask().equals("success")) {
                        throw new IOException("Error while reverting to virtual machine snapshot");
                    }
                }
                switch (vm.getRuntime().powerState) {
                    case poweredOn: {
                        vSphereCloud.Log(slaveComputer, taskListener, "VM already powered on");
                        break;
                    }
                    case poweredOff: 
                    case suspended: {
                        vSphereCloud.Log(slaveComputer, taskListener, "Powering on VM");
                        v.startVm(this.vmName);
                    }
                }
                if (this.waitForVMTools.booleanValue()) {
                    vSphereCloud.Log(slaveComputer, taskListener, "Waiting for VMTools");
                    Calendar target = Calendar.getInstance();
                    target.add(13, 120);
                    while (Calendar.getInstance().before(target)) {
                        VirtualMachineToolsStatus status = vm.getGuest().toolsStatus;
                        if (status == VirtualMachineToolsStatus.toolsOk || status == VirtualMachineToolsStatus.toolsOld) {
                            vSphereCloud.Log(slaveComputer, taskListener, "VM Tools are running");
                            break;
                        }
                        Thread.sleep(5000L);
                    }
                    vSphereCloud.Log(slaveComputer, taskListener, "Finished wait for VMTools");
                }
                if (this.delegate.isLaunchSupported()) {
                    Thread.sleep(this.launchDelay * 1000);
                    this.delegate.launch(slaveComputer, taskListener);
                } else {
                    for (int i = 0; i <= this.launchDelay; ++i) {
                        Thread.sleep(1000L);
                        if (slaveComputer.isOnline()) break;
                    }
                    if (!slaveComputer.isOnline()) {
                        vSphereCloud.Log(slaveComputer, taskListener, "Slave did not come online in allowed time");
                        throw new IOException("Slave did not come online in allowed time");
                    }
                }
            }
            catch (Exception e) {
                vSphereCloud.Log(slaveComputer, taskListener, "EXCEPTION while starting VM");
                vSphereCloud.Log(slaveComputer, taskListener, e.getMessage());
                vsC.markVMOffline(slaveComputer.getDisplayName(), this.vmName);
                throw new RuntimeException(e);
            }
            finally {
                vSphereCloudSlave.RemoveProbableLaunch(vsSlave);
                vsSlave.slaveIsStarting = Boolean.FALSE;
                if (v != null) {
                    v.disconnect();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        vSphereCloudSlave vsSlave = (vSphereCloudSlave)slaveComputer.getNode();
        if (vsSlave.slaveIsStarting == Boolean.TRUE) {
            vSphereCloud.Log(slaveComputer, taskListener, "Ignoring disconnect attempt because a connect attempt is in progress.");
            return;
        }
        if (vsSlave.slaveIsDisconnecting == Boolean.TRUE) {
            vSphereCloud.Log(slaveComputer, taskListener, "Already disconnecting on a separate thread");
            return;
        }
        if (slaveComputer.isTemporarilyOffline()) {
            vSphereCloud.Log(slaveComputer, taskListener, "Not disconnecting VM because it's not accepting tasks");
            return;
        }
        vsSlave.slaveIsDisconnecting = Boolean.TRUE;
        VSphere v = null;
        try {
            VirtualMachinePowerState power;
            vSphereCloud.Log(slaveComputer, taskListener, "Running disconnect procedure...");
            this.delegate.afterDisconnect(slaveComputer, taskListener);
            vSphereCloud.Log(slaveComputer, taskListener, "Shutting down Virtual Machine...");
            MACHINE_ACTION localIdle = this.idleAction;
            if (localIdle == null) {
                localIdle = MACHINE_ACTION.SHUTDOWN;
            }
            vSphereCloud vsC = this.findOurVsInstance();
            vsC.markVMOffline(slaveComputer.getDisplayName(), this.vmName);
            v = vsC.vSphereInstance();
            VirtualMachine vm = v.getVmByName(this.vmName);
            if (vm != null && localIdle != MACHINE_ACTION.NOTHING && (power = vm.getSummary().getRuntime().powerState) == VirtualMachinePowerState.poweredOn) {
                switch (localIdle) {
                    case SHUTDOWN: 
                    case REVERT: 
                    case REVERT_AND_RESET: 
                    case REVERT_AND_RESTART: {
                        this.shutdownVM(vm, slaveComputer, taskListener);
                        break;
                    }
                    case SUSPEND: {
                        this.suspendVM(vm, slaveComputer, taskListener);
                        break;
                    }
                    case RESET: {
                        this.resetVM(vm, slaveComputer, taskListener);
                    }
                }
                if (localIdle == MACHINE_ACTION.REVERT) {
                    this.revertVM(vm, vsC, slaveComputer, taskListener);
                } else if (localIdle == MACHINE_ACTION.REVERT_AND_RESTART) {
                    this.revertVM(vm, vsC, slaveComputer, taskListener);
                    if (power == VirtualMachinePowerState.poweredOn) {
                        Thread.sleep(60000L);
                        this.shutdownVM(vm, slaveComputer, taskListener);
                    }
                    this.powerOnVM(vm, slaveComputer, taskListener);
                } else if (localIdle == MACHINE_ACTION.REVERT_AND_RESET) {
                    this.revertVM(vm, vsC, slaveComputer, taskListener);
                    this.resetVM(vm, slaveComputer, taskListener);
                }
            }
            if (v != null) {
                v.disconnect();
            }
        }
        catch (Throwable t) {
            vSphereCloud.Log(slaveComputer, taskListener, "Got an exception");
            vSphereCloud.Log(slaveComputer, taskListener, t.toString());
            vSphereCloud.Log(slaveComputer, taskListener, "Printed exception");
            taskListener.fatalError(t.getMessage(), new Object[]{t});
        }
        finally {
            vsSlave.slaveIsDisconnecting = Boolean.FALSE;
            vsSlave.doingLastInLimitedTestRun = Boolean.FALSE;
            vsSlave.slaveIsStarting = Boolean.FALSE;
        }
    }

    public ComputerLauncher getDelegate() {
        return this.delegate;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVsDescription() {
        return this.vsDescription;
    }

    public MACHINE_ACTION getIdleAction() {
        return this.idleAction;
    }

    public void setIdleAction(MACHINE_ACTION idleAction) {
        this.idleAction = idleAction;
    }

    public Boolean getOverrideLaunchSupported() {
        return this.overrideLaunchSupported;
    }

    public void setOverrideLaunchSupported(Boolean overrideLaunchSupported) {
        this.overrideLaunchSupported = overrideLaunchSupported;
    }

    public Boolean getWaitForVMTools() {
        return this.waitForVMTools;
    }

    public Integer getLimitedTestRunCount() {
        return this.LimitedTestRunCount;
    }

    public boolean isLaunchSupported() {
        if (this.overrideLaunchSupported == null) {
            return this.delegate.isLaunchSupported();
        }
        return this.overrideLaunchSupported;
    }

    public void beforeDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        this.delegate.beforeDisconnect(slaveComputer, taskListener);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }

    private void powerOnVM(VirtualMachine vm, SlaveComputer slaveComputer, TaskListener taskListener) throws RemoteException, InterruptedException {
        vSphereCloud.Log(slaveComputer, taskListener, "Powering on the VM");
        Task taskPowerOn = vm.powerOnVM_Task(null);
        if (!taskPowerOn.waitForTask().equals("success")) {
            vSphereCloud.Log(slaveComputer, taskListener, "Unable to power on the VM");
        }
    }

    private void shutdownVM(VirtualMachine vm, SlaveComputer slaveComputer, TaskListener taskListener) throws RemoteException, InterruptedException {
        VirtualMachineToolsStatus status = vm.getGuest().toolsStatus;
        if (status == VirtualMachineToolsStatus.toolsOk || status == VirtualMachineToolsStatus.toolsOld) {
            try {
                vSphereCloud.Log(slaveComputer, taskListener, "Attempting a graceful shutdown");
                vm.shutdownGuest();
                Calendar target = Calendar.getInstance();
                target.add(12, 3);
                while (Calendar.getInstance().before(target)) {
                    if (vm.getRuntime().powerState == VirtualMachinePowerState.poweredOff) {
                        vSphereCloud.Log(slaveComputer, taskListener, "Guest shutdown succeeded");
                        break;
                    }
                    Thread.sleep(5000L);
                }
            }
            catch (Throwable t) {
                vSphereCloud.Log(slaveComputer, taskListener, "Got an exception while attempting a graceful shutdown");
                vSphereCloud.Log(slaveComputer, taskListener, t.toString());
                vSphereCloud.Log(slaveComputer, taskListener, "Printed exception");
                vSphereCloud.Log(slaveComputer, taskListener, "Will now attempt a hard power down");
            }
        }
        if (vm.getRuntime().powerState == VirtualMachinePowerState.poweredOn) {
            vSphereCloud.Log(slaveComputer, taskListener, "Powering down hard");
            Task task = vm.powerOffVM_Task();
            if (!task.waitForTask().equals("success")) {
                vSphereCloud.Log(slaveComputer, taskListener, "Unable to power down the VM");
            }
        }
    }

    private void revertVM(VirtualMachine vm, vSphereCloud vsC, SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException, VSphereException {
        if (!this.snapName.isEmpty()) {
            VirtualMachineSnapshot snap = vsC.vSphereInstance().getSnapshotInTree(vm, this.snapName);
            if (snap == null) {
                throw new IOException("Virtual Machine snapshot cannot be found");
            }
            vSphereCloud.Log(slaveComputer, taskListener, "Reverting to snapshot:" + this.snapName);
            Task task = snap.revertToSnapshot_Task(null);
            if (!task.waitForTask().equals("success")) {
                throw new IOException("Error while reverting to virtual machine snapshot");
            }
        } else {
            vSphereCloud.Log(slaveComputer, taskListener, "Reverting to current snapshot");
            Task task = vm.revertToCurrentSnapshot_Task(null);
            if (!task.waitForTask().equals("success")) {
                throw new IOException("Error while reverting to virtual machine snapshot");
            }
        }
    }

    private void resetVM(VirtualMachine vm, SlaveComputer slaveComputer, TaskListener taskListener) throws RemoteException, InterruptedException {
        vSphereCloud.Log(slaveComputer, taskListener, "Resetting the VM");
        Task taskReset = vm.resetVM_Task();
        if (!taskReset.waitForTask().equals("success")) {
            vSphereCloud.Log(slaveComputer, taskListener, "Unable to reset the VM");
        }
    }

    private void suspendVM(VirtualMachine vm, SlaveComputer slaveComputer, TaskListener taskListener) throws RemoteException, InterruptedException {
        vSphereCloud.Log(slaveComputer, taskListener, "Suspending the VM");
        Task task = vm.suspendVM_Task();
        if (!task.waitForTask().equals("success")) {
            vSphereCloud.Log(slaveComputer, taskListener, "Unable to susped the VM");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MACHINE_ACTION {
        SHUTDOWN,
        REVERT,
        REVERT_AND_RESET,
        REVERT_AND_RESTART,
        SUSPEND,
        RESET,
        NOTHING;

    }
}

