/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.vmware.vim25.VirtualHardware;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineGuestSummary;
import com.vmware.vim25.VirtualMachineQuickStats;
import com.vmware.vim25.VirtualMachineSummary;
import com.vmware.vim25.VirtualMachineToolsStatus;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.VirtualMachine;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudSlave;
import org.jenkinsci.plugins.vsphere.tools.VSphere;

public class vSphereCloudSlaveComputer
extends AbstractCloudComputer {
    private final vSphereCloudSlave vSlave;
    private transient VMInformation vmInformation;
    private static final long NANOSECONDS_TO_CACHE_VMINFORMATION = 10000000000L;

    public vSphereCloudSlaveComputer(AbstractCloudSlave slave) {
        super(slave);
        this.vSlave = (vSphereCloudSlave)slave;
    }

    public boolean isConnecting() {
        return this.vSlave.slaveIsStarting == Boolean.TRUE || super.isConnecting();
    }

    public String getCloudDescription() {
        vSphereCloud ourCloud = this.vSlave.findOurVsInstance();
        return ourCloud == null ? null : ourCloud.getVsDescription();
    }

    public String getVmName() {
        return this.vSlave.getVmName();
    }

    public String getVmFolder() {
        return this.getVMInformation().folder;
    }

    public int getVmMemoryMB() {
        return this.getVMInformation().memoryMB;
    }

    public int getVmNumCPU() {
        return this.getVMInformation().numCPU;
    }

    public String getVmAnnotation() {
        return this.getVMInformation().annotation;
    }

    public String getVmGuestName() {
        return this.getVMInformation().guestName;
    }

    public String getVmGuestToolsStatus() {
        return this.getVMInformation().guestToolsStatus;
    }

    public int getVmUptimeSeconds() {
        return this.getVMInformation().uptimeSeconds;
    }

    public String getVmInformationError() {
        return this.getVMInformation().errorEncounteredWhenDataWasRead;
    }

    private synchronized VMInformation getVMInformation() {
        boolean shouldFetchData;
        long systemUptimeNow = System.nanoTime();
        if (this.vmInformation == null) {
            shouldFetchData = true;
        } else {
            long nanosecondsSinceLastFetch = systemUptimeNow - this.vmInformation.systemUptimeWhenDataWasRead;
            boolean bl = shouldFetchData = nanosecondsSinceLastFetch > 10000000000L;
        }
        if (shouldFetchData) {
            try {
                String ourVmName = this.vSlave.getVmName();
                vSphereCloud ourCloud = this.vSlave.findOurVsInstance();
                VSphere vSphereInstance = ourCloud.vSphereInstance();
                VirtualMachine ourVm = vSphereInstance.getVmByName(ourVmName);
                this.vmInformation = new VMInformation(systemUptimeNow, ourVm);
            }
            catch (Throwable e) {
                this.vmInformation = new VMInformation(systemUptimeNow, e);
            }
        }
        return this.vmInformation;
    }

    private static class VMInformation {
        public final long systemUptimeWhenDataWasRead;
        public final String errorEncounteredWhenDataWasRead;
        public final String annotation;
        public final String folder;
        public final String guestName;
        public final String guestToolsStatus;
        public final int memoryMB;
        public final int numCPU;
        public final int uptimeSeconds;

        public VMInformation(long systemUptimeNow, VirtualMachine vm) {
            ManagedEntity parentFolder;
            VirtualMachineConfigInfo vmConfig = vm == null ? null : vm.getConfig();
            VirtualHardware vmHardware = vmConfig == null ? null : vmConfig.getHardware();
            VirtualMachineSummary vmSummary = vm == null ? null : vm.getSummary();
            VirtualMachineGuestSummary vmGuest = vmSummary == null ? null : vmSummary.getGuest();
            VirtualMachineToolsStatus vmToolsStatus = vmGuest == null ? null : vmGuest.getToolsStatus();
            VirtualMachineQuickStats vmStats = vmSummary == null ? null : vmSummary.getQuickStats();
            this.systemUptimeWhenDataWasRead = systemUptimeNow;
            this.errorEncounteredWhenDataWasRead = null;
            this.annotation = VMInformation.nullIfEmpty(vmConfig == null ? null : vmConfig.getAnnotation());
            this.memoryMB = vmHardware == null ? 0 : vmHardware.getMemoryMB();
            this.numCPU = vmHardware == null ? 0 : vmHardware.getNumCPU();
            String path = "";
            for (ManagedEntity me = parentFolder = vm == null ? null : vm.getParent(); me != null; me = me.getParent()) {
                path = me.getName() + '/' + path;
            }
            this.folder = VMInformation.nullIfEmpty(path);
            this.guestToolsStatus = VMInformation.nullIfEmpty(vmToolsStatus == null ? null : vmToolsStatus.toString());
            this.guestName = VMInformation.nullIfEmpty(vmGuest == null ? null : vmGuest.getGuestFullName());
            Integer vmUptimeSeconds = vmStats == null ? null : vmStats.getUptimeSeconds();
            this.uptimeSeconds = vmUptimeSeconds == null ? 0 : vmUptimeSeconds;
        }

        public VMInformation(long systemUptimeNow, Throwable ex) {
            this.guestName = null;
            this.guestToolsStatus = null;
            this.folder = null;
            this.annotation = null;
            this.uptimeSeconds = 0;
            this.memoryMB = 0;
            this.numCPU = 0;
            this.systemUptimeWhenDataWasRead = systemUptimeNow;
            StringWriter s = new StringWriter();
            PrintWriter pw = new PrintWriter(s);
            ex.printStackTrace(pw);
            pw.flush();
            this.errorEncounteredWhenDataWasRead = s.toString();
        }

        private static String nullIfEmpty(String s) {
            if (s == null || s.trim().isEmpty()) {
                return null;
            }
            return s;
        }
    }
}

