// CHECKSTYLE:OFF

package org.jenkinsci.plugins;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code vSphereCloudSlave.LimitedBuild.TemporaryOffline}: {@code
     * Marking the agent as offline due to reaching limited build
     * threshold.}.
     * 
     * @return
     *     {@code Marking the agent as offline due to reaching limited build
     *     threshold.}
     */
    public static String vSphereCloudSlave_LimitedBuild_TemporaryOffline() {
        return holder.format("vSphereCloudSlave.LimitedBuild.TemporaryOffline");
    }

    /**
     * Key {@code vSphereCloudSlave.LimitedBuild.TemporaryOffline}: {@code
     * Marking the agent as offline due to reaching limited build
     * threshold.}.
     * 
     * @return
     *     {@code Marking the agent as offline due to reaching limited build
     *     threshold.}
     */
    public static Localizable _vSphereCloudSlave_LimitedBuild_TemporaryOffline() {
        return new Localizable(holder, "vSphereCloudSlave.LimitedBuild.TemporaryOffline");
    }

    /**
     * Key {@code vSphereCloudSlave.BlockageReason.NoFlyweightTasks}: {@code
     * Don't run FlyweightTasks on vSphere nodes as they can be terminated.}.
     * 
     * @return
     *     {@code Don't run FlyweightTasks on vSphere nodes as they can be
     *     terminated.}
     */
    public static String vSphereCloudSlave_BlockageReason_NoFlyweightTasks() {
        return holder.format("vSphereCloudSlave.BlockageReason.NoFlyweightTasks");
    }

    /**
     * Key {@code vSphereCloudSlave.BlockageReason.NoFlyweightTasks}: {@code
     * Don't run FlyweightTasks on vSphere nodes as they can be terminated.}.
     * 
     * @return
     *     {@code Don't run FlyweightTasks on vSphere nodes as they can be
     *     terminated.}
     */
    public static Localizable _vSphereCloudSlave_BlockageReason_NoFlyweightTasks() {
        return new Localizable(holder, "vSphereCloudSlave.BlockageReason.NoFlyweightTasks");
    }

    /**
     * Key {@code vSphereCloudSlave.LimitedBuild.Disconnect}: {@code
     * Disconnecting the agent as offline due to reaching limited build
     * threshold.}.
     * 
     * @return
     *     {@code Disconnecting the agent as offline due to reaching limited
     *     build threshold.}
     */
    public static String vSphereCloudSlave_LimitedBuild_Disconnect() {
        return holder.format("vSphereCloudSlave.LimitedBuild.Disconnect");
    }

    /**
     * Key {@code vSphereCloudSlave.LimitedBuild.Disconnect}: {@code
     * Disconnecting the agent as offline due to reaching limited build
     * threshold.}.
     * 
     * @return
     *     {@code Disconnecting the agent as offline due to reaching limited
     *     build threshold.}
     */
    public static Localizable _vSphereCloudSlave_LimitedBuild_Disconnect() {
        return new Localizable(holder, "vSphereCloudSlave.LimitedBuild.Disconnect");
    }

    /**
     * Key {@code vSphereCloudSlave.LimitedBuild.TemporarilyOnline}: {@code
     * Marking the agent as online after completing post-disconnect
     * actions.}.
     * 
     * @return
     *     {@code Marking the agent as online after completing post-disconnect
     *     actions.}
     */
    public static String vSphereCloudSlave_LimitedBuild_TemporarilyOnline() {
        return holder.format("vSphereCloudSlave.LimitedBuild.TemporarilyOnline");
    }

    /**
     * Key {@code vSphereCloudSlave.LimitedBuild.TemporarilyOnline}: {@code
     * Marking the agent as online after completing post-disconnect
     * actions.}.
     * 
     * @return
     *     {@code Marking the agent as online after completing post-disconnect
     *     actions.}
     */
    public static Localizable _vSphereCloudSlave_LimitedBuild_TemporarilyOnline() {
        return new Localizable(holder, "vSphereCloudSlave.LimitedBuild.TemporarilyOnline");
    }

    /**
     * Key {@code vSphereCloudSlave.OfflineReason.ShuttingDown}: {@code
     * Shutting down VSphere Cloud Agent}.
     * 
     * @return
     *     {@code Shutting down VSphere Cloud Agent}
     */
    public static String vSphereCloudSlave_OfflineReason_ShuttingDown() {
        return holder.format("vSphereCloudSlave.OfflineReason.ShuttingDown");
    }

    /**
     * Key {@code vSphereCloudSlave.OfflineReason.ShuttingDown}: {@code
     * Shutting down VSphere Cloud Agent}.
     * 
     * @return
     *     {@code Shutting down VSphere Cloud Agent}
     */
    public static Localizable _vSphereCloudSlave_OfflineReason_ShuttingDown() {
        return new Localizable(holder, "vSphereCloudSlave.OfflineReason.ShuttingDown");
    }

}
