/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.parameters;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.util.ListBoxModel;
import java.util.List;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vsphere.parameters.Messages;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class CloudSelectorParameter
extends SimpleParameterDefinition {
    @DataBoundConstructor
    public CloudSelectorParameter() {
        super("VSPHERE_CLOUD_NAME", "Vsphere Cloud Selector");
    }

    public StringParameterValue getDefaultParameterValue() {
        List<String> cloudNames = vSphereCloud.findAllVsphereCloudNames();
        return new StringParameterValue(this.getName(), cloudNames.get(0), this.getDescription());
    }

    private StringParameterValue checkValue(StringParameterValue value) {
        List<String> cloudNames = vSphereCloud.findAllVsphereCloudNames();
        if (!cloudNames.contains(value.value)) {
            throw new IllegalArgumentException("No vsphere cloud with name: " + value.value);
        }
        return value;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return this.checkValue(value);
    }

    public StringParameterValue createValue(String value) {
        return this.checkValue(new StringParameterValue(this.getName(), value, this.getDescription()));
    }

    @Exported
    public List<String> getCloudNames() {
        return vSphereCloud.findAllVsphereCloudNames();
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public ListBoxModel doFillCloudNameItems(@AncestorInPath Item context) {
            PermissionUtils.throwUnlessUserHasPermissionToAccessJob(context);
            ListBoxModel items = new ListBoxModel();
            for (String cloudName : vSphereCloud.findAllVsphereCloudNames()) {
                items.add(cloudName);
            }
            return items;
        }

        public String getDisplayName() {
            return Messages.VSphere_title_vSphereCloudSelectorParameter();
        }
    }
}

