/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere;

import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.EphemeralNode;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.vsphere.Messages;
import org.jenkinsci.plugins.vsphere.VSphereOfflineCause;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class RunOnceCloudRetentionStrategy
extends CloudRetentionStrategy
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(RunOnceCloudRetentionStrategy.class.getName());
    private final int idleMinutes;
    private transient boolean beingTerminated;
    @Restricted(value={NoExternalUse.class})
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RunOnceCloudRetentionStrategy(int idleMinutes) {
        super(idleMinutes);
        this.idleMinutes = idleMinutes;
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    public long check(AbstractCloudComputer c) {
        long idleMilliseconds;
        if (c.isIdle() && !disabled && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > TimeUnit.MINUTES.toMillis(this.idleMinutes)) {
            LOGGER.log(Level.FINE, "Disconnecting {0} because it has been idle for more than {1} minutes (has been idle for {2}ms)", new Object[]{c.getName(), this.idleMinutes, idleMilliseconds});
            this.done(c);
        }
        return 1L;
    }

    public void start(AbstractCloudComputer c) {
        if (c.getNode() instanceof EphemeralNode) {
            throw new IllegalStateException("May not use " + RunOnceCloudRetentionStrategy.class.getSimpleName() + " on an " + EphemeralNode.class.getSimpleName() + ": " + c);
        }
        super.start(c);
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.done(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.done(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAcceptingTasks(AbstractCloudComputer c) {
        RunOnceCloudRetentionStrategy runOnceCloudRetentionStrategy = this;
        synchronized (runOnceCloudRetentionStrategy) {
            if (this.isBeingTerminated()) {
                return false;
            }
        }
        return super.isAcceptingTasks((Computer)c);
    }

    private void done(Executor executor) {
        AbstractCloudComputer c = (AbstractCloudComputer)executor.getOwner();
        Queue.Executable exec = executor.getCurrentExecutable();
        LOGGER.log(Level.FINE, "terminating {0} since {1} seems to be finished", new Object[]{c.getName(), exec});
        this.done(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done(AbstractCloudComputer<?> c) {
        String cname = c.getName();
        RunOnceCloudRetentionStrategy runOnceCloudRetentionStrategy = this;
        synchronized (runOnceCloudRetentionStrategy) {
            if (this.isBeingTerminated()) {
                LOGGER.log(Level.FINER, "Termination of {0} is already in progress.", cname);
                return;
            }
            LOGGER.log(Level.FINER, "Initiating termination of {0}.", cname);
            this.setBeingTerminated();
        }
        VSphereOfflineCause cause = new VSphereOfflineCause(Messages._runOnceCloudRetentionStrategy_OfflineReason_BuildHasRun());
        c.disconnect((OfflineCause)cause);
        try {
            AbstractCloudSlave node = c.getNode();
            if (node != null) {
                LOGGER.log(Level.FINER, "Terminating {0} node {1}.", new Object[]{cname, node});
                node.terminate();
            } else {
                LOGGER.log(Level.FINER, "Not terminating {0} as its corresponding node has already been removed.", cname);
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to terminate " + cname, e);
            RunOnceCloudRetentionStrategy runOnceCloudRetentionStrategy2 = this;
            synchronized (runOnceCloudRetentionStrategy2) {
                this.clearBeingTerminated();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to terminate " + cname, e);
            RunOnceCloudRetentionStrategy runOnceCloudRetentionStrategy3 = this;
            synchronized (runOnceCloudRetentionStrategy3) {
                this.clearBeingTerminated();
            }
        }
    }

    private boolean isBeingTerminated() {
        return this.beingTerminated;
    }

    private void setBeingTerminated() {
        this.beingTerminated = true;
    }

    private void clearBeingTerminated() {
        this.beingTerminated = false;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "vSphere Run-Once Retention Strategy";
        }
    }
}

