/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.tools;

import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualMachineCloneSpec;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineQuestionInfo;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VirtualMachineSnapshotInfo;
import com.vmware.vim25.VirtualMachineSnapshotTree;
import com.vmware.vim25.VirtualMachineToolsStatus;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.vsphere.tools.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;

public class VSphere {
    private final URL url;
    private final String session;

    private VSphere(@Nonnull String url, @Nonnull String user, @CheckForNull String pw) throws VSphereException {
        try {
            this.url = new URL(url);
            this.session = new ServiceInstance(this.url, user, pw, true).getServerConnection().getSessionStr();
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    private ServiceInstance getServiceInstance() throws RemoteException, MalformedURLException {
        return new ServiceInstance(this.url, this.session, true);
    }

    public static VSphere connect(@Nonnull String server, @Nonnull String user, @CheckForNull String pw) throws VSphereException {
        return new VSphere(server, user, pw);
    }

    public static String vSphereOutput(String msg) {
        return (Messages.VSphereLogger_title() + ": ").concat(msg);
    }

    public void cloneVm(String cloneName, String sourceName, boolean linkedClone, String resourcePool, String cluster, String datastoreName) throws VSphereException {
        System.out.println("Creating a shallow clone of \"" + sourceName + "\" to \"" + cloneName + "\"");
        try {
            VirtualMachine sourceVm = this.getVmByName(sourceName);
            if (sourceVm == null) {
                throw new VSphereException("No VM or template " + sourceName + " found");
            }
            if (this.getVmByName(cloneName) != null) {
                throw new VSphereException("VM " + cloneName + " already exists");
            }
            VirtualMachineRelocateSpec rel = new VirtualMachineRelocateSpec();
            if (linkedClone) {
                rel.setDiskMoveType("createNewChildDiskBacking");
            } else {
                rel.setDiskMoveType("moveAllDiskBackingsAndDisallowSharing");
            }
            ClusterComputeResource clusterResource = this.getClusterByName(cluster);
            rel.setPool(this.getResourcePoolByName(resourcePool, (ManagedEntity)clusterResource).getMOR());
            VirtualMachineCloneSpec cloneSpec = new VirtualMachineCloneSpec();
            cloneSpec.setLocation(rel);
            cloneSpec.setTemplate(false);
            if (datastoreName != null && !datastoreName.isEmpty()) {
                Datastore datastore = this.getDatastoreByName(datastoreName, (ManagedEntity)clusterResource);
                if (datastore == null) {
                    System.out.println("Datastore not found!");
                    throw new VSphereException("Datastore not found!");
                }
                rel.setDatastore(datastore.getMOR());
            }
            if (sourceVm.getCurrentSnapShot() == null) {
                throw new VSphereException("Source VM or Template \"" + sourceName + "\" requires at least one snapshot!");
            }
            cloneSpec.setSnapshot(sourceVm.getCurrentSnapShot().getMOR());
            Task task = sourceVm.cloneVM_Task((Folder)sourceVm.getParent(), cloneName, cloneSpec);
            System.out.println("Cloning VM. Please wait ...");
            String status = task.waitForTask();
            if (status == TaskInfoState.success.toString()) {
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        throw new VSphereException("Couldn't clone \"" + sourceName + "\"! Does \"" + cloneName + "\" already exist?");
    }

    public void reconfigureVm(String name, VirtualMachineConfigSpec spec) throws VSphereException {
        VirtualMachine vm = this.getVmByName(name);
        if (vm == null) {
            throw new VSphereException("No VM or template " + name + " found");
        }
        System.out.println("Reconfiguring VM. Please wait ...");
        try {
            Task task = vm.reconfigVM_Task(spec);
            String status = task.waitForTask();
            if (status.equals(TaskInfoState.success.toString())) {
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException("VM cannot be reconfigured:" + e.getMessage(), e);
        }
        throw new VSphereException("Couldn't reconfigure \"" + name + "\"!");
    }

    public void startVm(String name) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(name);
            if (this.isPoweredOn(vm)) {
                return;
            }
            if (vm.getConfig().template) {
                throw new VSphereException("VM represents a template!");
            }
            Task task = vm.powerOnVM_Task(null);
            int j = 12;
            for (int i = 0; i < j; ++i) {
                VirtualMachineQuestionInfo q;
                if (task.getTaskInfo().getState() == TaskInfoState.success) {
                    System.out.println("VM was powered up successfully.");
                    return;
                }
                if (task.getTaskInfo().getState() == TaskInfoState.running || task.getTaskInfo().getState() == TaskInfoState.queued) {
                    Thread.sleep(5000L);
                }
                if ((q = vm.getRuntime().getQuestion()) == null || !q.getId().equals("_vmx1")) continue;
                vm.answerVM(q.getId(), q.getChoice().getDefaultIndex().toString());
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException("VM cannot be started:", e);
        }
        throw new VSphereException("VM cannot be started");
    }

    private ManagedObjectReference findSnapshotInTree(VirtualMachineSnapshotTree[] snapTree, String snapName) {
        for (VirtualMachineSnapshotTree node : snapTree) {
            ManagedObjectReference mor;
            if (snapName.equals(node.getName())) {
                return node.getSnapshot();
            }
            VirtualMachineSnapshotTree[] childTree = node.getChildSnapshotList();
            if (childTree == null || (mor = this.findSnapshotInTree(childTree, snapName)) == null) continue;
            return mor;
        }
        return null;
    }

    public VirtualMachineSnapshot getSnapshotInTree(VirtualMachine vm, String snapName) {
        ManagedObjectReference mor;
        VirtualMachineSnapshotTree[] snapTree;
        if (vm == null || snapName == null) {
            return null;
        }
        VirtualMachineSnapshotInfo info = vm.getSnapshot();
        if (info != null && (snapTree = info.getRootSnapshotList()) != null && (mor = this.findSnapshotInTree(snapTree, snapName)) != null) {
            return new VirtualMachineSnapshot(vm.getServerConnection(), mor);
        }
        return null;
    }

    public void revertToSnapshot(String vmName, String snapName) throws VSphereException {
        VirtualMachine vm = this.getVmByName(vmName);
        VirtualMachineSnapshot snap = this.getSnapshotInTree(vm, snapName);
        if (snap == null) {
            throw new VSphereException("Virtual Machine snapshot cannot be found");
        }
        try {
            Task task = snap.revertToSnapshot_Task(null);
            if (!task.waitForTask().equals("success")) {
                throw new VSphereException("Could not revert to snapshot");
            }
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    public void deleteSnapshot(String vmName, String snapName, boolean consolidate, boolean failOnNoExist) throws VSphereException {
        VirtualMachine vm = this.getVmByName(vmName);
        VirtualMachineSnapshot snap = this.getSnapshotInTree(vm, snapName);
        if (snap == null && failOnNoExist) {
            throw new VSphereException("Virtual Machine snapshot cannot be found");
        }
        try {
            Task task;
            if (snap != null && !(task = snap.removeSnapshot_Task(false)).waitForTask().equals("success")) {
                throw new VSphereException("Could not delete snapshot");
            }
            if (!consolidate) {
                return;
            }
            task = vm.consolidateVMDisks_Task();
            if (!task.waitForTask().equals("success")) {
                throw new VSphereException("Could not consolidate VM disks");
            }
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    public void takeSnapshot(String vmName, String snapshot, String description, boolean snapMemory) throws VSphereException {
        try {
            Task task = this.getVmByName(vmName).createSnapshot_Task(snapshot, description, snapMemory, !snapMemory);
            if (task.waitForTask() == "success") {
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException("Could not take snapshot", e);
        }
        throw new VSphereException("Could not take snapshot");
    }

    public void markAsTemplate(String vmName, String snapName, boolean force) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(vmName);
            if (vm.getConfig().template) {
                return;
            }
            if (this.isPoweredOff(vm) || force) {
                this.powerOffVm(vm, force, false);
                vm.markAsTemplate();
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException("Could not convert to Template", e);
        }
        throw new VSphereException("Could not mark as Template. Check it's power state or select \"force.\"");
    }

    public void markAsVm(String name, String resourcePool, String cluster) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(name);
            if (vm.getConfig().template) {
                vm.markAsVirtualMachine(this.getResourcePoolByName(resourcePool, (ManagedEntity)this.getClusterByName(cluster)), null);
            }
        }
        catch (Exception e) {
            throw new VSphereException("Could not convert to VM", e);
        }
    }

    public String getIp(VirtualMachine vm, int timeout) throws VSphereException {
        if (vm == null) {
            throw new VSphereException("VM is null");
        }
        int waitSeconds = 5;
        int maxTries = timeout <= 5 ? 1 : (int)Math.round((double)timeout / 5.0);
        for (int count = 0; count < maxTries; ++count) {
            if (vm.getGuest().getIpAddress() != null) {
                return vm.getGuest().getIpAddress();
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public VirtualMachine getVmByName(String vmName) throws VSphereException {
        try {
            return (VirtualMachine)new InventoryNavigator((ManagedEntity)this.getServiceInstance().getRootFolder()).searchManagedEntity("VirtualMachine", vmName);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    private Datastore getDatastoreByName(String datastoreName, ManagedEntity rootEntity) throws RemoteException, MalformedURLException {
        if (rootEntity == null) {
            rootEntity = this.getServiceInstance().getRootFolder();
        }
        return (Datastore)new InventoryNavigator(rootEntity).searchManagedEntity("Datastore", datastoreName);
    }

    public ManagedEntity[] getDatastores() throws VSphereException {
        try {
            return new InventoryNavigator((ManagedEntity)this.getServiceInstance().getRootFolder()).searchManagedEntities("Datastore");
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    private ResourcePool getResourcePoolByName(String poolName, ManagedEntity rootEntity) throws InvalidProperty, RuntimeFault, RemoteException, MalformedURLException {
        if (rootEntity == null) {
            rootEntity = this.getServiceInstance().getRootFolder();
        }
        return (ResourcePool)new InventoryNavigator(rootEntity).searchManagedEntity("ResourcePool", poolName);
    }

    private ClusterComputeResource getClusterByName(String clusterName, ManagedEntity rootEntity) throws InvalidProperty, RuntimeFault, RemoteException, MalformedURLException {
        if (rootEntity == null) {
            rootEntity = this.getServiceInstance().getRootFolder();
        }
        return (ClusterComputeResource)new InventoryNavigator(rootEntity).searchManagedEntity("ClusterComputeResource", clusterName);
    }

    private ClusterComputeResource getClusterByName(String clusterName) throws InvalidProperty, RuntimeFault, RemoteException, MalformedURLException {
        return this.getClusterByName(clusterName, null);
    }

    public void destroyVm(String name, boolean failOnNoExist) throws VSphereException {
        try {
            String status;
            VirtualMachine vm = this.getVmByName(name);
            if (vm == null) {
                if (failOnNoExist) {
                    throw new VSphereException("VM does not exist");
                }
                System.out.println("VM does not exist, or already deleted!");
                return;
            }
            if (!vm.getConfig().template) {
                this.powerOffVm(vm, true, false);
            }
            if ((status = vm.destroy_Task().waitForTask()) == "success") {
                System.out.println("VM was deleted successfully.");
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException(e.getMessage());
        }
        throw new VSphereException("Could not delete VM!");
    }

    public void renameVmSnapshot(String vmName, String oldName, String newName, String newDescription) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(vmName);
            if (vm == null) {
                throw new VSphereException("VM does not exist");
            }
            VirtualMachineSnapshot snapshot = this.getSnapshotInTree(vm, oldName);
            snapshot.renameSnapshot(newName, newDescription);
            System.out.println("VM Snapshot was renamed successfully.");
            return;
        }
        catch (Exception e) {
            throw new VSphereException(e.getMessage());
        }
    }

    public void renameVm(String oldName, String newName) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(oldName);
            if (vm == null) {
                throw new VSphereException("VM does not exist");
            }
            String status = vm.rename_Task(newName).waitForTask();
            if (status.equals("success")) {
                System.out.println("VM was renamed successfully.");
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException(e.getMessage());
        }
        throw new VSphereException("Could not rename VM!");
    }

    private boolean isSuspended(VirtualMachine vm) {
        return vm.getRuntime().getPowerState() == VirtualMachinePowerState.suspended;
    }

    private boolean isPoweredOn(VirtualMachine vm) {
        return vm.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOn;
    }

    private boolean isPoweredOff(VirtualMachine vm) {
        return vm.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOff;
    }

    public boolean vmToolIsEnabled(VirtualMachine vm) {
        VirtualMachineToolsStatus status = vm.getGuest().toolsStatus;
        return status == VirtualMachineToolsStatus.toolsOk || status == VirtualMachineToolsStatus.toolsOld;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void powerOffVm(VirtualMachine vm, boolean evenIfSuspended, boolean shutdownGracefully) throws VSphereException {
        if (vm.getConfig().template) {
            throw new VSphereException("VM represents a template!");
        }
        if (this.isPoweredOn(vm) || evenIfSuspended && this.isSuspended(vm)) {
            boolean doHardShutdown = true;
            try {
                if (!this.isSuspended(vm) && shutdownGracefully && this.vmToolIsEnabled(vm)) {
                    System.out.println("Requesting guest shutdown");
                    vm.shutdownGuest();
                    for (int i = 0; i <= 180; ++i) {
                        Thread.sleep(1000L);
                        if (!this.isPoweredOff(vm)) continue;
                        doHardShutdown = false;
                        System.out.println("VM gracefully powered down successfully.");
                        return;
                    }
                }
                if (!doHardShutdown) throw new VSphereException("Machine could not be powered down!");
                System.out.println("Powering off the VM");
                String status = vm.powerOffVM_Task().waitForTask();
                if (status != "success") throw new VSphereException("Machine could not be powered down!");
                System.out.println("VM was powered down successfully.");
                return;
            }
            catch (Exception e) {
                throw new VSphereException(e);
            }
        } else {
            if (!this.isPoweredOff(vm)) throw new VSphereException("Machine could not be powered down!");
            System.out.println("Machine is already off.");
            return;
        }
    }

    public void suspendVm(VirtualMachine vm) throws VSphereException {
        if (this.isPoweredOn(vm)) {
            String status;
            try {
                status = vm.suspendVM_Task().waitForTask();
            }
            catch (Exception e) {
                throw new VSphereException(e);
            }
            if (status == "success") {
                System.out.println("VM was suspended successfully.");
                return;
            }
        } else {
            System.out.println("Machine not powered on.");
            return;
        }
        throw new VSphereException("Machine could not be suspended!");
    }
}

