/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.CommandLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudProvisionedSlave;
import org.jenkinsci.plugins.vsphere.RunOnceCloudRetentionStrategy;
import org.jenkinsci.plugins.vsphere.VSphereCloudRetentionStrategy;
import org.jenkinsci.plugins.vsphere.VSphereConnectionConfig;
import org.jenkinsci.plugins.vsphere.VSphereGuestInfoProperty;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereDuplicateException;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class vSphereCloudSlaveTemplate
implements Describable<vSphereCloudSlaveTemplate> {
    private static final Logger LOGGER = Logger.getLogger(vSphereCloudSlaveTemplate.class.getName());
    private static final String VSPHERE_ATTR_FOR_JENKINSURL = vSphereCloudSlaveTemplate.class.getSimpleName() + ".jenkinsUrl";
    protected static final SchemeRequirement HTTP_SCHEME = new SchemeRequirement("http");
    protected static final SchemeRequirement HTTPS_SCHEME = new SchemeRequirement("https");
    private int configVersion = 1;
    private static final int CURRENT_CONFIG_VERSION = 1;
    private String cloneNamePrefix;
    private final String masterImageName;
    private Boolean useSnapshot;
    private final String snapshotName;
    private final boolean linkedClone;
    private final String cluster;
    private final String resourcePool;
    private final String datastore;
    private final String folder;
    private final String customizationSpec;
    private final String templateDescription;
    private int templateInstanceCap;
    private final int numberOfExecutors;
    private final String remoteFS;
    private final String labelString;
    private final Node.Mode mode;
    private final boolean forceVMLaunch;
    private final boolean waitForVMTools;
    private final int launchDelay;
    private final int limitedRunCount;
    private final boolean saveFailure;
    private final String targetResourcePool;
    private final String targetHost;
    @Deprecated
    private final transient String credentialsId;
    private final List<? extends NodeProperty<?>> nodeProperties;
    private final List<? extends VSphereGuestInfoProperty> guestInfoProperties;
    private ComputerLauncher launcher;
    private RetentionStrategy<?> retentionStrategy;
    private transient Set<LabelAtom> labelSet;
    protected transient vSphereCloud parent;

    @DataBoundConstructor
    public vSphereCloudSlaveTemplate(String cloneNamePrefix, String masterImageName, Boolean useSnapshot, String snapshotName, boolean linkedClone, String cluster, String resourcePool, String datastore, String folder, String customizationSpec, String templateDescription, int templateInstanceCap, int numberOfExecutors, String remoteFS, String labelString, Node.Mode mode, boolean forceVMLaunch, boolean waitForVMTools, int launchDelay, int limitedRunCount, boolean saveFailure, String targetResourcePool, String targetHost, String credentialsId, ComputerLauncher launcher, RetentionStrategy<?> retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, List<? extends VSphereGuestInfoProperty> guestInfoProperties) {
        this.cloneNamePrefix = cloneNamePrefix;
        this.masterImageName = masterImageName;
        this.snapshotName = snapshotName;
        this.useSnapshot = useSnapshot;
        this.linkedClone = linkedClone;
        this.cluster = cluster;
        this.resourcePool = resourcePool;
        this.datastore = datastore;
        this.folder = folder;
        this.customizationSpec = customizationSpec;
        this.templateDescription = templateDescription;
        this.templateInstanceCap = templateInstanceCap;
        this.numberOfExecutors = numberOfExecutors;
        this.remoteFS = remoteFS;
        this.labelString = labelString;
        this.mode = mode;
        this.forceVMLaunch = forceVMLaunch;
        this.waitForVMTools = waitForVMTools;
        this.launchDelay = launchDelay;
        this.limitedRunCount = limitedRunCount;
        this.saveFailure = saveFailure;
        this.targetResourcePool = targetResourcePool;
        this.targetHost = targetHost;
        this.credentialsId = credentialsId;
        this.nodeProperties = nodeProperties;
        this.guestInfoProperties = guestInfoProperties;
        this.launcher = launcher;
        this.retentionStrategy = retentionStrategy;
        this.readResolve();
    }

    public String getCloneNamePrefix() {
        return this.cloneNamePrefix;
    }

    public String getMasterImageName() {
        return this.masterImageName;
    }

    public boolean getUseSnapshot() {
        return this.useSnapshot;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public boolean getLinkedClone() {
        return this.linkedClone;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    public String getDatastore() {
        return this.datastore;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getCustomizationSpec() {
        return this.customizationSpec;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public int getTemplateInstanceCap() {
        if (this.templateInstanceCap == Integer.MAX_VALUE) {
            return 0;
        }
        return this.templateInstanceCap;
    }

    public int getNumberOfExecutors() {
        return this.numberOfExecutors;
    }

    public String getRemoteFS() {
        return this.remoteFS;
    }

    public String getLabelString() {
        return this.labelString;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public boolean getForceVMLaunch() {
        return this.forceVMLaunch;
    }

    public boolean getWaitForVMTools() {
        return this.waitForVMTools;
    }

    public int getLaunchDelay() {
        return this.launchDelay;
    }

    public int getLimitedRunCount() {
        return this.limitedRunCount;
    }

    public boolean getSaveFailure() {
        return this.saveFailure;
    }

    public String getTargetResourcePool() {
        return this.targetResourcePool;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    @Deprecated
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public List<? extends NodeProperty<?>> getNodeProperties() {
        return this.nodeProperties;
    }

    public List<? extends VSphereGuestInfoProperty> getGuestInfoProperties() {
        return this.guestInfoProperties;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public vSphereCloud getParent() {
        return this.parent;
    }

    public ComputerLauncher getLauncher() {
        return this.launcher;
    }

    public RetentionStrategy<?> getRetentionStrategy() {
        return this.retentionStrategy;
    }

    protected Object readResolve() {
        this.labelSet = Label.parse((String)this.labelString);
        if (this.templateInstanceCap == 0) {
            this.templateInstanceCap = Integer.MAX_VALUE;
        }
        if (this.useSnapshot == null) {
            this.useSnapshot = this.snapshotName != null;
        }
        if (this.launcher == null) {
            LOGGER.log(Level.CONFIG, "{0} loaded old configuration that had hard-coded SSHLauncher.", this);
            try {
                String oldCredentialsIdOrNull = this.getCredentialsId();
                String oldCredentialsId = oldCredentialsIdOrNull == null ? "" : oldCredentialsIdOrNull;
                this.launcher = new SSHLauncher(null, 0, oldCredentialsId, null, null, null, null, Integer.valueOf(this.launchDelay), Integer.valueOf(3), Integer.valueOf(60));
                LOGGER.log(Level.CONFIG, " - now configured to use {0}(..., {1}, ...)", new Object[]{this.launcher.getClass().getSimpleName(), oldCredentialsId});
            }
            catch (Exception ex) {
                LOGGER.log(Level.CONFIG, " - Failed to reconfigure launcher", ex);
            }
        }
        if (this.retentionStrategy == null) {
            LOGGER.log(Level.CONFIG, "{0} loaded old configuration that had hard-coded RunOnceCloudRetentionStrategy.", this);
            try {
                int oldTimeout = 2;
                this.retentionStrategy = new RunOnceCloudRetentionStrategy(2);
                LOGGER.log(Level.CONFIG, " - now configured to use {0}({1})", new Object[]{this.retentionStrategy.getClass().getSimpleName(), 2});
            }
            catch (Exception ex) {
                LOGGER.log(Level.CONFIG, " - Failed to reconfigure strategy", ex);
            }
        }
        if (this.configVersion <= 0) {
            LOGGER.log(Level.CONFIG, "{0} loaded old configuration that had hard-coded underscore at the end of the cloneNamePrefix.", this);
            this.cloneNamePrefix = this.cloneNamePrefix + "_";
            this.configVersion = 1;
        }
        if (this.configVersion < 1) {
            throw new IllegalStateException("Internal error: configVersion==" + this.configVersion + " at end of readResolve method, but the current config version should be " + 1 + ".  Either CURRENT_CONFIG_VERSION is incorrect or the readResolve method is not setting configVersion when it upgrades the data.");
        }
        if (this.configVersion > 1) {
            LOGGER.log(Level.WARNING, "{0} was defined by a later version of the plugin (one that saved with configVersion={1}, whereas this version of the plugin is expecting {2}).  The code may not function as expected.", new Object[]{this, this.configVersion, 1});
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public vSphereCloudProvisionedSlave provision(String cloneName, TaskListener listener) throws VSphereException, Descriptor.FormException, IOException, InterruptedException {
        vSphereCloudProvisionedSlave slave;
        PrintStream logger = listener.getLogger();
        Map<String, String> resolvedExtraConfigParameters = this.calculateExtraConfigParameters(cloneName, listener);
        VSphere vSphere = this.getParent().vSphereInstance();
        try {
            slave = this.provision(cloneName, logger, resolvedExtraConfigParameters, vSphere);
        }
        finally {
            vSphere.disconnect();
        }
        return slave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private vSphereCloudProvisionedSlave provision(String cloneName, PrintStream logger, Map<String, String> resolvedExtraConfigParameters, VSphere vSphere) throws VSphereException, Descriptor.FormException, IOException {
        String snapshotToUse;
        boolean useCurrentSnapshot;
        boolean POWER_ON = true;
        if (this.getUseSnapshot()) {
            String sn = this.getSnapshotName();
            if (sn != null && !sn.isEmpty()) {
                useCurrentSnapshot = false;
                snapshotToUse = sn;
            } else {
                useCurrentSnapshot = true;
                snapshotToUse = null;
            }
        } else {
            useCurrentSnapshot = false;
            snapshotToUse = null;
        }
        try {
            vSphere.cloneOrDeployVm(cloneName, this.masterImageName, this.linkedClone, this.resourcePool, this.cluster, this.datastore, this.folder, useCurrentSnapshot, snapshotToUse, true, resolvedExtraConfigParameters, this.customizationSpec, logger);
            LOGGER.log(Level.FINE, "Created new VM {0} from image {1}", new Object[]{cloneName, this.masterImageName});
        }
        catch (VSphereDuplicateException ex) {
            String vmJenkinsUrl = vSphereCloudSlaveTemplate.findWhichJenkinsThisVMBelongsTo(vSphere, cloneName);
            if (vmJenkinsUrl == null) {
                LOGGER.log(Level.SEVERE, "VM {0} name clashes with one we wanted to use, but it wasn't started by this plugin.", cloneName);
                throw ex;
            }
            String ourJenkinsUrl = Jenkins.getActiveInstance().getRootUrl();
            if (vmJenkinsUrl.equals(ourJenkinsUrl)) {
                LOGGER.log(Level.INFO, "Found existing VM {0} that we started previously (and must have either lost track of it or failed to delete it).", cloneName);
            }
            LOGGER.log(Level.SEVERE, "VM {0} name clashes with one we wanted to use, but it doesn't belong to this Jenkins server: it belongs to {1}.  You MUST reconfigure one of these Jenkins servers to use a different naming strategy so that we no longer get clashes within vSphere host {2}. i.e. change the cloneNamePrefix on one/both to ensure uniqueness.", new Object[]{cloneName, vmJenkinsUrl, this.getParent().getVsHost()});
            throw ex;
        }
        catch (VSphereException ex) {
            try {
                vSphere.destroyVm(cloneName, false);
            }
            catch (Exception logOnly) {
                LOGGER.log(Level.SEVERE, "Unable to create and power-on new VM " + cloneName + " (cloned from image " + this.masterImageName + ") and, worse, bits of the VM may still exist as the attempt to delete the remains also failed.", logOnly);
            }
            throw ex;
        }
        vSphereCloudProvisionedSlave slave = null;
        try {
            ComputerLauncher configuredLauncher = this.determineLauncher(vSphere, cloneName);
            RetentionStrategy<?> configuredStrategy = this.determineRetention();
            String snapshotNameForLauncher = "";
            slave = new vSphereCloudProvisionedSlave(cloneName, this.templateDescription, this.remoteFS, String.valueOf(this.numberOfExecutors), this.mode, this.labelString, configuredLauncher, configuredStrategy, this.nodeProperties, this.parent.getVsDescription(), cloneName, this.forceVMLaunch, this.waitForVMTools, "", String.valueOf(this.launchDelay), null, String.valueOf(this.limitedRunCount));
        }
        finally {
            if (slave == null) {
                LOGGER.log(Level.FINER, "Creation of slave failed after cloning VM: destroying clone {0}", cloneName);
                vSphere.destroyVm(cloneName, false);
            }
        }
        return slave;
    }

    private ComputerLauncher determineLauncher(VSphere vSphere, String cloneName) throws VSphereException {
        if (this.launcher instanceof JNLPLauncher) {
            return this.launcher;
        }
        if (this.launcher instanceof CommandLauncher) {
            return this.launcher;
        }
        if (this.launcher instanceof SSHLauncher) {
            SSHLauncher sshLauncher = (SSHLauncher)this.launcher;
            LOGGER.log(Level.FINER, "Slave {0} uses SSHLauncher - obtaining IP address...", cloneName);
            String ip = vSphere.getIp(vSphere.getVmByName(cloneName), 1000);
            LOGGER.log(Level.FINER, "Slave {0} has IP address {1}", new Object[]{cloneName, ip});
            SSHLauncher launcherWithIPAddress = new SSHLauncher(ip, sshLauncher.getPort(), sshLauncher.getCredentialsId(), sshLauncher.getJvmOptions(), sshLauncher.getJavaPath(), sshLauncher.getPrefixStartSlaveCmd(), sshLauncher.getSuffixStartSlaveCmd(), sshLauncher.getLaunchTimeoutSeconds(), sshLauncher.getMaxNumRetries(), sshLauncher.getRetryWaitTime());
            return launcherWithIPAddress;
        }
        throw new IllegalStateException("Unsupported launcher (" + this.launcher + ") in template configuration");
    }

    private RetentionStrategy<?> determineRetention() {
        if (this.retentionStrategy instanceof RunOnceCloudRetentionStrategy) {
            RunOnceCloudRetentionStrategy templateStrategy = (RunOnceCloudRetentionStrategy)this.retentionStrategy;
            RunOnceCloudRetentionStrategy cloneStrategy = new RunOnceCloudRetentionStrategy(templateStrategy.getIdleMinutes());
            return cloneStrategy;
        }
        if (this.retentionStrategy instanceof VSphereCloudRetentionStrategy) {
            VSphereCloudRetentionStrategy templateStrategy = (VSphereCloudRetentionStrategy)this.retentionStrategy;
            VSphereCloudRetentionStrategy cloneStrategy = new VSphereCloudRetentionStrategy(templateStrategy.getIdleMinutes());
            return cloneStrategy;
        }
        throw new IllegalStateException("Unsupported retentionStrategy (" + this.retentionStrategy + ") in template configuration");
    }

    public Descriptor<vSphereCloudSlaveTemplate> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getClass());
    }

    private static String findWhichJenkinsThisVMBelongsTo(VSphere vSphere, String cloneName) {
        VirtualMachine vm;
        try {
            vm = vSphere.getVmByName(cloneName);
        }
        catch (VSphereException e) {
            return null;
        }
        VirtualMachineConfigInfo config = vm.getConfig();
        if (config == null) {
            return null;
        }
        OptionValue[] extraConfigs = config.extraConfig;
        if (extraConfigs == null) {
            return null;
        }
        String vmJenkinsUrl = null;
        for (OptionValue ec : extraConfigs) {
            String configValue;
            String configName = ec.key;
            String string = configValue = ec.value == null ? null : ec.value.toString();
            if (!VSPHERE_ATTR_FOR_JENKINSURL.equals(configName)) continue;
            vmJenkinsUrl = configValue;
        }
        return vmJenkinsUrl;
    }

    private Map<String, String> calculateExtraConfigParameters(String cloneName, TaskListener listener) throws IOException, InterruptedException {
        List<VSphereGuestInfoProperty> guestInfoConfig;
        EnvVars knownVariables = this.calculateVariablesForGuestInfo(cloneName, listener);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String jenkinsUrl = Jenkins.getActiveInstance().getRootUrl();
        if (jenkinsUrl != null) {
            result.put(VSPHERE_ATTR_FOR_JENKINSURL, jenkinsUrl);
        }
        if ((guestInfoConfig = this.guestInfoProperties) == null) {
            guestInfoConfig = Collections.emptyList();
        }
        for (VSphereGuestInfoProperty vSphereGuestInfoProperty : guestInfoConfig) {
            String name = vSphereGuestInfoProperty.getName();
            String configuredValue = vSphereGuestInfoProperty.getValue();
            String resolvedValue = Util.replaceMacro((String)configuredValue, (Map)knownVariables);
            result.put("guestinfo." + name, resolvedValue);
        }
        return result;
    }

    private EnvVars calculateVariablesForGuestInfo(String cloneName, TaskListener listener) throws IOException, InterruptedException {
        String slaveSecret;
        EnvVars knownVariables = new EnvVars();
        String jenkinsUrl = Jenkins.getActiveInstance().getRootUrl();
        if (jenkinsUrl != null) {
            vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "JENKINS_URL", jenkinsUrl);
            vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "HUDSON_URL", jenkinsUrl);
        }
        if ((slaveSecret = JnlpSlaveAgentProtocol.SLAVE_SECRET.mac(cloneName)) != null) {
            vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "JNLP_SECRET", slaveSecret);
        }
        vSphereCloudSlaveTemplate.addEnvVars(knownVariables, listener, Jenkins.getInstance().getGlobalNodeProperties());
        vSphereCloudSlaveTemplate.addEnvVars(knownVariables, listener, this.nodeProperties);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "NODE_NAME", cloneName);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "NODE_LABELS", this.getLabelSet() == null ? null : Util.join(this.getLabelSet(), (String)" "));
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "cluster", this.cluster);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "datastore", this.datastore);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "folder", this.folder);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "customizationSpec", this.customizationSpec);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "labelString", this.labelString);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "masterImageName", this.masterImageName);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "remoteFS", this.remoteFS);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "snapshotName", this.snapshotName);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "targetHost", this.targetHost);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "templateDescription", this.templateDescription);
        return knownVariables;
    }

    private static void addEnvVars(EnvVars vars, TaskListener listener, Iterable<? extends NodeProperty<?>> nodeProperties) throws IOException, InterruptedException {
        if (nodeProperties != null) {
            for (NodeProperty<?> nodeProperty : nodeProperties) {
                nodeProperty.buildEnvVars(vars, listener);
            }
        }
    }

    private static void addEnvVar(EnvVars vars, String name, Object valueOrNull) {
        vars.put(name, valueOrNull == null ? "" : valueOrNull.toString());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<vSphereCloudSlaveTemplate> {
        public String getDisplayName() {
            return null;
        }

        public FormValidation doCheckCloneNamePrefix(@QueryParameter String cloneNamePrefix) {
            return FormValidation.validateRequired((String)cloneNamePrefix);
        }

        public FormValidation doCheckLimitedRunCount(@QueryParameter String limitedRunCount) {
            return FormValidation.validateNonNegativeInteger((String)limitedRunCount);
        }

        public FormValidation doCheckTemplateInstanceCap(@QueryParameter String templateInstanceCap) {
            return FormValidation.validateNonNegativeInteger((String)templateInstanceCap);
        }

        public FormValidation doCheckNumberOfExecutors(@QueryParameter String numberOfExecutors) {
            return FormValidation.validatePositiveInteger((String)numberOfExecutors);
        }

        public FormValidation doCheckLinkedClone(@QueryParameter boolean linkedClone, @QueryParameter boolean useSnapshot) {
            boolean noSnapshot;
            boolean bl = noSnapshot = !useSnapshot;
            if (linkedClone && noSnapshot) {
                return FormValidation.warning((String)"Linked clones are based upon a snapshot.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckLaunchDelay(@QueryParameter String launchDelay) {
            return FormValidation.validateNonNegativeInteger((String)launchDelay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @RequirePOST
        public FormValidation doTestCloneParameters(@AncestorInPath AbstractFolder<?> containingFolderOrNull, @QueryParameter String vsHost, @QueryParameter boolean allowUntrustedCertificate, @QueryParameter String credentialsId, @QueryParameter String masterImageName, @QueryParameter boolean linkedClone, @QueryParameter boolean useSnapshot, @QueryParameter String snapshotName) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureCloud(containingFolderOrNull);
            try {
                VSphereConnectionConfig config = new VSphereConnectionConfig(vsHost, allowUntrustedCertificate, credentialsId);
                VSphere vsphere = VSphere.connect(config);
                try {
                    VirtualMachine vm = vsphere.getVmByName(masterImageName);
                    if (vm == null) {
                        FormValidation formValidation = FormValidation.error((String)Messages.validation_notFound("master image \"" + masterImageName + "\""));
                        return formValidation;
                    }
                    if (useSnapshot) {
                        VirtualMachineSnapshot snapshot;
                        if (snapshotName != null && !snapshotName.isEmpty()) {
                            snapshot = vsphere.getSnapshotInTree(vm, snapshotName);
                            if (snapshot == null) {
                                FormValidation formValidation = FormValidation.error((String)Messages.validation_notFound("snapshot \"" + snapshotName + "\""));
                                return formValidation;
                            }
                        } else {
                            snapshot = vm.getCurrentSnapShot();
                            if (snapshot == null) {
                                FormValidation formValidation = FormValidation.error((String)"No snapshots found.");
                                return formValidation;
                            }
                        }
                    } else if (linkedClone) {
                        FormValidation formValidation = FormValidation.warning((String)"vSphere doesn't like creating linked clones without a snapshot");
                        return formValidation;
                    }
                    FormValidation formValidation = FormValidation.ok((String)Messages.validation_success());
                    return formValidation;
                }
                finally {
                    vsphere.disconnect();
                }
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Problem validating");
            }
        }

        public static List<Descriptor<ComputerLauncher>> getLauncherDescriptors() {
            List<String> supportedLaunchers = Arrays.asList(SSHLauncher.class.getName(), CommandLauncher.class.getName(), JNLPLauncher.class.getName());
            DescriptorExtensionList knownLaunchers = Jenkins.getInstance().getDescriptorList(ComputerLauncher.class);
            ArrayList<Descriptor<ComputerLauncher>> result = new ArrayList<Descriptor<ComputerLauncher>>(knownLaunchers.size());
            for (Descriptor knownLauncher : knownLaunchers) {
                if (!supportedLaunchers.contains(knownLauncher.getId())) continue;
                result.add((Descriptor<ComputerLauncher>)knownLauncher);
            }
            return result;
        }

        public static List<Descriptor<RetentionStrategy<?>>> getRetentionStrategyDescriptors() {
            ArrayList result = new ArrayList();
            result.add(RunOnceCloudRetentionStrategy.DESCRIPTOR);
            result.add(VSphereCloudRetentionStrategy.DESCRIPTOR);
            return result;
        }
    }
}

