/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.tools;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class PermissionUtils {
    private PermissionUtils() {
    }

    @Restricted(value={NoExternalUse.class})
    public static void throwUnlessUserHasPermissionToConfigureSlave(ItemGroup<?> context) {
        PermissionUtils.checkPermission(context, Computer.CONFIGURE);
    }

    @Restricted(value={NoExternalUse.class})
    public static void throwUnlessUserHasPermissionToConfigureCloud(AbstractFolder<?> folderContextOrNull) {
        PermissionUtils.checkPermission(folderContextOrNull, Item.CONFIGURE);
    }

    @Restricted(value={NoExternalUse.class})
    public static void throwUnlessUserHasPermissionToConfigureJob(Item context) {
        PermissionUtils.checkPermission(context, Item.CONFIGURE);
    }

    @Restricted(value={NoExternalUse.class})
    public static void throwUnlessUserHasPermissionToAccessJob(Item context) {
        PermissionUtils.checkPermission(context, Item.READ);
    }

    private static void checkPermission(Object c, Permission allowablePermission) {
        Jenkins ac = c instanceof AccessControlled ? (AccessControlled)c : Jenkins.getInstance();
        ac.checkPermission(allowablePermission);
    }
}

