/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere;

import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.slaves.Cloud;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.folder.FolderVSphereCloudProperty;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.PermissionUtils;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSphereBuildStepContainer
extends Builder
implements SimpleBuildStep {
    public static final String SELECTABLE_SERVER_NAME = "${VSPHERE_CLOUD_NAME}";
    private final VSphereBuildStep buildStep;
    private final String serverName;
    private final Integer serverHash;

    @DataBoundConstructor
    public VSphereBuildStepContainer(VSphereBuildStep buildStep, String serverName) throws VSphereException {
        this.buildStep = buildStep;
        this.serverName = serverName;
        this.serverHash = !SELECTABLE_SERVER_NAME.equals(serverName) ? Integer.valueOf(VSphereBuildStep.VSphereBuildStepDescriptor.getVSphereCloudByName(serverName, null).getHash()) : null;
    }

    public String getServerName() {
        return this.serverName;
    }

    public VSphereBuildStep getBuildStep() {
        return this.buildStep;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        VSphere vsphere = null;
        try {
            String expandedServerName = this.serverName;
            if (run instanceof AbstractBuild) {
                EnvVars env = run.getEnvironment(listener);
                env.overrideAll(((AbstractBuild)run).getBuildVariables());
                expandedServerName = env.expand(this.serverName);
            }
            this.startLogs(listener.getLogger(), expandedServerName);
            vsphere = this.serverHash != null ? VSphereBuildStep.VSphereBuildStepDescriptor.getVSphereCloudByHash(this.serverHash, (String)run.getEnvironment(listener).get((Object)"JOB_NAME")).vSphereInstance() : VSphereBuildStep.VSphereBuildStepDescriptor.getVSphereCloudByName(expandedServerName, (String)run.getEnvironment(listener).get((Object)"JOB_NAME")).vSphereInstance();
            this.buildStep.setVsphere(vsphere);
            if (run instanceof AbstractBuild) {
                this.buildStep.perform((AbstractBuild)run, launcher, (BuildListener)listener);
            } else {
                this.buildStep.perform(run, filePath, launcher, listener);
            }
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
        finally {
            if (vsphere != null) {
                vsphere.disconnect();
            }
        }
    }

    private void startLogs(PrintStream logger, String serverName) {
        VSphereLogger.vsLogger(logger, "");
        VSphereLogger.vsLogger(logger, Messages.console_buildStepStart(this.buildStep.getDescriptor().getDisplayName()));
        VSphereLogger.vsLogger(logger, Messages.console_usingServerConfig(serverName));
    }

    @Extension
    public static final class VSphereBuildStepContainerDescriptor
    extends BuildStepDescriptor<Builder> {
        private static final Logger LOGGER = LoggerFactory.getLogger(VSphereBuildStepContainerDescriptor.class);

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("org.jenkinsci.plugins.vsphere.builders.VSphereBuildStepContainer", VSphereBuildStepContainer.class);
        }

        public String getDisplayName() {
            return Messages.plugin_title_BuildStep();
        }

        public DescriptorExtensionList<VSphereBuildStep, VSphereBuildStep.VSphereBuildStepDescriptor> getBuildSteps() {
            return VSphereBuildStep.all();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillServerNameItems(@AncestorInPath Item context) {
            PermissionUtils.throwUnlessUserHasPermissionToConfigureJob(context);
            boolean hasVsphereClouds = false;
            ListBoxModel select = new ListBoxModel();
            Folder prevFolder = null;
            try {
                String[] path = Stapler.getCurrentRequest().getRequestURI().split("/");
                for (String item : path) {
                    if (item.equals("job") || item.equals("jenkins")) continue;
                    TopLevelItem topLevelItem = null;
                    if (prevFolder == null) {
                        topLevelItem = Jenkins.getActiveInstance().getItem(item);
                    } else {
                        Collection items = prevFolder.getItems();
                        for (TopLevelItem levelItem : items) {
                            if (!levelItem.getName().endsWith(item)) continue;
                            topLevelItem = levelItem;
                        }
                    }
                    if (topLevelItem == null || !(topLevelItem instanceof Folder)) continue;
                    prevFolder = (Folder)topLevelItem;
                    hasVsphereClouds = this.extractCloudNames(hasVsphereClouds, select, prevFolder);
                }
                for (Cloud cloud : Jenkins.getInstance().clouds) {
                    if (!(cloud instanceof vSphereCloud)) continue;
                    hasVsphereClouds = true;
                    select.add(((vSphereCloud)cloud).getVsDescription());
                }
                if (hasVsphereClouds) {
                    select.add(VSphereBuildStepContainer.SELECTABLE_SERVER_NAME);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.toString(), (Throwable)e);
            }
            return select;
        }

        private boolean extractCloudNames(boolean hasVsphereClouds, ListBoxModel select, Folder folder) {
            DescribableList properties = folder.getProperties();
            for (AbstractFolderProperty property : properties) {
                if (!(property instanceof FolderVSphereCloudProperty)) continue;
                FolderVSphereCloudProperty vSphereCloudProperty = (FolderVSphereCloudProperty)property;
                for (vSphereCloud vSphereCloud2 : vSphereCloudProperty.getClouds()) {
                    select.add(vSphereCloud2.getVsDescription());
                }
                hasVsphereClouds = true;
            }
            return hasVsphereClouds;
        }
    }
}

