/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere;

import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.EphemeralNode;
import hudson.slaves.RetentionStrategy;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class RunOnceCloudRetentionStrategy
extends CloudRetentionStrategy
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(RunOnceCloudRetentionStrategy.class.getName());
    private final int idleMinutes;
    private transient Set<AbstractCloudComputer<?>> beingTerminated;
    @Restricted(value={NoExternalUse.class})
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RunOnceCloudRetentionStrategy(int idleMinutes) {
        super(idleMinutes);
        this.idleMinutes = idleMinutes;
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    public long check(AbstractCloudComputer c) {
        long idleMilliseconds;
        if (c.isIdle() && !disabled && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > TimeUnit2.MINUTES.toMillis((long)this.idleMinutes)) {
            LOGGER.log(Level.FINE, "Disconnecting {0} because it has been idle for more than {1} minutes (has been idle for {2}ms)", new Object[]{c.getName(), this.idleMinutes, idleMilliseconds});
            this.done(c);
        }
        return 1L;
    }

    public void start(AbstractCloudComputer c) {
        if (c.getNode() instanceof EphemeralNode) {
            throw new IllegalStateException("May not use " + RunOnceCloudRetentionStrategy.class.getSimpleName() + " on an " + EphemeralNode.class.getSimpleName() + ": " + c);
        }
        super.start(c);
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.done(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.done(executor);
    }

    private void done(Executor executor) {
        AbstractCloudComputer c = (AbstractCloudComputer)executor.getOwner();
        Queue.Executable exec = executor.getCurrentExecutable();
        LOGGER.log(Level.FINE, "terminating {0} since {1} seems to be finished", new Object[]{c.getName(), exec});
        this.done(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done(final AbstractCloudComputer<?> c) {
        c.setAcceptingTasks(false);
        final String cname = c.getName();
        RunOnceCloudRetentionStrategy runOnceCloudRetentionStrategy = this;
        synchronized (runOnceCloudRetentionStrategy) {
            if (this.isBeingTerminated(c)) {
                LOGGER.log(Level.FINER, "Termination of {0} is already in progress.", cname);
                return;
            }
            LOGGER.log(Level.FINER, "Initiating termination of {0}.", cname);
            this.setBeingTerminated(c);
        }
        Computer.threadPoolForRemoting.submit(new Runnable(){

            @Override
            public void run() {
                Queue.withLock((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            AbstractCloudSlave node = c.getNode();
                            if (node != null) {
                                LOGGER.log(Level.FINER, "Terminating {0} node {1}.", new Object[]{cname, node});
                                node.terminate();
                            } else {
                                LOGGER.log(Level.FINER, "Not terminating {0} as its corresponding node has already been removed.", cname);
                            }
                        }
                        catch (InterruptedException e) {
                            LOGGER.log(Level.WARNING, "Failed to terminate " + cname, e);
                            RunOnceCloudRetentionStrategy runOnceCloudRetentionStrategy = RunOnceCloudRetentionStrategy.this;
                            synchronized (runOnceCloudRetentionStrategy) {
                                RunOnceCloudRetentionStrategy.this.clearBeingTerminated(c);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Failed to terminate " + cname, e);
                            RunOnceCloudRetentionStrategy runOnceCloudRetentionStrategy = RunOnceCloudRetentionStrategy.this;
                            synchronized (runOnceCloudRetentionStrategy) {
                                RunOnceCloudRetentionStrategy.this.clearBeingTerminated(c);
                            }
                        }
                    }
                });
            }
        });
    }

    private boolean isBeingTerminated(AbstractCloudComputer<?> c) {
        if (this.beingTerminated == null) {
            return false;
        }
        return this.beingTerminated.contains(c);
    }

    private void setBeingTerminated(AbstractCloudComputer<?> c) {
        if (this.beingTerminated == null) {
            this.beingTerminated = new HashSet();
        }
        this.beingTerminated.add(c);
    }

    private void clearBeingTerminated(AbstractCloudComputer<?> c) {
        if (this.beingTerminated == null) {
            return;
        }
        this.beingTerminated.remove(c);
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "vSphere Run-Once Retention Strategy";
        }
    }
}

