/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vsphere.VSphereConnectionConfig;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FolderVSphereCloudProperty
extends AbstractFolderProperty<AbstractFolder<?>> {
    private List<vSphereCloud> clouds = null;

    public List<vSphereCloud> getVsphereClouds() {
        return this.clouds;
    }

    public List<vSphereCloud> getClouds() {
        return this.clouds;
    }

    public void setClouds(List<vSphereCloud> clouds) {
        this.clouds = clouds;
    }

    @DataBoundConstructor
    public FolderVSphereCloudProperty(List<vSphereCloud> clouds) {
        this.clouds = clouds;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FolderVSphereCloudProperty{");
        sb.append("clouds=").append(this.clouds);
        sb.append('}');
        return sb.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        public String getDisplayName() {
            return "vSphere Cloud";
        }

        public FormValidation doTestConnection(@QueryParameter String vsHost, @QueryParameter String vsDescription, @QueryParameter String credentialsId) {
            try {
                if (vsHost.length() == 0) {
                    return FormValidation.error((String)"vSphere Host is not specified");
                }
                if (!vsHost.startsWith("https://")) {
                    return FormValidation.error((String)"vSphere host must start with https://");
                }
                if (vsHost.endsWith("/")) {
                    return FormValidation.error((String)"vSphere host name must NOT end with a trailing slash");
                }
                VSphereConnectionConfig config = new VSphereConnectionConfig(vsHost, credentialsId);
                String effectiveUsername = config.getUsername();
                String effectivePassword = config.getPassword();
                if (StringUtils.isEmpty((String)effectiveUsername)) {
                    return FormValidation.error((String)"Username is not specified");
                }
                if (StringUtils.isEmpty((String)effectivePassword)) {
                    return FormValidation.error((String)"Password is not specified");
                }
                VSphere.connect(vsHost + "/sdk", effectiveUsername, effectivePassword).disconnect();
                return FormValidation.ok((String)"Connected successfully");
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public FormValidation doCheckMaxOnlineSlaves(@QueryParameter String maxOnlineSlaves) {
            return FormValidation.validateNonNegativeInteger((String)maxOnlineSlaves);
        }

        public FormValidation doCheckInstanceCap(@QueryParameter String instanceCap) {
            return FormValidation.validateNonNegativeInteger((String)instanceCap);
        }
    }
}

