/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachine;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PowerOff
extends VSphereBuildStep
implements SimpleBuildStep {
    private final String vm;
    private final boolean evenIfSuspended;
    private final boolean shutdownGracefully;
    private final boolean ignoreIfNotExists;

    @DataBoundConstructor
    public PowerOff(String vm, boolean evenIfSuspended, boolean shutdownGracefully, boolean ignoreIfNotExists) throws VSphereException {
        this.vm = vm;
        this.evenIfSuspended = evenIfSuspended;
        this.shutdownGracefully = shutdownGracefully;
        this.ignoreIfNotExists = ignoreIfNotExists;
    }

    public boolean isIgnoreIfNotExists() {
        return this.ignoreIfNotExists;
    }

    public boolean isEvenIfSuspended() {
        return this.evenIfSuspended;
    }

    public boolean isShutdownGracefully() {
        return this.shutdownGracefully;
    }

    public String getVm() {
        return this.vm;
    }

    public boolean prebuild(AbstractBuild<?, ?> abstractBuild, BuildListener buildListener) {
        return false;
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.powerOff(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.powerOff((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (VSphereException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public Action getProjectAction(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    private boolean powerOff(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        PrintStream jLogger = listener.getLogger();
        String expandedVm = this.vm;
        if (run instanceof AbstractBuild) {
            EnvVars env;
            try {
                env = run.getEnvironment(listener);
            }
            catch (Exception e) {
                throw new VSphereException(e);
            }
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedVm = env.expand(this.vm);
        }
        VSphereLogger.vsLogger(jLogger, "Shutting Down VM " + expandedVm + "...");
        VirtualMachine vsphereVm = this.vsphere.getVmByName(expandedVm);
        if (vsphereVm == null && !this.ignoreIfNotExists) {
            throw new RuntimeException(Messages.validation_notFound("vm " + expandedVm));
        }
        if (vsphereVm != null) {
            this.vsphere.powerOffVm(vsphereVm, this.evenIfSuspended, this.shutdownGracefully);
            VSphereLogger.vsLogger(jLogger, "Successfully shutdown \"" + expandedVm + "\"");
        } else {
            VSphereLogger.vsLogger(jLogger, "Does not exists, BUT ignore it! \"" + expandedVm + "\"");
        }
        return true;
    }

    @Extension
    public static class PowerOffDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public String getDisplayName() {
            return Messages.vm_title_PowerOff();
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm) {
            try {
                if (serverName.length() == 0 || vm.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                VSphere vsphere = PowerOffDescriptor.getVSphereCloudByName(serverName).vSphereInstance();
                VirtualMachine vmObj = vsphere.getVmByName(vm);
                if (vmObj == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                if (vmObj.getConfig().template) {
                    return FormValidation.error((String)Messages.validation_notActually("VM"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

