/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.CommandLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudProvisionedSlave;
import org.jenkinsci.plugins.vsphere.RunOnceCloudRetentionStrategy;
import org.jenkinsci.plugins.vsphere.VSphereCloudRetentionStrategy;
import org.jenkinsci.plugins.vsphere.VSphereConnectionConfig;
import org.jenkinsci.plugins.vsphere.VSphereGuestInfoProperty;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.CloudProvisioningState;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class vSphereCloudSlaveTemplate
implements Describable<vSphereCloudSlaveTemplate> {
    private static final Logger LOGGER = Logger.getLogger(vSphereCloudSlaveTemplate.class.getName());
    protected static final SchemeRequirement HTTP_SCHEME = new SchemeRequirement("http");
    protected static final SchemeRequirement HTTPS_SCHEME = new SchemeRequirement("https");
    private final String cloneNamePrefix;
    private final String masterImageName;
    private Boolean useSnapshot;
    private final String snapshotName;
    private final boolean linkedClone;
    private final String cluster;
    private final String resourcePool;
    private final String datastore;
    private final String folder;
    private final String customizationSpec;
    private final String templateDescription;
    private int templateInstanceCap;
    private final int numberOfExecutors;
    private final String remoteFS;
    private final String labelString;
    private final Node.Mode mode;
    private final boolean forceVMLaunch;
    private final boolean waitForVMTools;
    private final int launchDelay;
    private final int limitedRunCount;
    private final boolean saveFailure;
    private final String targetResourcePool;
    private final String targetHost;
    @Deprecated
    private final transient String credentialsId;
    private final List<? extends NodeProperty<?>> nodeProperties;
    private final List<? extends VSphereGuestInfoProperty> guestInfoProperties;
    private ComputerLauncher launcher;
    private RetentionStrategy<?> retentionStrategy;
    private transient Set<LabelAtom> labelSet;
    protected transient vSphereCloud parent;

    @DataBoundConstructor
    public vSphereCloudSlaveTemplate(String cloneNamePrefix, String masterImageName, Boolean useSnapshot, String snapshotName, boolean linkedClone, String cluster, String resourcePool, String datastore, String folder, String customizationSpec, String templateDescription, int templateInstanceCap, int numberOfExecutors, String remoteFS, String labelString, Node.Mode mode, boolean forceVMLaunch, boolean waitForVMTools, int launchDelay, int limitedRunCount, boolean saveFailure, String targetResourcePool, String targetHost, String credentialsId, ComputerLauncher launcher, RetentionStrategy<?> retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, List<? extends VSphereGuestInfoProperty> guestInfoProperties) {
        this.cloneNamePrefix = cloneNamePrefix;
        this.masterImageName = masterImageName;
        this.snapshotName = snapshotName;
        this.useSnapshot = useSnapshot;
        this.linkedClone = linkedClone;
        this.cluster = cluster;
        this.resourcePool = resourcePool;
        this.datastore = datastore;
        this.folder = folder;
        this.customizationSpec = customizationSpec;
        this.templateDescription = templateDescription;
        this.templateInstanceCap = templateInstanceCap;
        this.numberOfExecutors = numberOfExecutors;
        this.remoteFS = remoteFS;
        this.labelString = labelString;
        this.mode = mode;
        this.forceVMLaunch = forceVMLaunch;
        this.waitForVMTools = waitForVMTools;
        this.launchDelay = launchDelay;
        this.limitedRunCount = limitedRunCount;
        this.saveFailure = saveFailure;
        this.targetResourcePool = targetResourcePool;
        this.targetHost = targetHost;
        this.credentialsId = credentialsId;
        this.nodeProperties = nodeProperties;
        this.guestInfoProperties = guestInfoProperties;
        this.launcher = launcher;
        this.retentionStrategy = retentionStrategy;
        this.readResolve();
    }

    public String getCloneNamePrefix() {
        return this.cloneNamePrefix;
    }

    public String getMasterImageName() {
        return this.masterImageName;
    }

    public boolean getUseSnapshot() {
        return this.useSnapshot;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public boolean getLinkedClone() {
        return this.linkedClone;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getResourcePool() {
        return this.resourcePool;
    }

    public String getDatastore() {
        return this.datastore;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getCustomizationSpec() {
        return this.customizationSpec;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public int getTemplateInstanceCap() {
        if (this.templateInstanceCap == Integer.MAX_VALUE) {
            return 0;
        }
        return this.templateInstanceCap;
    }

    public int getNumberOfExecutors() {
        return this.numberOfExecutors;
    }

    public String getRemoteFS() {
        return this.remoteFS;
    }

    public String getLabelString() {
        return this.labelString;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public boolean getForceVMLaunch() {
        return this.forceVMLaunch;
    }

    public boolean getWaitForVMTools() {
        return this.waitForVMTools;
    }

    public int getLaunchDelay() {
        return this.launchDelay;
    }

    public int getLimitedRunCount() {
        return this.limitedRunCount;
    }

    public boolean getSaveFailure() {
        return this.saveFailure;
    }

    public String getTargetResourcePool() {
        return this.targetResourcePool;
    }

    public String getTargetHost() {
        return this.targetHost;
    }

    @Deprecated
    public String getCredentialsId() {
        return this.credentialsId;
    }

    public List<? extends NodeProperty<?>> getNodeProperties() {
        return this.nodeProperties;
    }

    public List<? extends VSphereGuestInfoProperty> getGuestInfoProperties() {
        return this.guestInfoProperties;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public vSphereCloud getParent() {
        return this.parent;
    }

    public ComputerLauncher getLauncher() {
        return this.launcher;
    }

    public RetentionStrategy<?> getRetentionStrategy() {
        return this.retentionStrategy;
    }

    protected Object readResolve() {
        this.labelSet = Label.parse((String)this.labelString);
        if (this.templateInstanceCap == 0) {
            this.templateInstanceCap = Integer.MAX_VALUE;
        }
        if (this.useSnapshot == null) {
            this.useSnapshot = this.snapshotName != null;
        }
        if (this.launcher == null) {
            LOGGER.log(Level.CONFIG, "{0} loaded old configuration that had hard-coded SSHLauncher.", this);
            try {
                String oldCredentialsIdOrNull = this.getCredentialsId();
                String oldCredentialsId = oldCredentialsIdOrNull == null ? "" : oldCredentialsIdOrNull;
                this.launcher = new SSHLauncher(null, 0, oldCredentialsId, null, null, null, null, Integer.valueOf(this.launchDelay), Integer.valueOf(3), Integer.valueOf(60));
                LOGGER.log(Level.CONFIG, " - now configured to use {0}(..., {1}, ...)", new Object[]{this.launcher.getClass().getSimpleName(), oldCredentialsId});
            }
            catch (Exception ex) {
                LOGGER.log(Level.CONFIG, " - Failed to reconfigure launcher", ex);
            }
        }
        if (this.retentionStrategy == null) {
            LOGGER.log(Level.CONFIG, "{0} loaded old configuration that had hard-coded RunOnceCloudRetentionStrategy.", this);
            try {
                int oldTimeout = 2;
                this.retentionStrategy = new RunOnceCloudRetentionStrategy(2);
                LOGGER.log(Level.CONFIG, " - now configured to use {0}({1})", new Object[]{this.retentionStrategy.getClass().getSimpleName(), 2});
            }
            catch (Exception ex) {
                LOGGER.log(Level.CONFIG, " - Failed to reconfigure strategy", ex);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public vSphereCloudProvisionedSlave provision(CloudProvisioningState algorithm, String cloneName, TaskListener listener) throws VSphereException, Descriptor.FormException, IOException, InterruptedException {
        String snapshotToUse;
        boolean useCurrentSnapshot;
        vSphereCloudProvisionedSlave slave = null;
        PrintStream logger = listener.getLogger();
        VSphere vSphere = this.getParent().vSphereInstance();
        boolean POWER_ON = true;
        if (this.getUseSnapshot()) {
            String sn = this.getSnapshotName();
            if (sn != null && !sn.isEmpty()) {
                useCurrentSnapshot = false;
                snapshotToUse = sn;
            } else {
                useCurrentSnapshot = true;
                snapshotToUse = null;
            }
        } else {
            useCurrentSnapshot = false;
            snapshotToUse = null;
        }
        vSphere.cloneOrDeployVm(cloneName, this.masterImageName, this.linkedClone, this.resourcePool, this.cluster, this.datastore, this.folder, useCurrentSnapshot, snapshotToUse, true, this.customizationSpec, logger);
        try {
            Map<String, String> resolvedGuestInfoProperties;
            if (this.guestInfoProperties != null && !this.guestInfoProperties.isEmpty() && !(resolvedGuestInfoProperties = this.calculateGuestInfoProperties(cloneName, listener)).isEmpty()) {
                LOGGER.log(Level.FINE, "Provisioning slave {0} with guestinfo properties {1}", new Object[]{cloneName, resolvedGuestInfoProperties});
                vSphere.addGuestInfoVariable(cloneName, resolvedGuestInfoProperties);
            }
            ComputerLauncher configuredLauncher = this.determineLauncher(vSphere, cloneName);
            RetentionStrategy<?> configuredStrategy = this.determineRetention();
            String snapshotNameForLauncher = "";
            slave = new vSphereCloudProvisionedSlave(cloneName, this.templateDescription, this.remoteFS, String.valueOf(this.numberOfExecutors), this.mode, this.labelString, configuredLauncher, configuredStrategy, this.nodeProperties, this.parent.getVsDescription(), cloneName, this.forceVMLaunch, this.waitForVMTools, "", String.valueOf(this.launchDelay), null, String.valueOf(this.limitedRunCount));
        }
        finally {
            if (slave == null) {
                LOGGER.log(Level.FINER, "Creation of slave failed after cloning VM: destroying clone {0}", cloneName);
                vSphere.destroyVm(cloneName, false);
            }
        }
        vSphere.disconnect();
        return slave;
    }

    private ComputerLauncher determineLauncher(VSphere vSphere, String cloneName) throws VSphereException {
        if (this.launcher instanceof JNLPLauncher) {
            return this.launcher;
        }
        if (this.launcher instanceof CommandLauncher) {
            return this.launcher;
        }
        if (this.launcher instanceof SSHLauncher) {
            SSHLauncher sshLauncher = (SSHLauncher)this.launcher;
            LOGGER.log(Level.FINER, "Slave {0} uses SSHLauncher - obtaining IP address...", cloneName);
            String ip = vSphere.getIp(vSphere.getVmByName(cloneName), 1000);
            LOGGER.log(Level.FINER, "Slave {0} has IP address {1}", new Object[]{cloneName, ip});
            SSHLauncher launcherWithIPAddress = new SSHLauncher(ip, sshLauncher.getPort(), sshLauncher.getCredentialsId(), sshLauncher.getJvmOptions(), sshLauncher.getJavaPath(), sshLauncher.getPrefixStartSlaveCmd(), sshLauncher.getSuffixStartSlaveCmd(), sshLauncher.getLaunchTimeoutSeconds(), sshLauncher.getMaxNumRetries(), sshLauncher.getRetryWaitTime());
            return launcherWithIPAddress;
        }
        throw new IllegalStateException("Unsupported launcher in template configuration");
    }

    private RetentionStrategy<?> determineRetention() {
        return this.retentionStrategy;
    }

    public Descriptor<vSphereCloudSlaveTemplate> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getClass());
    }

    private Map<String, String> calculateGuestInfoProperties(String cloneName, TaskListener listener) throws IOException, InterruptedException {
        EnvVars knownVariables = this.calculateVariablesForGuestInfo(cloneName, listener);
        LinkedHashMap<String, String> resolvedGuestInfoProperties = new LinkedHashMap<String, String>();
        for (VSphereGuestInfoProperty vSphereGuestInfoProperty : this.guestInfoProperties) {
            String name = vSphereGuestInfoProperty.getName();
            String configuredValue = vSphereGuestInfoProperty.getValue();
            String resolvedValue = Util.replaceMacro((String)configuredValue, (Map)knownVariables);
            resolvedGuestInfoProperties.put(name, resolvedValue);
        }
        return resolvedGuestInfoProperties;
    }

    private EnvVars calculateVariablesForGuestInfo(String cloneName, TaskListener listener) throws IOException, InterruptedException {
        String slaveSecret;
        EnvVars knownVariables = new EnvVars();
        String jenkinsUrl = Jenkins.getActiveInstance().getRootUrl();
        if (jenkinsUrl != null) {
            vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "JENKINS_URL", jenkinsUrl);
            vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "HUDSON_URL", jenkinsUrl);
        }
        if ((slaveSecret = JnlpSlaveAgentProtocol.SLAVE_SECRET.mac(cloneName)) != null) {
            vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "JNLP_SECRET", slaveSecret);
        }
        vSphereCloudSlaveTemplate.addEnvVars(knownVariables, listener, Jenkins.getInstance().getGlobalNodeProperties());
        vSphereCloudSlaveTemplate.addEnvVars(knownVariables, listener, this.nodeProperties);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "NODE_NAME", cloneName);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "NODE_LABELS", this.getLabelSet() == null ? null : Util.join(this.getLabelSet(), (String)" "));
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "cluster", this.cluster);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "datastore", this.datastore);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "folder", this.folder);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "customizationSpec", this.customizationSpec);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "labelString", this.labelString);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "masterImageName", this.masterImageName);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "remoteFS", this.remoteFS);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "snapshotName", this.snapshotName);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "targetHost", this.targetHost);
        vSphereCloudSlaveTemplate.addEnvVar(knownVariables, "templateDescription", this.templateDescription);
        return knownVariables;
    }

    private static void addEnvVars(EnvVars vars, TaskListener listener, Iterable<? extends NodeProperty<?>> nodeProperties) throws IOException, InterruptedException {
        if (nodeProperties != null) {
            for (NodeProperty<?> nodeProperty : nodeProperties) {
                nodeProperty.buildEnvVars(vars, listener);
            }
        }
    }

    private static void addEnvVar(EnvVars vars, String name, Object valueOrNull) {
        vars.put(name, valueOrNull == null ? "" : valueOrNull.toString());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<vSphereCloudSlaveTemplate> {
        public String getDisplayName() {
            return null;
        }

        public FormValidation doCheckCloneNamePrefix(@QueryParameter String cloneNamePrefix) {
            return FormValidation.validateRequired((String)cloneNamePrefix);
        }

        public FormValidation doCheckLimitedRunCount(@QueryParameter String limitedRunCount) {
            return FormValidation.validateNonNegativeInteger((String)limitedRunCount);
        }

        public FormValidation doCheckTemplateInstanceCap(@QueryParameter String templateInstanceCap) {
            return FormValidation.validateNonNegativeInteger((String)templateInstanceCap);
        }

        public FormValidation doCheckNumberOfExecutors(@QueryParameter String numberOfExecutors) {
            return FormValidation.validatePositiveInteger((String)numberOfExecutors);
        }

        public FormValidation doCheckLinkedClone(@QueryParameter boolean linkedClone, @QueryParameter boolean useSnapshot) {
            boolean noSnapshot;
            boolean bl = noSnapshot = !useSnapshot;
            if (linkedClone && noSnapshot) {
                return FormValidation.warning((String)"Linked clones are based upon a snapshot.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckLaunchDelay(@QueryParameter String launchDelay) {
            return FormValidation.validateNonNegativeInteger((String)launchDelay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public FormValidation doTestCloneParameters(@QueryParameter String vsHost, @QueryParameter String vsDescription, @QueryParameter String credentialsId, @QueryParameter String masterImageName, @QueryParameter boolean linkedClone, @QueryParameter boolean useSnapshot, @QueryParameter String snapshotName) {
            try {
                VSphereConnectionConfig config = new VSphereConnectionConfig(vsHost, credentialsId);
                String effectiveUsername = config.getUsername();
                String effectivePassword = config.getPassword();
                VSphere vsphere = VSphere.connect(vsHost + "/sdk", effectiveUsername, effectivePassword);
                try {
                    VirtualMachine vm = vsphere.getVmByName(masterImageName);
                    if (vm == null) {
                        FormValidation formValidation = FormValidation.error((String)Messages.validation_notFound("master image \"" + masterImageName + "\""));
                        return formValidation;
                    }
                    if (useSnapshot) {
                        VirtualMachineSnapshot snapshot;
                        if (snapshotName != null && !snapshotName.isEmpty()) {
                            snapshot = vsphere.getSnapshotInTree(vm, snapshotName);
                            if (snapshot == null) {
                                FormValidation formValidation = FormValidation.error((String)Messages.validation_notFound("snapshot \"" + snapshotName + "\""));
                                return formValidation;
                            }
                        } else {
                            snapshot = vm.getCurrentSnapShot();
                            if (snapshot == null) {
                                FormValidation formValidation = FormValidation.error((String)"No snapshots found.");
                                return formValidation;
                            }
                        }
                    } else if (linkedClone) {
                        FormValidation formValidation = FormValidation.warning((String)"vSphere doesn't like creating linked clones without a snapshot");
                        return formValidation;
                    }
                    FormValidation formValidation = FormValidation.ok((String)Messages.validation_success());
                    return formValidation;
                }
                finally {
                    vsphere.disconnect();
                }
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Problem validating");
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup<?> context) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance()).hasPermission(Computer.CONFIGURE)) {
                return new ListBoxModel();
            }
            List credentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{HTTP_SCHEME, HTTPS_SCHEME});
            return new StandardUsernameListBoxModel().withAll((Iterable)credentials);
        }

        public static List<Descriptor<ComputerLauncher>> getLauncherDescriptors() {
            List<String> supportedLaunchers = Arrays.asList(SSHLauncher.class.getName(), CommandLauncher.class.getName(), JNLPLauncher.class.getName());
            DescriptorExtensionList knownLaunchers = Jenkins.getInstance().getDescriptorList(ComputerLauncher.class);
            ArrayList<Descriptor<ComputerLauncher>> result = new ArrayList<Descriptor<ComputerLauncher>>(knownLaunchers.size());
            for (Descriptor knownLauncher : knownLaunchers) {
                if (!supportedLaunchers.contains(knownLauncher.getId())) continue;
                result.add((Descriptor<ComputerLauncher>)knownLauncher);
            }
            return result;
        }

        public static List<Descriptor<RetentionStrategy<?>>> getRetentionStrategyDescriptors() {
            ArrayList result = new ArrayList();
            result.add(RunOnceCloudRetentionStrategy.DESCRIPTOR);
            result.add(VSphereCloudRetentionStrategy.DESCRIPTOR);
            return result;
        }
    }
}

