/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.builders;

import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.vsphere.VSphereBuildStep;
import org.jenkinsci.plugins.vsphere.builders.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.jenkinsci.plugins.vsphere.tools.VSphereLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class DeleteSnapshot
extends VSphereBuildStep
implements SimpleBuildStep {
    private final String vm;
    private final String snapshotName;
    private final boolean consolidate;
    private final boolean failOnNoExist;

    @DataBoundConstructor
    public DeleteSnapshot(String vm, String snapshotName, boolean consolidate, boolean failOnNoExist) throws VSphereException {
        this.vm = vm;
        this.snapshotName = snapshotName;
        this.consolidate = consolidate;
        this.failOnNoExist = failOnNoExist;
    }

    public String getVm() {
        return this.vm;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public boolean isConsolidate() {
        return this.consolidate;
    }

    public boolean isFailOnNoExist() {
        return this.failOnNoExist;
    }

    @Override
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        try {
            this.deleteSnapshot(run, launcher, listener);
        }
        catch (Exception e) {
            throw new AbortException(e.getMessage());
        }
    }

    public boolean prebuild(AbstractBuild<?, ?> abstractBuild, BuildListener buildListener) {
        return false;
    }

    @Override
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean retVal = false;
        try {
            retVal = this.deleteSnapshot((Run<?, ?>)build, launcher, (TaskListener)listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public Action getProjectAction(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> abstractProject) {
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return null;
    }

    private boolean deleteSnapshot(Run<?, ?> run, Launcher launcher, TaskListener listener) throws VSphereException {
        EnvVars env;
        PrintStream jLogger = listener.getLogger();
        String expandedSnap = this.snapshotName;
        String expandedVm = this.vm;
        try {
            env = run.getEnvironment(listener);
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
            expandedSnap = env.expand(this.snapshotName);
            expandedVm = env.expand(this.vm);
        }
        VSphereLogger.vsLogger(jLogger, "Deleting snapshot \"" + expandedSnap + "\" of VM " + expandedVm + "...");
        this.vsphere.deleteSnapshot(expandedVm, expandedSnap, this.consolidate, this.failOnNoExist);
        VSphereLogger.vsLogger(jLogger, "Complete.");
        return true;
    }

    @Extension
    public static class DeleteSnapshotDescriptor
    extends VSphereBuildStep.VSphereBuildStepDescriptor {
        public String getDisplayName() {
            return Messages.vm_title_DeleteSnapshot();
        }

        public FormValidation doCheckVm(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the VM name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSnapshotName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.validation_required("the snapshot name"));
            }
            return FormValidation.ok();
        }

        public FormValidation doTestData(@QueryParameter String serverName, @QueryParameter String vm, @QueryParameter String snapshotName) {
            try {
                if (vm.length() == 0 || serverName.length() == 0 || snapshotName.length() == 0) {
                    return FormValidation.error((String)Messages.validation_requiredValues());
                }
                VSphere vsphere = DeleteSnapshotDescriptor.getVSphereCloudByName(serverName, null).vSphereInstance();
                if (vm.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("VM"));
                }
                if (vsphere.getVmByName(vm) == null) {
                    return FormValidation.error((String)Messages.validation_notFound("VM"));
                }
                if (snapshotName.indexOf(36) >= 0) {
                    return FormValidation.warning((String)Messages.validation_buildParameter("Snapshot"));
                }
                VirtualMachineSnapshot snap = vsphere.getSnapshotInTree(vsphere.getVmByName(vm), snapshotName);
                if (snap == null) {
                    return FormValidation.error((String)Messages.validation_notFound("Snapshot"));
                }
                return FormValidation.ok((String)Messages.validation_success());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

