/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.slaves.iterators.api.NodeIterator;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jenkinsci.plugins.vSphereCloudProvisionedSlave;
import org.jenkinsci.plugins.vSphereCloudSlave;
import org.jenkinsci.plugins.vSphereCloudSlaveTemplate;
import org.jenkinsci.plugins.vsphere.VSphereConnectionConfig;
import org.jenkinsci.plugins.vsphere.tools.CloudProvisioningAlgorithm;
import org.jenkinsci.plugins.vsphere.tools.CloudProvisioningRecord;
import org.jenkinsci.plugins.vsphere.tools.CloudProvisioningState;
import org.jenkinsci.plugins.vsphere.tools.VSphere;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class vSphereCloud
extends Cloud {
    @Deprecated
    private transient String vsHost;
    private final String vsDescription;
    @Deprecated
    private transient String username;
    @Deprecated
    private transient String password;
    private final int maxOnlineSlaves;
    @CheckForNull
    private VSphereConnectionConfig vsConnectionConfig;
    private final int instanceCap;
    private final List<? extends vSphereCloudSlaveTemplate> templates;
    private transient int currentOnlineSlaveCount = 0;
    private transient ConcurrentHashMap<String, String> currentOnline;
    private transient CloudProvisioningState templateState;
    private static Logger VSLOG = Logger.getLogger("vsphere-cloud");

    private static void InternalLog(Slave slave, SlaveComputer slaveComputer, TaskListener listener, Throwable ex, String format, Object ... args) {
        Level logLevel = Level.INFO;
        if (!VSLOG.isLoggable(logLevel) && listener == null) {
            return;
        }
        String s = "";
        if (slave != null) {
            s = String.format("[%s] ", slave.getNodeName());
        }
        if (slaveComputer != null) {
            s = String.format("[%s] ", slaveComputer.getName());
        }
        s = s + String.format(format, args);
        if (listener != null) {
            listener.getLogger().print(s + "\n");
            if (ex != null) {
                listener.getLogger().print(ex.toString() + "\n");
                ex.printStackTrace(listener.getLogger());
            }
        }
        if (ex != null) {
            VSLOG.log(logLevel, s, ex);
        } else {
            VSLOG.log(logLevel, s);
        }
    }

    public static void Log(String format, Object ... args) {
        vSphereCloud.InternalLog(null, null, null, null, format, args);
    }

    public static void Log(Throwable ex, String format, Object ... args) {
        vSphereCloud.InternalLog(null, null, null, ex, format, args);
    }

    public static void Log(TaskListener listener, String format, Object ... args) {
        vSphereCloud.InternalLog(null, null, listener, null, format, args);
    }

    public static void Log(TaskListener listener, Throwable ex, String format, Object ... args) {
        vSphereCloud.InternalLog(null, null, listener, ex, format, args);
    }

    public static void Log(Slave slave, String format, Object ... args) {
        vSphereCloud.InternalLog(slave, null, null, null, format, args);
    }

    public static void Log(Slave slave, Throwable ex, String format, Object ... args) {
        vSphereCloud.InternalLog(slave, null, null, ex, format, args);
    }

    public static void Log(Slave slave, TaskListener listener, String format, Object ... args) {
        vSphereCloud.InternalLog(slave, null, listener, null, format, args);
    }

    public static void Log(Slave slave, TaskListener listener, Throwable ex, String format, Object ... args) {
        vSphereCloud.InternalLog(slave, null, listener, ex, format, args);
    }

    public static void Log(SlaveComputer slave, TaskListener listener, String format, Object ... args) {
        vSphereCloud.InternalLog(null, slave, listener, null, format, args);
    }

    public static void Log(SlaveComputer slave, TaskListener listener, Throwable ex, String format, Object ... args) {
        vSphereCloud.InternalLog(null, slave, listener, ex, format, args);
    }

    @Deprecated
    public vSphereCloud(String vsHost, String vsDescription, String username, String password, int maxOnlineSlaves) {
        this(null, vsDescription, maxOnlineSlaves, 0, null);
    }

    @DataBoundConstructor
    public vSphereCloud(VSphereConnectionConfig vsConnectionConfig, String vsDescription, int maxOnlineSlaves, int instanceCap, List<? extends vSphereCloudSlaveTemplate> templates) {
        super("vSphereCloud");
        this.vsDescription = vsDescription;
        this.maxOnlineSlaves = maxOnlineSlaves;
        this.vsConnectionConfig = vsConnectionConfig;
        this.templates = templates == null ? Collections.emptyList() : templates;
        this.instanceCap = instanceCap == 0 ? Integer.MAX_VALUE : instanceCap;
        try {
            this.readResolve();
        }
        catch (IOException ioex) {
            // empty catch block
        }
        vSphereCloud.Log("STARTING VSPHERE CLOUD", new Object[0]);
    }

    public Object readResolve() throws IOException {
        if (this.vsConnectionConfig == null) {
            this.vsConnectionConfig = new VSphereConnectionConfig(this.vsHost, null);
        }
        if (this.templates != null) {
            for (vSphereCloudSlaveTemplate vSphereCloudSlaveTemplate2 : this.templates) {
                vSphereCloudSlaveTemplate2.parent = this;
            }
        }
        return this;
    }

    private void ensureLists() {
        if (this.currentOnline == null) {
            this.currentOnline = new ConcurrentHashMap();
        }
        if (this.templateState == null) {
            this.templateState = new CloudProvisioningState(this);
            for (vSphereCloudProvisionedSlave n : NodeIterator.nodes(vSphereCloudProvisionedSlave.class)) {
                String nodeName = n.getNodeName();
                vSphereCloudSlaveTemplate template = this.getTemplateForVM(nodeName);
                if (template == null) continue;
                CloudProvisioningRecord provisionable = this.templateState.getOrCreateRecord(template);
                this.templateState.provisioningStarted(provisionable, nodeName);
                this.templateState.provisionedSlaveNowActive(provisionable, nodeName);
            }
        }
    }

    public int getMaxOnlineSlaves() {
        return this.maxOnlineSlaves;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public List<? extends vSphereCloudSlaveTemplate> getTemplates() {
        return this.templates;
    }

    private vSphereCloudSlaveTemplate getTemplateForVM(String vmName) {
        if (this.templates == null || vmName == null) {
            return null;
        }
        for (vSphereCloudSlaveTemplate vSphereCloudSlaveTemplate2 : this.templates) {
            String cloneNamePrefix = vSphereCloudSlaveTemplate2.getCloneNamePrefix();
            if (cloneNamePrefix == null || !vmName.startsWith(cloneNamePrefix)) continue;
            return vSphereCloudSlaveTemplate2;
        }
        return null;
    }

    private List<vSphereCloudSlaveTemplate> getTemplates(Label label) {
        if (this.templates == null) {
            return Collections.emptyList();
        }
        ArrayList<vSphereCloudSlaveTemplate> matchingTemplates = new ArrayList<vSphereCloudSlaveTemplate>();
        for (vSphereCloudSlaveTemplate vSphereCloudSlaveTemplate2 : this.templates) {
            if (vSphereCloudSlaveTemplate2.getMode() == Node.Mode.NORMAL) {
                if (label != null && !label.matches(vSphereCloudSlaveTemplate2.getLabelSet())) continue;
                matchingTemplates.add(vSphereCloudSlaveTemplate2);
                continue;
            }
            if (vSphereCloudSlaveTemplate2.getMode() != Node.Mode.EXCLUSIVE || label == null || !label.matches(vSphereCloudSlaveTemplate2.getLabelSet())) continue;
            matchingTemplates.add(vSphereCloudSlaveTemplate2);
        }
        return matchingTemplates;
    }

    @CheckForNull
    public String getPassword() {
        return this.vsConnectionConfig != null ? this.vsConnectionConfig.getPassword() : null;
    }

    @CheckForNull
    public String getUsername() {
        return this.vsConnectionConfig != null ? this.vsConnectionConfig.getUsername() : null;
    }

    public String getVsDescription() {
        return this.vsDescription;
    }

    @CheckForNull
    public String getVsHost() {
        return this.vsConnectionConfig != null ? this.vsConnectionConfig.getVsHost() : null;
    }

    @CheckForNull
    public VSphereConnectionConfig getVsConnectionConfig() {
        return this.vsConnectionConfig;
    }

    public final int getHash() {
        return new HashCodeBuilder(67, 89).append((Object)this.getVsDescription()).append((Object)this.getVsHost()).toHashCode();
    }

    public VSphere vSphereInstance() throws VSphereException {
        String effectiveVsHost = this.getVsHost();
        if (effectiveVsHost == null) {
            throw new VSphereException("vSphere host is not specified");
        }
        String effectiveUserName = this.getUsername();
        if (effectiveUserName == null) {
            throw new VSphereException("vSphere username is not specified");
        }
        return VSphere.connect(effectiveVsHost + "/sdk", effectiveUserName, this.getPassword());
    }

    public boolean canProvision(Label label) {
        return !this.getTemplates(label).isEmpty();
    }

    private Integer calculateMaxAdditionalSlavesPermitted() {
        if (this.instanceCap == 0 || this.instanceCap == Integer.MAX_VALUE) {
            return null;
        }
        int totalVms = this.templateState.countNodes();
        int maxSlavesToProvision = this.instanceCap - totalVms;
        boolean thereIsNoRoom = maxSlavesToProvision <= 0;
        VSLOG.info("There are " + totalVms + " VMs in this cloud. The instance cap for the cloud is " + this.instanceCap + ", so we " + (thereIsNoRoom ? "are full" : "have room for more"));
        return maxSlavesToProvision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        String methodCallDescription = "provision(" + label + "," + excessWorkload + ")";
        try {
            int excessWorkloadSoFar = excessWorkload;
            int numberOfvSphereCloudSlaves = 0;
            int numberOfvSphereCloudSlaveExecutors = 0;
            for (vSphereCloudSlave n : NodeIterator.nodes(vSphereCloudSlave.class)) {
                if (n instanceof vSphereCloudProvisionedSlave || !n.getComputer().isOffline() || !label.matches((Collection)n.getAssignedLabels())) continue;
                n.getComputer().tryReconnect();
                ++numberOfvSphereCloudSlaves;
                numberOfvSphereCloudSlaveExecutors += n.getNumExecutors();
            }
            if ((excessWorkloadSoFar -= numberOfvSphereCloudSlaveExecutors) <= 0) {
                VSLOG.log(Level.INFO, methodCallDescription + ": " + numberOfvSphereCloudSlaves + " existing slaves (=" + numberOfvSphereCloudSlaveExecutors + " executors): Workload is satisifed by bringing those online.");
                return Collections.emptySet();
            }
            Object i$ = this;
            synchronized (i$) {
                this.ensureLists();
            }
            ArrayList<NodeProvisioner.PlannedNode> plannedNodes = new ArrayList<NodeProvisioner.PlannedNode>();
            CloudProvisioningState cloudProvisioningState = this.templateState;
            synchronized (cloudProvisioningState) {
                this.templateState.pruneUnwantedRecords();
                Integer maxSlavesToProvisionBeforeCloudCapHit = this.calculateMaxAdditionalSlavesPermitted();
                if (maxSlavesToProvisionBeforeCloudCapHit != null && maxSlavesToProvisionBeforeCloudCapHit <= 0) {
                    return Collections.emptySet();
                }
                List<vSphereCloudSlaveTemplate> templates = this.getTemplates(label);
                List<CloudProvisioningRecord> whatWeCouldUse = this.templateState.calculateProvisionableTemplates(templates);
                VSLOG.log(Level.INFO, methodCallDescription + ": " + numberOfvSphereCloudSlaves + " existing slaves (=" + numberOfvSphereCloudSlaveExecutors + " executors), templates available are " + whatWeCouldUse);
                while (excessWorkloadSoFar > 0) {
                    CloudProvisioningRecord whatWeShouldSpinUp;
                    if (maxSlavesToProvisionBeforeCloudCapHit != null) {
                        int intValue = maxSlavesToProvisionBeforeCloudCapHit;
                        if (intValue <= 0) break;
                        maxSlavesToProvisionBeforeCloudCapHit = intValue - 1;
                    }
                    if ((whatWeShouldSpinUp = CloudProvisioningAlgorithm.findTemplateWithMostFreeCapacity(whatWeCouldUse)) == null) break;
                    String nodeName = CloudProvisioningAlgorithm.findUnusedName(whatWeShouldSpinUp);
                    VSpherePlannedNode plannedNode = VSpherePlannedNode.createInstance(this.templateState, nodeName, whatWeShouldSpinUp);
                    plannedNodes.add(plannedNode);
                    excessWorkloadSoFar -= plannedNode.numExecutors;
                }
            }
            VSLOG.log(Level.INFO, methodCallDescription + ": Provisioning " + plannedNodes.size() + " new =" + plannedNodes);
            return plannedNodes;
        }
        catch (Exception ex) {
            VSLOG.log(Level.WARNING, methodCallDescription + ": Failed.", ex);
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void provisionedSlaveHasTerminated(String cloneName) {
        Object object = this;
        synchronized (object) {
            this.ensureLists();
        }
        VSLOG.log(Level.FINER, "provisionedSlaveHasTerminated({0}): recording in our runtime state...", cloneName);
        object = this.templateState;
        synchronized (object) {
            this.templateState.provisionedSlaveNowTerminated(cloneName);
        }
        VSLOG.log(Level.FINER, "provisionedSlaveHasTerminated({0}): destroying VM...", cloneName);
        VSphere vSphere = null;
        try {
            vSphere = this.vSphereInstance();
            vSphere.destroyVm(cloneName, false);
            VSLOG.log(Level.FINER, "provisionedSlaveHasTerminated({0}): VM destroyed.", cloneName);
        }
        catch (VSphereException ex) {
            VSLOG.log(Level.SEVERE, "provisionedSlaveHasTerminated(" + cloneName + "): Exception while trying to destroy VM", ex);
        }
        finally {
            if (vSphere != null) {
                vSphere.disconnect();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("vSphereCloud");
        sb.append("{Host='").append(this.getVsHost()).append('\'');
        sb.append(", Description='").append(this.vsDescription).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public synchronized Boolean canMarkVMOnline(String slaveName, String vmName) {
        this.ensureLists();
        if (this.maxOnlineSlaves > 0 && this.currentOnline.size() == this.maxOnlineSlaves) {
            return Boolean.FALSE;
        }
        if (this.currentOnline.containsValue(vmName)) {
            return Boolean.FALSE;
        }
        if (this.currentOnline.containsKey(slaveName)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public synchronized Boolean markVMOnline(String slaveName, String vmName) {
        this.ensureLists();
        if (this.currentOnline.containsKey(slaveName) && this.currentOnline.get(slaveName).equals(vmName)) {
            return Boolean.TRUE;
        }
        if (!this.canMarkVMOnline(slaveName, vmName).booleanValue()) {
            return Boolean.FALSE;
        }
        this.currentOnline.put(slaveName, vmName);
        ++this.currentOnlineSlaveCount;
        return Boolean.TRUE;
    }

    public synchronized void markVMOffline(String slaveName, String vmName) {
        this.ensureLists();
        if (this.currentOnline.remove(slaveName) != null) {
            --this.currentOnlineSlaveCount;
        }
    }

    public static List<vSphereCloud> findAllVsphereClouds() {
        ArrayList<vSphereCloud> vSphereClouds = new ArrayList<vSphereCloud>();
        for (Cloud cloud : Jenkins.getInstance().clouds) {
            if (!(cloud instanceof vSphereCloud)) continue;
            vSphereClouds.add((vSphereCloud)cloud);
        }
        return vSphereClouds;
    }

    public static List<String> finaAllVsphereCloudNames() {
        ArrayList<String> cloudNames = new ArrayList<String>();
        for (vSphereCloud vSphereCloud2 : vSphereCloud.findAllVsphereClouds()) {
            cloudNames.add(vSphereCloud2.getVsDescription());
        }
        return cloudNames;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        @Deprecated
        public final ConcurrentMap<String, vSphereCloud> hypervisors = new ConcurrentHashMap<String, vSphereCloud>();
        @Deprecated
        private String vsHost;
        @Deprecated
        private String username;
        @Deprecated
        private String password;
        @Deprecated
        private int maxOnlineSlaves;

        public String getDisplayName() {
            return "vSphere Cloud";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.vsHost = o.getString("vsHost");
            this.username = o.getString("username");
            this.password = o.getString("password");
            this.maxOnlineSlaves = o.getInt("maxOnlineSlaves");
            this.save();
            return super.configure(req, o);
        }

        public FormValidation doTestConnection(@QueryParameter String vsHost, @QueryParameter String vsDescription, @QueryParameter String credentialsId) {
            try {
                if (vsHost.length() == 0) {
                    return FormValidation.error((String)"vSphere Host is not specified");
                }
                if (!vsHost.startsWith("https://")) {
                    return FormValidation.error((String)"vSphere host must start with https://");
                }
                if (vsHost.endsWith("/")) {
                    return FormValidation.error((String)"vSphere host name must NOT end with a trailing slash");
                }
                VSphereConnectionConfig config = new VSphereConnectionConfig(vsHost, credentialsId);
                String effectiveUsername = config.getUsername();
                String effectivePassword = config.getPassword();
                if (StringUtils.isEmpty((String)effectiveUsername)) {
                    return FormValidation.error((String)"Username is not specified");
                }
                if (StringUtils.isEmpty((String)effectivePassword)) {
                    return FormValidation.error((String)"Password is not specified");
                }
                VSphere.connect(vsHost + "/sdk", effectiveUsername, effectivePassword).disconnect();
                return FormValidation.ok((String)"Connected successfully");
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public FormValidation doCheckMaxOnlineSlaves(@QueryParameter String maxOnlineSlaves) {
            return FormValidation.validateNonNegativeInteger((String)maxOnlineSlaves);
        }

        public FormValidation doCheckInstanceCap(@QueryParameter String instanceCap) {
            return FormValidation.validateNonNegativeInteger((String)instanceCap);
        }
    }

    static class VSpherePlannedNode
    extends NodeProvisioner.PlannedNode {
        private VSpherePlannedNode(String displayName, Future<Node> future, int numExecutors) {
            super(displayName, future, numExecutors);
        }

        public static VSpherePlannedNode createInstance(final CloudProvisioningState templateState, final String nodeName, final CloudProvisioningRecord whatWeShouldSpinUp) {
            vSphereCloudSlaveTemplate template = whatWeShouldSpinUp.getTemplate();
            int numberOfExecutors = template.getNumberOfExecutors();
            Callable<Node> provisionNodeCallable = new Callable<Node>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Node call() throws Exception {
                    try {
                        Node newNode = VSpherePlannedNode.provisionNewNode(templateState, whatWeShouldSpinUp, nodeName);
                        VSLOG.log(Level.INFO, "Provisioned new slave " + nodeName);
                        CloudProvisioningState cloudProvisioningState = templateState;
                        synchronized (cloudProvisioningState) {
                            templateState.provisionedSlaveNowActive(whatWeShouldSpinUp, nodeName);
                        }
                        return newNode;
                    }
                    catch (Exception ex) {
                        VSLOG.log(Level.WARNING, "Failed to provision new slave " + nodeName, ex);
                        CloudProvisioningState cloudProvisioningState = templateState;
                        synchronized (cloudProvisioningState) {
                            templateState.provisioningEndedInError(whatWeShouldSpinUp, nodeName);
                        }
                        throw ex;
                    }
                }
            };
            templateState.provisioningStarted(whatWeShouldSpinUp, nodeName);
            Future<Node> provisionNodeTask = Computer.threadPoolForRemoting.submit(provisionNodeCallable);
            VSpherePlannedNode result = new VSpherePlannedNode(nodeName, provisionNodeTask, numberOfExecutors);
            return result;
        }

        private static Node provisionNewNode(CloudProvisioningState algorithm, CloudProvisioningRecord whatWeShouldSpinUp, String cloneName) throws VSphereException, Descriptor.FormException, IOException, InterruptedException {
            vSphereCloudSlaveTemplate template = whatWeShouldSpinUp.getTemplate();
            vSphereCloudProvisionedSlave slave = template.provision(algorithm, cloneName, (TaskListener)StreamTaskListener.fromStdout());
            Jenkins.getInstance().addNode((Node)slave);
            return slave;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

