/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.RetentionStrategy;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class RunOnceCloudRetentionStrategy
extends CloudRetentionStrategy
implements ExecutorListener {
    public static final Logger logger = Logger.getLogger(RunOnceCloudRetentionStrategy.class.getName());
    private int idleMinutes = 10;
    private transient boolean terminating;
    @Restricted(value={NoExternalUse.class})
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RunOnceCloudRetentionStrategy(int idleMinutes) {
        super(idleMinutes);
        this.idleMinutes = idleMinutes;
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    public long check(AbstractCloudComputer c) {
        long idleMilliseconds;
        if (c.isIdle() && !disabled && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > TimeUnit2.MINUTES.toMillis((long)this.idleMinutes)) {
            logger.log(Level.FINE, "Disconnecting {0}", c.getName());
            this.done(c);
        }
        return 1L;
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.done(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.done(executor);
    }

    private void done(Executor executor) {
        AbstractCloudComputer c = (AbstractCloudComputer)executor.getOwner();
        Queue.Executable exec = executor.getCurrentExecutable();
        logger.log(Level.FINE, "terminating {0} since {1} seems to be finished", new Object[]{c.getName(), exec});
        this.done(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done(final AbstractCloudComputer<?> c) {
        c.setAcceptingTasks(false);
        RunOnceCloudRetentionStrategy runOnceCloudRetentionStrategy = this;
        synchronized (runOnceCloudRetentionStrategy) {
            if (this.terminating) {
                return;
            }
            this.terminating = true;
        }
        Computer.threadPoolForRemoting.submit(new Runnable(){

            @Override
            public void run() {
                Queue.withLock((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            AbstractCloudSlave node = c.getNode();
                            if (node != null) {
                                node.terminate();
                            }
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.WARNING, "Failed to terminate " + c.getName(), e);
                            RunOnceCloudRetentionStrategy runOnceCloudRetentionStrategy = RunOnceCloudRetentionStrategy.this;
                            synchronized (runOnceCloudRetentionStrategy) {
                                RunOnceCloudRetentionStrategy.this.terminating = false;
                            }
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Failed to terminate " + c.getName(), e);
                            RunOnceCloudRetentionStrategy runOnceCloudRetentionStrategy = RunOnceCloudRetentionStrategy.this;
                            synchronized (runOnceCloudRetentionStrategy) {
                                RunOnceCloudRetentionStrategy.this.terminating = false;
                            }
                        }
                    }
                });
            }
        });
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "Run Once Cloud Retention Strategy";
        }
    }
}

