/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vsphere.tools;

import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualMachineCloneSpec;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineQuestionInfo;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VirtualMachineSnapshotTree;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import org.jenkinsci.plugins.vsphere.tools.Messages;
import org.jenkinsci.plugins.vsphere.tools.VSphereConstants;
import org.jenkinsci.plugins.vsphere.tools.VSphereException;

public class VSphere {
    private final URL url;
    private final String session;
    private final String resourcePool;
    private final String cluster;

    private VSphere(String url, String user, String pw, String cluster, String resourcePool) throws VSphereException {
        this.resourcePool = resourcePool;
        this.cluster = cluster;
        try {
            this.url = new URL(url);
            this.session = new ServiceInstance(this.url, user, pw, true).getServerConnection().getSessionStr();
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
    }

    private ServiceInstance getServiceInstance() throws RemoteException, MalformedURLException {
        return new ServiceInstance(this.url, this.session, true);
    }

    public static VSphere connect(String server, String user, String pw) throws VSphereException {
        return new VSphere(server, user, pw, null, null);
    }

    public static VSphere connect(String server, String user, String pw, String cluster, String resourcePool) throws VSphereException {
        return new VSphere(server, user, pw, cluster, resourcePool);
    }

    public static String vSphereOutput(String msg) {
        return (Messages.VSphereLogger_title() + ": ").concat(msg);
    }

    public VirtualMachine shallowCloneVm(String cloneName, String template, boolean powerOn, boolean linkedClone) throws VSphereException {
        System.out.println("Creating a shallow clone of \"" + template + "\" to \"" + cloneName + "\"");
        try {
            VirtualMachine sourceVm = this.getVmByName(template);
            if (sourceVm == null) {
                throw new VSphereException("No template " + template + " found");
            }
            if (this.getVmByName(cloneName) != null) {
                throw new VSphereException("VM " + cloneName + " already exists");
            }
            System.out.println("with \"" + this.cluster + "\" and  \"" + this.resourcePool + "\"");
            VirtualMachineRelocateSpec rel = new VirtualMachineRelocateSpec();
            if (linkedClone) {
                rel.setDiskMoveType("createNewChildDiskBacking");
            } else {
                rel.setDiskMoveType("moveAllDiskBackingsAndDisallowSharing");
            }
            rel.setPool(this.getResourcePoolByName(this.resourcePool, (ManagedEntity)this.getClusterByName(this.cluster)).getMOR());
            VirtualMachineCloneSpec cloneSpec = new VirtualMachineCloneSpec();
            cloneSpec.setLocation(rel);
            cloneSpec.setPowerOn(powerOn);
            cloneSpec.setTemplate(false);
            if (sourceVm.getCurrentSnapShot() == null) {
                throw new VSphereException("Template \"" + template + "\" requires at least one snapshot!");
            }
            cloneSpec.setSnapshot(sourceVm.getCurrentSnapShot().getMOR());
            Task task = sourceVm.cloneVM_Task((Folder)sourceVm.getParent(), cloneName, cloneSpec);
            System.out.println("Cloning VM. Please wait ...");
            String status = task.waitForTask();
            if (status == TaskInfoState.success.toString()) {
                System.out.println("VM got cloned successfully.");
                return this.getVmByName(cloneName);
            }
        }
        catch (Exception e) {
            throw new VSphereException(e);
        }
        throw new VSphereException("Error cloning \"" + template + "!\" Does \"" + cloneName + "\" already exist?");
    }

    public void startVm(String name) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(name);
            if (this.isPoweredOn(vm)) {
                return;
            }
            Task task = vm.powerOnVM_Task(null);
            int j = 3;
            for (int i = 0; i < j; ++i) {
                VirtualMachineQuestionInfo q;
                if (task.getTaskInfo().getState() == TaskInfoState.success) {
                    System.out.println("VM was powered up successfully.");
                    return;
                }
                if (task.getTaskInfo().getState() == TaskInfoState.running || task.getTaskInfo().getState() == TaskInfoState.queued) {
                    Thread.sleep(5000L);
                }
                if ((q = vm.getRuntime().getQuestion()) == null || !q.getId().equals("_vmx1")) continue;
                vm.answerVM(q.getId(), q.getChoice().getDefaultIndex().toString());
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException("VM cannot be started:", e);
        }
        throw new VSphereException("VM cannot be started");
    }

    public ManagedObjectReference findSnapshotInTree(VirtualMachineSnapshotTree[] snapTree, String snapName) {
        for (int i = 0; i < snapTree.length; ++i) {
            ManagedObjectReference mor;
            VirtualMachineSnapshotTree node = snapTree[i];
            if (snapName.equals(node.getName())) {
                return node.getSnapshot();
            }
            VirtualMachineSnapshotTree[] childTree = node.getChildSnapshotList();
            if (childTree == null || (mor = this.findSnapshotInTree(childTree, snapName)) == null) continue;
            return mor;
        }
        return null;
    }

    public void revertToSnapshot(String vmName, String snapName) {
    }

    public void takeSnapshot(String name, String snapshot, String description) throws VSphereException {
        try {
            Task task = this.getVmByName(name).createSnapshot_Task(snapshot, description, false, false);
            if (task.waitForTask() == "success") {
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException("Could not take snapshot", e);
        }
        throw new VSphereException("Could not take snapshot");
    }

    public void markAsTemplate(String vmName, String snapName, String desc, boolean force) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(vmName);
            if (vm.getConfig().template) {
                return;
            }
            if (this.isPoweredOff(vm) || force) {
                this.powerDown(vm, force);
                this.takeSnapshot(vmName, snapName, desc);
                vm.markAsTemplate();
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException("Error: Could not convert to Template", e);
        }
        throw new VSphereException("Error: Could not mark as Template. Check it's power state or select \"force.\"");
    }

    public VirtualMachine markAsVm(String name) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(name);
            if (vm.getConfig().template) {
                vm.markAsVirtualMachine(this.getResourcePoolByName(this.resourcePool, (ManagedEntity)this.getClusterByName(this.cluster)), null);
            }
            return vm;
        }
        catch (Exception e) {
            throw new VSphereException("Error: Could not convert to VM", e);
        }
    }

    public String getIp(VirtualMachine vm) throws VSphereException {
        if (vm == null) {
            throw new VSphereException("vm is null");
        }
        for (int count = 0; count < VSphereConstants.IP_MAX_TRIES; ++count) {
            if (vm.getGuest().getIpAddress() != null) {
                return vm.getGuest().getIpAddress();
            }
            try {
                Thread.sleep(VSphereConstants.IP_MAX_SECONDS * 1000);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public VirtualMachine getVmByName(String vmName) throws InvalidProperty, RuntimeFault, RemoteException, MalformedURLException {
        return (VirtualMachine)new InventoryNavigator((ManagedEntity)this.getServiceInstance().getRootFolder()).searchManagedEntity("VirtualMachine", vmName);
    }

    private ResourcePool getResourcePoolByName(String poolName, ManagedEntity rootEntity) throws InvalidProperty, RuntimeFault, RemoteException, MalformedURLException {
        if (rootEntity == null) {
            rootEntity = this.getServiceInstance().getRootFolder();
        }
        return (ResourcePool)new InventoryNavigator(rootEntity).searchManagedEntity("ResourcePool", poolName);
    }

    private ClusterComputeResource getClusterByName(String clusterName, ManagedEntity rootEntity) throws InvalidProperty, RuntimeFault, RemoteException, MalformedURLException {
        if (rootEntity == null) {
            rootEntity = this.getServiceInstance().getRootFolder();
        }
        return (ClusterComputeResource)new InventoryNavigator(rootEntity).searchManagedEntity("ClusterComputeResource", clusterName);
    }

    private ClusterComputeResource getClusterByName(String clusterName) throws InvalidProperty, RuntimeFault, RemoteException, MalformedURLException {
        return this.getClusterByName(clusterName, null);
    }

    public void destroyVm(String name, boolean failOnNoExist) throws VSphereException {
        try {
            VirtualMachine vm = this.getVmByName(name);
            if (vm == null) {
                if (failOnNoExist) {
                    throw new VSphereException("VM does not exist");
                }
                System.out.println("VM does not exist, or already deleted!");
                return;
            }
            if (vm.getConfig().template) {
                throw new VSphereException("Error: Specified name represents a template, not a VM.");
            }
            this.powerDown(vm, true);
            String status = vm.destroy_Task().waitForTask();
            if (status == "success") {
                System.out.println("VM was deleted successfully.");
                return;
            }
        }
        catch (Exception e) {
            throw new VSphereException(e.getMessage());
        }
        throw new VSphereException("Error destroying VM");
    }

    private boolean isSuspended(VirtualMachine vm) {
        return vm.getRuntime().getPowerState() == VirtualMachinePowerState.suspended;
    }

    private boolean isPoweredOn(VirtualMachine vm) {
        return vm.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOn;
    }

    private boolean isPoweredOff(VirtualMachine vm) {
        return vm.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOff;
    }

    private void powerDown(VirtualMachine vm, boolean evenIfSuspended) throws VSphereException {
        if (this.isPoweredOn(vm) || evenIfSuspended && this.isSuspended(vm)) {
            String status;
            try {
                status = vm.powerOffVM_Task().waitForTask();
            }
            catch (Exception e) {
                throw new VSphereException(e);
            }
            if (status == "success") {
                System.out.println("VM was powered down successfully.");
                return;
            }
        } else if (this.isPoweredOff(vm)) {
            System.out.println("Machine in already off.");
            return;
        }
        throw new VSphereException("Machine could not be powered down!");
    }
}

