/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.AbortException;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudLauncher;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class vSphereCloudSlave
extends Slave {
    private final String vsDescription;
    private final String vmName;
    private final String snapName;
    private final Boolean waitForVMTools;
    private final String launchDelay;
    private final String idleOption;
    private Integer LimitedTestRunCount = 0;
    private transient Integer NumberOfLimitedTestRuns = 0;
    private static Hashtable<vSphereCloudSlave, Date> ProbableLaunch;
    private static Boolean ProbableLaunchLock;

    @DataBoundConstructor
    public vSphereCloudSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String vsDescription, String vmName, boolean launchSupportForced, boolean waitForVMTools, String snapName, String launchDelay, String idleOption, String LimitedTestRunCount) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new vSphereCloudLauncher(delegateLauncher, vsDescription, vmName, launchSupportForced, waitForVMTools, snapName, launchDelay, idleOption, LimitedTestRunCount), retentionStrategy, nodeProperties);
        this.vsDescription = vsDescription;
        this.vmName = vmName;
        this.snapName = snapName;
        this.waitForVMTools = waitForVMTools;
        this.launchDelay = launchDelay;
        this.idleOption = idleOption;
        this.LimitedTestRunCount = Util.tryParseNumber((String)LimitedTestRunCount, (Number)0).intValue();
        this.NumberOfLimitedTestRuns = 0;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVsDescription() {
        return this.vsDescription;
    }

    public String getSnapName() {
        return this.snapName;
    }

    public Boolean getWaitForVMTools() {
        return this.waitForVMTools;
    }

    public String getLaunchDelay() {
        return this.launchDelay;
    }

    public String getIdleOption() {
        return this.idleOption;
    }

    public Integer getLimitedTestRunCount() {
        return this.LimitedTestRunCount;
    }

    public boolean isLaunchSupportForced() {
        return ((vSphereCloudLauncher)this.getLauncher()).getOverrideLaunchSupported() == Boolean.TRUE;
    }

    public void setLaunchSupportForced(boolean slaveLaunchesOnBootup) {
        ((vSphereCloudLauncher)this.getLauncher()).setOverrideLaunchSupported(slaveLaunchesOnBootup ? Boolean.TRUE : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RemoveProbablLaunch(vSphereCloudSlave slave) {
        Boolean bl = ProbableLaunchLock;
        synchronized (bl) {
            if (ProbableLaunch != null) {
                ProbableLaunch.remove((Object)slave);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CauseOfBlockage canTake(Queue.BuildableItem item) {
        SlaveComputer sc;
        CauseOfBlockage b = super.canTake(item);
        boolean DoVMLaunch = false;
        if (b == null && (sc = this.getComputer()).isOffline() && sc.isLaunchSupported()) {
            Boolean bl = ProbableLaunchLock;
            synchronized (bl) {
                if (ProbableLaunch == null) {
                    ProbableLaunch = new Hashtable();
                }
                Date now = new Date();
                Iterator<Map.Entry<vSphereCloudSlave, Date>> it = ProbableLaunch.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<vSphereCloudSlave, Date> entry = it.next();
                    if (!entry.getValue().before(now)) continue;
                    it.remove();
                }
                DoVMLaunch = true;
                for (vSphereCloudSlave launchingSlave : ProbableLaunch.keySet()) {
                    if (launchingSlave == this) {
                        DoVMLaunch = false;
                        break;
                    }
                    if (launchingSlave.canTake(item) != null) continue;
                    DoVMLaunch = false;
                    b = CauseOfBlockage.fromMessage((Localizable)Messages._Slave_UnableToLaunch((Object)this.getNodeName(), (Object)String.format("Another potential slave (%s) is launching", launchingSlave.getNodeName())));
                    break;
                }
            }
            if (DoVMLaunch) {
                sc.connect(false);
                b = CauseOfBlockage.fromMessage((Localizable)Messages._Slave_Launching((Object)this.getNodeName()));
                Calendar cal = Calendar.getInstance();
                cal.add(12, 10);
                ProbableLaunch.put(this, cal.getTime());
            }
        }
        return b;
    }

    private void CheckLimitedTestRunValues() {
        if (this.NumberOfLimitedTestRuns == null) {
            this.NumberOfLimitedTestRuns = 0;
        }
        if (this.LimitedTestRunCount == null) {
            this.LimitedTestRunCount = 0;
        }
    }

    public boolean StartLimitedTestRun(Run r, TaskListener listener) {
        boolean ret = false;
        boolean DoUpdates = false;
        this.CheckLimitedTestRunValues();
        if (this.LimitedTestRunCount > 0) {
            DoUpdates = true;
            if (this.NumberOfLimitedTestRuns < this.LimitedTestRunCount) {
                ret = true;
            }
        } else {
            ret = true;
        }
        if (DoUpdates) {
            if (ret) {
                Integer n = this.NumberOfLimitedTestRuns;
                Integer n2 = this.NumberOfLimitedTestRuns = Integer.valueOf(this.NumberOfLimitedTestRuns + 1);
                vSphereCloud.Log(listener, "Starting limited count build: %d", this.NumberOfLimitedTestRuns);
            } else {
                vSphereCloud.Log(listener, "Terminating build due to limited build count: %d", this.LimitedTestRunCount);
                r.getExecutor().interrupt(Result.ABORTED);
            }
        }
        return ret;
    }

    public boolean EndLimitedTestRun(Run r) {
        boolean ret = true;
        this.CheckLimitedTestRunValues();
        if (this.LimitedTestRunCount > 0) {
            if (this.NumberOfLimitedTestRuns >= this.LimitedTestRunCount) {
                ret = false;
                this.NumberOfLimitedTestRuns = 0;
                r.getExecutor().getOwner().disconnect();
                String Node2 = "NA";
                if (r.getExecutor() != null && r.getExecutor().getOwner() != null) {
                    Node2 = r.getExecutor().getOwner().getName();
                }
                vSphereCloud.Log("Disconnecting the slave agent on %s due to limited build threshold", Node2);
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public ComputerLauncher getDelegateLauncher() {
        return ((vSphereCloudLauncher)this.getLauncher()).getDelegate();
    }

    static {
        ProbableLaunchLock = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Slave virtual computer running under vSphere Cloud";
        }

        public boolean isInstantiable() {
            return true;
        }

        public List<vSphereCloud> getvSphereClouds() {
            ArrayList<vSphereCloud> result = new ArrayList<vSphereCloud>();
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof vSphereCloud)) continue;
                result.add((vSphereCloud)cloud);
            }
            return result;
        }

        public vSphereCloud getSpecificvSphereCloud(String vsDescription) throws Exception {
            for (vSphereCloud vs : this.getvSphereClouds()) {
                if (!vs.getVsDescription().equals(vsDescription)) continue;
                return vs;
            }
            throw new Exception("The vSphere Cloud doesn't exist");
        }

        public List<Descriptor<ComputerLauncher>> getComputerLauncherDescriptors() {
            ArrayList<Descriptor<ComputerLauncher>> result = new ArrayList<Descriptor<ComputerLauncher>>();
            for (Descriptor launcher : Functions.getComputerLauncherDescriptors()) {
                if (vSphereCloudLauncher.class.isAssignableFrom(launcher.clazz)) continue;
                result.add((Descriptor<ComputerLauncher>)launcher);
            }
            return result;
        }

        public List<String> getIdleOptions() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("Shutdown");
            options.add("Shutdown and Revert");
            options.add("Suspend");
            options.add("Reset");
            options.add("Nothing");
            return options;
        }

        public FormValidation doCheckLaunchDelay(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public FormValidation doTestConnection(@QueryParameter String vsDescription, @QueryParameter String vmName, @QueryParameter String snapName) {
            try {
                VirtualMachineSnapshot snap;
                vSphereCloud vsC = this.getSpecificvSphereCloud(vsDescription);
                ServiceInstance si = vsC.getSI();
                Folder rootFolder = si.getRootFolder();
                VirtualMachine vm = (VirtualMachine)new InventoryNavigator((ManagedEntity)rootFolder).searchManagedEntity("VirtualMachine", vmName);
                if (vm == null) {
                    return FormValidation.error((String)"Virtual Machine was not found");
                }
                if (!snapName.isEmpty() && (snap = vsC.getSnapshotInTree(vm, snapName)) == null) {
                    return FormValidation.error((String)"Virtual Machine snapshot was not found");
                }
                return FormValidation.ok((String)"Virtual Machine found successfully");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Extension
    public static class vSphereCloudComputerListener
    extends ComputerListener {
        public void preLaunch(Computer c, TaskListener taskListener) throws IOException, InterruptedException {
            if (!(c.getNode() instanceof vSphereCloudSlave)) {
                return;
            }
            vSphereCloudLauncher vsL = (vSphereCloudLauncher)((SlaveComputer)c).getLauncher();
            vSphereCloud vsC = vsL.findOurVsInstance();
            if (!vsC.markVMOnline(c.getDisplayName(), vsL.getVmName()).booleanValue()) {
                throw new AbortException("The vSphere cloud will not allow this slave to start at this time.");
            }
        }
    }
}

