/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VirtualMachineSnapshotInfo;
import com.vmware.vim25.VirtualMachineSnapshotTree;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class vSphereCloud
extends Cloud {
    private final String vsHost;
    private final String vsDescription;
    private final String username;
    private final String password;
    private final int maxOnlineSlaves;
    private transient int currentOnlineSlaveCount = 0;
    private transient SlaveComputer slaveBeingLaunched = null;
    private transient Hashtable<String, String> currentOnline;

    @DataBoundConstructor
    public vSphereCloud(String vsHost, String vsDescription, String username, String password, int maxOnlineSlaves) {
        super("vSphereCloud");
        this.vsHost = vsHost;
        this.vsDescription = vsDescription;
        this.username = username;
        this.password = Scrambler.scramble((String)Util.fixEmptyAndTrim((String)password));
        this.maxOnlineSlaves = maxOnlineSlaves;
    }

    protected void EnsureLists() {
        if (this.currentOnline == null) {
            this.currentOnline = new Hashtable();
        }
    }

    public int getMaxOnlineSlaves() {
        return this.maxOnlineSlaves;
    }

    public String getPassword() {
        return Scrambler.descramble((String)this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getVsDescription() {
        return this.vsDescription;
    }

    public String getVsHost() {
        return this.vsHost;
    }

    public SlaveComputer getSlaveBeingLaunched() {
        return this.slaveBeingLaunched;
    }

    public void setSlaveBeingLaunched(SlaveComputer slaveBeingLaunched) {
        this.slaveBeingLaunched = slaveBeingLaunched;
    }

    public boolean canProvision(Label label) {
        return false;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        return Collections.emptySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("vSphereCloud");
        sb.append("{Host='").append(this.vsHost).append('\'');
        sb.append(", Description='").append(this.vsDescription).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public ServiceInstance getSI() throws Exception {
        ServiceInstance si = new ServiceInstance(new URL(this.vsHost + "/sdk"), this.getUsername(), this.getPassword(), true);
        si.currentTime();
        return si;
    }

    public synchronized Boolean canMarkVMOnline(String slaveName, String vmName) {
        this.EnsureLists();
        if (this.maxOnlineSlaves > 0 && this.currentOnline.size() == this.maxOnlineSlaves) {
            return Boolean.FALSE;
        }
        if (this.currentOnline.containsValue(vmName)) {
            return Boolean.FALSE;
        }
        if (this.currentOnline.containsKey(slaveName)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public synchronized Boolean markVMOnline(String slaveName, String vmName) {
        this.EnsureLists();
        if (this.currentOnline.containsKey(slaveName) && this.currentOnline.get(slaveName).equals(vmName)) {
            return Boolean.TRUE;
        }
        if (!this.canMarkVMOnline(slaveName, vmName).booleanValue()) {
            return Boolean.FALSE;
        }
        this.currentOnline.put(slaveName, vmName);
        ++this.currentOnlineSlaveCount;
        return Boolean.TRUE;
    }

    public synchronized void markVMOffline(String slaveName, String vmName) {
        this.EnsureLists();
        if (this.currentOnline.remove(slaveName) != null) {
            --this.currentOnlineSlaveCount;
        }
    }

    public VirtualMachineSnapshot getSnapshotInTree(VirtualMachine vm, String snapName) throws Exception {
        if (vm == null || snapName == null) {
            return null;
        }
        VirtualMachineSnapshotInfo info = vm.getSnapshot();
        if (info != null) {
            ManagedObjectReference mor;
            VirtualMachineSnapshotTree[] snapTree = info.getRootSnapshotList();
            if (snapTree != null && (mor = this.findSnapshotInTree(snapTree, snapName)) != null) {
                return new VirtualMachineSnapshot(vm.getServerConnection(), mor);
            }
        } else {
            throw new Exception("No snapshots exist or unable to access the snapshot array");
        }
        return null;
    }

    public ManagedObjectReference findSnapshotInTree(VirtualMachineSnapshotTree[] snapTree, String snapName) {
        for (int i = 0; i < snapTree.length; ++i) {
            ManagedObjectReference mor;
            VirtualMachineSnapshotTree node = snapTree[i];
            if (snapName.equals(node.getName())) {
                return node.getSnapshot();
            }
            VirtualMachineSnapshotTree[] childTree = node.getChildSnapshotList();
            if (childTree == null || (mor = this.findSnapshotInTree(childTree, snapName)) == null) continue;
            return mor;
        }
        return null;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        public final ConcurrentMap<String, vSphereCloud> hypervisors = new ConcurrentHashMap<String, vSphereCloud>();
        private String vsHost;
        private String username;
        private String password;
        private int maxOnlineSlaves;

        public String getDisplayName() {
            return "vSphere Cloud";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.vsHost = o.getString("vsHost");
            this.username = o.getString("username");
            this.password = o.getString("password");
            this.maxOnlineSlaves = o.getInt("maxOnlineSlaves");
            this.save();
            return super.configure(req, o);
        }

        public FormValidation doTestConnection(@QueryParameter String vsHost, @QueryParameter String vsDescription, @QueryParameter String username, @QueryParameter String password, @QueryParameter int maxOnlineSlaves) {
            try {
                if (vsHost.length() == 0) {
                    return FormValidation.error((String)"vSphere Host is not specified");
                }
                if (!vsHost.startsWith("https://")) {
                    return FormValidation.error((String)"vSphere host must start with https://");
                }
                if (vsHost.endsWith("/")) {
                    return FormValidation.error((String)"vSphere host name must NOT end with a trailing slash");
                }
                if (username.length() == 0) {
                    return FormValidation.error((String)"Username is not specified");
                }
                if (password.length() == 0) {
                    return FormValidation.error((String)"Password is not specified");
                }
                ServiceInstance si = new ServiceInstance(new URL(vsHost + "/sdk"), username, password, true);
                si.currentTime();
                return FormValidation.ok((String)"Connected successfully");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

