/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.VirtualMachineSnapshot;
import hudson.AbortException;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.vSphereCloud;
import org.jenkinsci.plugins.vSphereCloudLauncher;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class vSphereCloudSlave
extends Slave {
    private final String vsDescription;
    private final String vmName;
    private final String snapName;
    private final Boolean waitForVMTools;
    private final String launchDelay;
    private final String idleOption;

    @DataBoundConstructor
    public vSphereCloudSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String vsDescription, String vmName, boolean launchSupportForced, boolean waitForVMTools, String snapName, String launchDelay, String idleOption) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, (ComputerLauncher)new vSphereCloudLauncher(delegateLauncher, vsDescription, vmName, launchSupportForced, waitForVMTools, snapName, launchDelay, idleOption), retentionStrategy, nodeProperties);
        this.vsDescription = vsDescription;
        this.vmName = vmName;
        this.snapName = snapName;
        this.waitForVMTools = waitForVMTools;
        this.launchDelay = launchDelay;
        this.idleOption = idleOption;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVsDescription() {
        return this.vsDescription;
    }

    public String getSnapName() {
        return this.snapName;
    }

    public Boolean getWaitForVMTools() {
        return this.waitForVMTools;
    }

    public String getLaunchDelay() {
        return this.launchDelay;
    }

    public String getIdleOption() {
        return this.idleOption;
    }

    public boolean isLaunchSupportForced() {
        return ((vSphereCloudLauncher)this.getLauncher()).getOverrideLaunchSupported() == Boolean.TRUE;
    }

    public void setLaunchSupportForced(boolean slaveLaunchesOnBootup) {
        ((vSphereCloudLauncher)this.getLauncher()).setOverrideLaunchSupported(slaveLaunchesOnBootup ? Boolean.TRUE : null);
    }

    public ComputerLauncher getDelegateLauncher() {
        return ((vSphereCloudLauncher)this.getLauncher()).getDelegate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Slave virtual computer running under vSphere Cloud";
        }

        public boolean isInstantiable() {
            return true;
        }

        public List<vSphereCloud> getvSphereClouds() {
            ArrayList<vSphereCloud> result = new ArrayList<vSphereCloud>();
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof vSphereCloud)) continue;
                result.add((vSphereCloud)cloud);
            }
            return result;
        }

        public vSphereCloud getSpecificvSphereCloud(String vsDescription) throws Exception {
            for (vSphereCloud vs : this.getvSphereClouds()) {
                if (!vs.getVsDescription().equals(vsDescription)) continue;
                return vs;
            }
            throw new Exception("The vSphere Cloud doesn't exist");
        }

        public List<Descriptor<ComputerLauncher>> getComputerLauncherDescriptors() {
            ArrayList<Descriptor<ComputerLauncher>> result = new ArrayList<Descriptor<ComputerLauncher>>();
            for (Descriptor launcher : Functions.getComputerLauncherDescriptors()) {
                if (vSphereCloudLauncher.class.isAssignableFrom(launcher.clazz)) continue;
                result.add((Descriptor<ComputerLauncher>)launcher);
            }
            return result;
        }

        public List<String> getIdleOptions() {
            ArrayList<String> options = new ArrayList<String>();
            options.add("Shutdown");
            options.add("Shutdown and Revert");
            options.add("Suspend");
            return options;
        }

        public FormValidation doCheckLaunchDelay(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public FormValidation doTestConnection(@QueryParameter String vsDescription, @QueryParameter String vmName, @QueryParameter String snapName) {
            try {
                VirtualMachineSnapshot snap;
                vSphereCloud vsC = this.getSpecificvSphereCloud(vsDescription);
                ServiceInstance si = vsC.getSI();
                Folder rootFolder = si.getRootFolder();
                VirtualMachine vm = (VirtualMachine)new InventoryNavigator((ManagedEntity)rootFolder).searchManagedEntity("VirtualMachine", vmName);
                if (vm == null) {
                    return FormValidation.error((String)"Virtual Machine was not found");
                }
                if (!snapName.isEmpty() && (snap = vsC.getSnapshotInTree(vm, snapName)) == null) {
                    return FormValidation.error((String)"Virtual Machine snapshot was not found");
                }
                return FormValidation.ok((String)"Virtual Machine found successfully");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Extension
    public static class vSphereCloudComputerListener
    extends ComputerListener {
        public void preLaunch(Computer c, TaskListener taskListener) throws IOException, InterruptedException {
            if (!(c.getNode() instanceof vSphereCloudSlave)) {
                return;
            }
            vSphereCloudLauncher vsL = (vSphereCloudLauncher)((SlaveComputer)c).getLauncher();
            vSphereCloud vsC = vsL.findOurVsInstance();
            if (!vsC.markVMOnline(c.getDisplayName(), vsL.getVmName()).booleanValue()) {
                throw new AbortException("Clound will not allow this slave to start at this time.");
            }
        }
    }
}

