/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vs_code_metrics;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.jenkinsci.plugins.vs_code_metrics.CodeMetricsReport;
import org.jenkinsci.plugins.vs_code_metrics.Messages;
import org.jenkinsci.plugins.vs_code_metrics.VsCodeMetricsThresholds;
import org.jenkinsci.plugins.vs_code_metrics.bean.CodeMetrics;
import org.jenkinsci.plugins.vs_code_metrics.util.CodeMetricsUtil;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsCodeMetricsBuildAction
implements Action,
StaplerProxy,
HealthReportingAction {
    private final AbstractBuild<?, ?> build;
    private final VsCodeMetricsThresholds thresholds;
    private int maintainabilityIndex;
    private int cyclomaticComplexity;
    private boolean metricsValue;
    private transient WeakReference<CodeMetrics> resultRef = null;

    public VsCodeMetricsBuildAction(AbstractBuild<?, ?> build, VsCodeMetricsThresholds thresholds) {
        this.build = build;
        this.thresholds = thresholds;
        this.setMetricsValue();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return Messages.VsCodeMetricsBuildAction_DisplayName();
    }

    public String getUrlName() {
        return "vs_code_metrics";
    }

    public int getMaintainabilityIndex() {
        return this.maintainabilityIndex;
    }

    public int getCyclomaticComplexity() {
        return this.cyclomaticComplexity;
    }

    public boolean isMetricsValue() {
        return this.metricsValue;
    }

    public Object getTarget() {
        return this.getReport();
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    private CodeMetricsReport getReport() {
        CodeMetrics result = this.getCodeMetrics();
        return new CodeMetricsReport(this.build, result);
    }

    public HealthReport getBuildHealth() {
        int maintainabilityIndex = 0;
        if (this.metricsValue) {
            maintainabilityIndex = this.maintainabilityIndex;
        } else {
            CodeMetrics result = this.getCodeMetrics();
            if (result == null) {
                return null;
            }
            maintainabilityIndex = result.getMaintainabilityIndex();
        }
        int score = this.getHealthScore(maintainabilityIndex, this.thresholds.getMinMaintainabilityIndex(), this.thresholds.getMaxMaintainabilityIndex());
        return new HealthReport(score, Messages._HealthReport_Description(maintainabilityIndex));
    }

    private int getHealthScore(int value, int minValue, int maxValue) {
        if (value >= maxValue) {
            return 100;
        }
        if (value < minValue) {
            return 0;
        }
        return 50;
    }

    public synchronized CodeMetrics getCodeMetrics() {
        CodeMetrics result = null;
        if (this.resultRef != null && (result = (CodeMetrics)this.resultRef.get()) != null) {
            return result;
        }
        try {
            result = CodeMetricsUtil.getCodeMetrics(this.build);
            this.resultRef = new WeakReference<CodeMetrics>(result);
            return result;
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void setMetricsValue() {
        CodeMetrics result = this.getCodeMetrics();
        if (result == null) {
            return;
        }
        this.maintainabilityIndex = result.getMaintainabilityIndex();
        this.cyclomaticComplexity = result.getCyclomaticComplexity();
        this.metricsValue = true;
    }
}

