/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vs_code_metrics;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.jenkinsci.plugins.vs_code_metrics.CyclomaticComplexityGraph;
import org.jenkinsci.plugins.vs_code_metrics.MaintainabilityIndexGraph;
import org.jenkinsci.plugins.vs_code_metrics.VsCodeMetricsBuildAction;
import org.jenkinsci.plugins.vs_code_metrics.bean.AbstractBean;
import org.jenkinsci.plugins.vs_code_metrics.bean.CodeMetrics;
import org.jenkinsci.plugins.vs_code_metrics.util.CodeMetricsUtil;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReport
implements Serializable,
ModelObject {
    private static final long serialVersionUID = 1L;
    private AbstractBuild<?, ?> build;
    private String name;
    private AbstractBean<?> result;
    private AbstractBean<?> previousResult;
    private String[] buildTokens = new String[0];
    private boolean depthOfInheritance = true;
    private boolean childUrlLink = true;

    protected AbstractReport(AbstractBuild<?, ?> build, String name, AbstractBean<?> result) {
        this.build = build;
        this.name = name;
        this.result = result;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String[] getBuildTokens() {
        return this.buildTokens;
    }

    public boolean isDepthOfInheritance() {
        return this.depthOfInheritance;
    }

    public void setDepthOfInheritance(boolean depthOfInheritance) {
        this.depthOfInheritance = depthOfInheritance;
    }

    public boolean isChildUrlLink() {
        return this.childUrlLink;
    }

    public void setChildUrlLink(boolean childUrlLink) {
        this.childUrlLink = childUrlLink;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.getReport(token);
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        MaintainabilityIndexGraph graph = new MaintainabilityIndexGraph(this.build, this.buildTokens, this.build.getTimestamp(), 500, 200);
        graph.doPng(req, rsp);
    }

    public void doMaiGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        MaintainabilityIndexGraph graph = new MaintainabilityIndexGraph(this.build, this.buildTokens, this.build.getTimestamp(), 350, 200);
        graph.doPng(req, rsp);
    }

    public void doCycGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        CyclomaticComplexityGraph graph = new CyclomaticComplexityGraph(this.build, this.buildTokens, this.build.getTimestamp(), 350, 200);
        graph.doPng(req, rsp);
    }

    public AbstractBean<?> getResult() {
        return this.result;
    }

    public AbstractBean<?> getPreviousResult() {
        if (this.previousResult != null) {
            return this.previousResult;
        }
        for (AbstractBuild lastBuild = (AbstractBuild)this.build.getPreviousBuild(); lastBuild != null; lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
            VsCodeMetricsBuildAction action;
            CodeMetrics metrics;
            if (lastBuild.isBuilding() || lastBuild.getAction(VsCodeMetricsBuildAction.class) == null || (metrics = (action = (VsCodeMetricsBuildAction)lastBuild.getAction(VsCodeMetricsBuildAction.class)).getCodeMetrics()) == null) continue;
            this.previousResult = CodeMetricsUtil.searchBean(metrics, this.buildTokens);
            return this.previousResult;
        }
        return null;
    }

    public Object getPreviousResult(String token) {
        AbstractBean<?> bean = this.getPreviousResult();
        if (bean == null) {
            return null;
        }
        if (bean.getChildren().containsKey(token)) {
            return bean.getChildren().get(token);
        }
        return null;
    }

    public boolean hasChildren() {
        return this.result != null && this.result.getChildren().size() > 0;
    }

    public Map<String, ?> getChildren() {
        return this.result.getChildren();
    }

    public void setBuildTokens(String token, String[] tokens) {
        int size = tokens == null ? 1 : tokens.length + 1;
        String[] arr = new String[size];
        if (tokens != null) {
            System.arraycopy(tokens, 0, arr, 0, tokens.length);
        }
        arr[size - 1] = token;
        this.buildTokens = arr;
    }

    public abstract Object getReport(String var1);
}

