/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vs_code_metrics;

import hudson.model.AbstractBuild;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Calendar;
import org.jenkinsci.plugins.vs_code_metrics.VsCodeMetricsBuildAction;
import org.jenkinsci.plugins.vs_code_metrics.bean.AbstractBean;
import org.jenkinsci.plugins.vs_code_metrics.bean.CodeMetrics;
import org.jenkinsci.plugins.vs_code_metrics.util.CodeMetricsUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraph
extends Graph {
    private final AbstractBuild<?, ?> build;
    private final String[] buildTokens;
    protected String valueKey = null;
    protected Integer upperBound = null;

    public AbstractGraph(AbstractBuild<?, ?> build, String[] buildTokens, Calendar timestamp, int defaultW, int defaultH) {
        super(timestamp, defaultW, defaultH);
        this.build = build;
        this.buildTokens = buildTokens;
    }

    protected JFreeChart createGraph() {
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)this.valueKey, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (this.upperBound != null) {
            rangeAxis.setUpperBound((double)this.upperBound.intValue());
        }
        rangeAxis.setLowerBound(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(2.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private CategoryDataset createDataset() {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractBuild lastBuild = this.build; lastBuild != null; lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
            AbstractBean<?> bean;
            if (lastBuild.isBuilding() || lastBuild.getAction(VsCodeMetricsBuildAction.class) == null) continue;
            VsCodeMetricsBuildAction action = (VsCodeMetricsBuildAction)lastBuild.getAction(VsCodeMetricsBuildAction.class);
            if ((this.buildTokens == null || this.buildTokens.length == 0) && action.isMetricsValue()) {
                ChartUtil.NumberOnlyBuildLabel buildLabel = new ChartUtil.NumberOnlyBuildLabel(lastBuild);
                builder.add((Number)this.getValue(action), (Comparable)((Object)this.valueKey), (Comparable)buildLabel);
                continue;
            }
            CodeMetrics metrics = action.getCodeMetrics();
            if (metrics == null || (bean = CodeMetricsUtil.searchBean(metrics, this.buildTokens)) == null) continue;
            ChartUtil.NumberOnlyBuildLabel buildLabel = new ChartUtil.NumberOnlyBuildLabel(lastBuild);
            builder.add((Number)this.getValue(bean), (Comparable)((Object)this.valueKey), (Comparable)buildLabel);
        }
        return builder.build();
    }

    protected abstract int getValue(AbstractBean<?> var1);

    protected abstract int getValue(VsCodeMetricsBuildAction var1);
}

