/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vncviewer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.SystemUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.jenkinsci.plugins.vncviewer.ConsoleNoteButton;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class VncViewerBuildWrapper
extends BuildWrapper {
    private String vncServ;

    @DataBoundConstructor
    public VncViewerBuildWrapper(String vncServ) {
        this.vncServ = vncServ;
    }

    public String getVncServ() {
        return this.vncServ;
    }

    public void setVncServ(String vncServ) {
        this.vncServ = vncServ;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="avoid false posititive")
    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        DescriptorImpl DESCRIPTOR = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        String vncServReplaced = Util.escape((String)Util.replaceMacro((String)this.vncServ, (Map)build.getEnvironment((TaskListener)listener)));
        int freePort = VncViewerBuildWrapper.findFreePort();
        int startPortNmb = freePort > 0 ? freePort : 8888;
        Proc noVncProc = null;
        String lp = String.valueOf(startPortNmb);
        if (vncServReplaced.isEmpty()) {
            vncServReplaced = DESCRIPTOR.getDefaultVncServ();
        }
        if (vncServReplaced.indexOf(":") < 0) {
            vncServReplaced = vncServReplaced + ":5900";
        }
        if (vncServReplaced.split(":")[1].length() == 2) {
            vncServReplaced = vncServReplaced.replace(":", ":59");
        }
        try {
            VncViewerBuildWrapper.untar(VncViewerBuildWrapper.class.getResourceAsStream("/novnc.tar"), System.getProperty("java.io.tmpdir"));
            VncViewerBuildWrapper.untar(VncViewerBuildWrapper.class.getResourceAsStream("/websockify.tar"), System.getProperty("java.io.tmpdir"));
            String webSockifyPath = System.getProperty("java.io.tmpdir") + File.separator + "websockify" + File.separator + "websockify.py";
            File f = new File(webSockifyPath);
            if (!f.canExecute()) {
                f.setExecutable(true);
            }
            String webPath = System.getProperty("java.io.tmpdir") + File.separator + "novnc";
            Launcher.LocalLauncher localLauncher = new Launcher.LocalLauncher((TaskListener)listener);
            for (int i = 0; i < 1000; ++i) {
                lp = String.valueOf(startPortNmb + i);
                noVncProc = localLauncher.launch().stderr((OutputStream)listener.getLogger()).stdout((OutputStream)listener.getLogger()).cmds(new String[]{webSockifyPath, "--web", webPath, lp, vncServReplaced}).start();
                Thread.sleep(5000L);
                if (!noVncProc.isAlive()) {
                    try {
                        noVncProc.kill();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String hostAddr = this.determineJenkinsHostAddress(listener);
        String url = "http://" + hostAddr + ":" + lp + "/vnc_auto.html?host=" + hostAddr + "&port=" + lp;
        String txt = "Start vnc viewer for " + vncServReplaced;
        listener.getLogger().print('\n');
        listener.annotate((ConsoleNote)new ConsoleNoteButton(txt, url));
        listener.getLogger().print("\n\n");
        final Proc noVncProcFinal = noVncProc;
        return new BuildWrapper.Environment(){

            @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="ignore Exceptions on teardown")
            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                try {
                    noVncProcFinal.getStderr().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    noVncProcFinal.getStdout().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    noVncProcFinal.kill();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
        };
    }

    public static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="avoid false posititive")
    private String determineJenkinsHostAddress(BuildListener listener) throws IOException {
        String jenkinsRootUrl = Jenkins.getInstance().getRootUrl();
        if (jenkinsRootUrl != null) {
            try {
                return new URL(jenkinsRootUrl).getHost();
            }
            catch (MalformedURLException e) {
                listener.getLogger().println(String.format("Unable to determine jenkins address from jenkins url '%s'", jenkinsRootUrl));
                return this.fallbackHostAddress(listener);
            }
        }
        listener.getLogger().println("Unable to determine jenkins address - jenkins url is not set");
        return this.fallbackHostAddress(listener);
    }

    private String fallbackHostAddress(BuildListener listener) throws IOException {
        String hostAddr = InetAddress.getLocalHost().getHostName();
        listener.getLogger().println(String.format("Assuming machine hostname '%s' as VNC viewer address", hostAddr));
        return hostAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void untar(InputStream is, String dest) throws IOException {
        try (TarInputStream tarIn = new TarInputStream(is);){
            TarEntry tarEntry = tarIn.getNextEntry();
            while (tarEntry != null) {
                File destPath = new File(dest, tarEntry.getName());
                if (!destPath.exists()) {
                    if (tarEntry.isDirectory()) {
                        if (!destPath.mkdirs()) {
                            System.err.println("Can't remove " + destPath.toString() + "!");
                        }
                        destPath.deleteOnExit();
                    } else {
                        boolean rc = destPath.createNewFile();
                        if (!rc) {
                            System.err.println(destPath.toString() + " already exists! ");
                        }
                        destPath.deleteOnExit();
                        byte[] btoRead = new byte[1024];
                        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(destPath));
                        int len = 0;
                        while ((len = tarIn.read(btoRead)) != -1) {
                            bout.write(btoRead, 0, len);
                        }
                        bout.close();
                        btoRead = null;
                    }
                }
                tarEntry = tarIn.getNextEntry();
            }
        }
    }

    @Extension(ordinal=-2.0)
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(VncViewerBuildWrapper.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            this.save();
            return true;
        }

        public FormValidation doCheckVncServ(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) {
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value.isEmpty()) {
                return FormValidation.errorWithMarkup((String)"Vnc server can't be empty!");
            }
            return FormValidation.okWithMarkup((String)("<strong><font color=\"blue\">Please, make sure that your vncserver is running on '" + value + "'</font></strong>"));
        }

        public String getDisplayName() {
            return "Enable VNC viewer";
        }

        public String getDefaultVncServ() {
            return "localhost:5900";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return !SystemUtils.IS_OS_WINDOWS;
        }
    }
}

