/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager.dsl;

import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import org.jenkinsci.plugins.vmanager.JUnitRequestHolder;
import org.jenkinsci.plugins.vmanager.StepHolder;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VMGRBuildArchiver;
import org.jenkinsci.plugins.vmanager.dsl.VMGRLaunchStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class VMGRLaunchStepImpl
extends SynchronousNonBlockingStepExecution {
    private final transient VMGRLaunchStep step;

    VMGRLaunchStepImpl(VMGRLaunchStep vMGRLaunchStep, StepContext stepContext) {
        super(stepContext);
        this.step = vMGRLaunchStep;
    }

    protected Void run() throws Exception {
        Object object;
        TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
        EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
        String string = (String)envVars.get((Object)"BUILD_ID");
        int n = new Integer((String)envVars.get((Object)"BUILD_NUMBER"));
        String string2 = (String)envVars.get((Object)"WORKSPACE");
        taskListener.getLogger().println("Setup is using nodes for job execution: " + this.step.isPipelineNodes());
        if (this.step.isPipelineNodes()) {
            object = (String)envVars.get((Object)"JOB_NAME");
            taskListener.getLogger().println("Master Job Name: " + (String)object);
            string2 = this.step.getMasterWorkspaceLocation() + File.separator + (String)object;
            taskListener.getLogger().println("Master worspace location: " + string2);
        }
        if (!((File)(object = new File(string2))).exists()) {
            taskListener.getLogger().println("creating workspace directory: " + ((File)object).getName());
            boolean bl = false;
            try {
                ((File)object).mkdir();
                bl = true;
            }
            catch (SecurityException securityException) {
                taskListener.getLogger().println("Failed to create workspace dir.  Permisisons issues");
                throw securityException;
            }
            if (bl) {
                taskListener.getLogger().println("Workspace dir created");
            }
        }
        Run run = (Run)this.getContext().get(Run.class);
        String string3 = run.getRootDir().getAbsolutePath();
        taskListener.getLogger().println("Root dir is: " + string3);
        taskListener.getLogger().println("Running Cadence vManager Session Launcher step");
        taskListener.getLogger().println("The HOST for vAPI is: " + this.step.getVAPIUrl());
        taskListener.getLogger().println("The vAPIUser for vAPI is: " + this.step.getVAPIUser());
        taskListener.getLogger().println("The vAPIPassword for vAPI is: *******");
        taskListener.getLogger().println("The authRequired for vAPI is: " + this.step.isAuthRequired());
        taskListener.getLogger().println("The id is: " + string);
        taskListener.getLogger().println("The number is: " + n);
        taskListener.getLogger().println("The workspace dir is: " + string2);
        if (this.step.isAdvConfig()) {
            taskListener.getLogger().println("The connection timeout is: " + this.step.getConnTimeout() + " minutes");
            taskListener.getLogger().println("The read api timeout is: " + this.step.getReadTimeout() + " minutes");
        } else {
            taskListener.getLogger().println("The connection timeout is: 1 minutes");
            taskListener.getLogger().println("The read api timeout is: 30 minutes");
        }
        taskListener.getLogger().println("The execution type set is " + this.step.getExecutionType());
        if ("batch".equals(this.step.getExecutionType())) {
            taskListener.getLogger().println("The session input file name is: " + this.step.getSessionsInputFile());
            taskListener.getLogger().println("The deleteSessionInputFile : " + this.step.isDeleteSessionInputFile());
        } else {
            taskListener.getLogger().println("The vsif to be executed is for vAPI is " + this.step.getVsifType());
            taskListener.getLogger().println("The vSIFName for vAPI is: " + this.step.getVSIFName());
            taskListener.getLogger().println("The vSIFPathForExternalVSIF Input for vAPI is: " + this.step.getVSIFInputFile());
            taskListener.getLogger().println("The deleteInputFile for vAPI is: " + this.step.isDeleteInputFile());
            if (this.step.isEnvVarible()) {
                taskListener.getLogger().println("An environment varible file was selected.");
            }
            if (this.step.isAttrValues()) {
                taskListener.getLogger().println("An attribute values file was selected.");
            }
            if (this.step.isUseUserOnFarm()) {
                taskListener.getLogger().println("An User's Credential use was selected.");
                taskListener.getLogger().println("The User's Credential type is: " + this.step.getUserFarmType());
                taskListener.getLogger().println("User is using private stored SSH key: " + this.step.isUserPrivateSSHKey());
                if ("dynamic".equals(this.step.getUserFarmType())) {
                    taskListener.getLogger().println("The credential file is: " + this.step.getCredentialInputFile());
                    taskListener.getLogger().println("The credential file was set to be deleted after use: " + this.step.isDeleteCredentialInputFile());
                }
                if (!"".equals(this.step.getEnvSourceInputFile().trim())) {
                    taskListener.getLogger().println("The User's source file is: " + this.step.getEnvSourceInputFile());
                } else {
                    taskListener.getLogger().println("The User's source file wasn't set");
                }
            }
        }
        StepHolder stepHolder = null;
        JUnitRequestHolder jUnitRequestHolder = null;
        if (this.step.isWaitTillSessionEnds()) {
            taskListener.getLogger().println("Build set to finish only when session finish to run");
            taskListener.getLogger().println("In case session is at state 'inaccessible' the build will " + this.step.getInaccessibleResolver());
            taskListener.getLogger().println("In case session is at state 'failed' the build will " + this.step.getFailedResolver());
            taskListener.getLogger().println("In case session is at state 'stopped' the build will " + this.step.getStoppedResolver());
            taskListener.getLogger().println("In case session is at state 'suspended' the build will " + this.step.getSuspendedResolver());
            taskListener.getLogger().println("In case session is at state 'done' the build will " + this.step.getDoneResolver());
            taskListener.getLogger().println("Timeout for entire step is " + this.step.getStepSessionTimeout() + " minutes");
            taskListener.getLogger().println("User choosed to mark regression as Failed in case all runs are failing: " + this.step.isMarkBuildAsFailedIfAllRunFailed());
            taskListener.getLogger().println("User choosed to fail the job in case all runs are failing: " + this.step.isFailJobIfAllRunFailed());
            taskListener.getLogger().println("User choosed to mark regression as Passed in case all runs are passed: " + this.step.isMarkBuildAsPassedIfAllRunPassed());
            taskListener.getLogger().println("User choosed to fail the job unless all runs are passed: " + this.step.isFailJobUnlessAllRunPassed());
            taskListener.getLogger().println("Generate XML Report XML output: " + this.step.isGenerateJUnitXML());
            if (this.step.isGenerateJUnitXML()) {
                taskListener.getLogger().println("Do not append seed to test names: " + this.step.isNoAppendSeed());
                jUnitRequestHolder = new JUnitRequestHolder(this.step.isGenerateJUnitXML(), this.step.isExtraAttributesForFailures(), this.step.getStaticAttributeList(), this.step.isNoAppendSeed());
                taskListener.getLogger().println("Extra Attributes in JUnit Report: " + this.step.isExtraAttributesForFailures());
                if (this.step.isExtraAttributesForFailures()) {
                    taskListener.getLogger().println("Extra Attributes list in JUnit Report is: " + this.step.getStaticAttributeList());
                }
            }
            stepHolder = new StepHolder(this.step.getInaccessibleResolver(), this.step.getStoppedResolver(), this.step.getFailedResolver(), this.step.getDoneResolver(), this.step.getSuspendedResolver(), this.step.isWaitTillSessionEnds(), this.step.getStepSessionTimeout(), jUnitRequestHolder, this.step.isMarkBuildAsFailedIfAllRunFailed(), this.step.isFailJobIfAllRunFailed(), this.step.isMarkBuildAsPassedIfAllRunPassed(), this.step.isFailJobUnlessAllRunPassed());
        }
        VMGRBuildArchiver vMGRBuildArchiver = null;
        if (this.step.isVMGRBuildArchive()) {
            taskListener.getLogger().println("Session was set to get deleted when build is deleted");
            taskListener.getLogger().println("Delete also session directory on disk: " + this.step.isDeleteAlsoSessionDirectory());
            taskListener.getLogger().println("Use dedicated credentials for deleting the session: " + this.step.isGenericCredentialForSessionDelete());
            taskListener.getLogger().println("Use FAM Mode: " + this.step.getFamMode());
            if ("true".equals(this.step.getFamMode())) {
                taskListener.getLogger().println("FAM Mode Location: " + this.step.getFamModeLocation());
            }
            if (this.step.isGenericCredentialForSessionDelete()) {
                taskListener.getLogger().println("Dedicated User for session delete: " + this.step.getArchiveUser());
                taskListener.getLogger().println("Dedicated password for session delete: *******");
            }
            vMGRBuildArchiver = new VMGRBuildArchiver(this.step.isVMGRBuildArchive(), this.step.isGenericCredentialForSessionDelete(), this.step.isGenericCredentialForSessionDelete(), this.step.getArchiveUser(), this.step.getArchivePassword(), this.step.getFamMode(), this.step.getFamModeLocation());
        }
        try {
            Utils utils = new Utils();
            String[] stringArray = null;
            String[] stringArray2 = null;
            String string4 = null;
            String string5 = null;
            String[] stringArray3 = null;
            String string6 = this.step.getVAPIUser();
            String string7 = this.step.getVAPIPassword();
            if ("batch".equals(this.step.getExecutionType())) {
                if (this.step.getSessionsInputFile() == null || this.step.getSessionsInputFile().trim().equals("")) {
                    taskListener.getLogger().println("The session input file chosen is dynamic. Dynamic workspace directory: '" + string2 + "'");
                } else {
                    taskListener.getLogger().println("The session input file chosen is static. Sessions input file name is: '" + this.step.getSessionsInputFile().trim() + "'");
                }
                stringArray2 = utils.loadDataFromInputFiles(string, n, "" + string2, this.step.getSessionsInputFile(), taskListener, this.step.isDeleteSessionInputFile(), "session names", "sessions.input");
            } else {
                if ("static".equals(this.step.getVsifType())) {
                    taskListener.getLogger().println("The VSIF file chosen is static. VSIF file static location is: '" + this.step.getVSIFName() + "'");
                    stringArray = new String[]{this.step.getVSIFName()};
                } else {
                    if (this.step.getVSIFInputFile() != null && !this.step.getVSIFInputFile().trim().equals("")) {
                        taskListener.getLogger().println("The VSIF file chosen is static. VSIF file name is: '" + this.step.getVSIFInputFile().trim() + "'");
                    }
                    stringArray = utils.loadDataFromInputFiles(string, n, "" + string2, this.step.getVSIFInputFile(), taskListener, this.step.isDeleteInputFile(), "VSIF", "vsif.input");
                }
                if (this.step.isEnvVarible()) {
                    if (this.step.getEnvVaribleFile() == null || this.step.getEnvVaribleFile().trim().equals("")) {
                        taskListener.getLogger().println("The environment varible file chosen is dynamic. Env File directory dynamic workspace directory: '" + string2 + "'");
                    } else {
                        taskListener.getLogger().println("The environment varible file chosen is static. Environment file name is: '" + this.step.getEnvVaribleFile().trim() + "'");
                    }
                    string4 = utils.loadJSONEnvInput(string, n, "" + string2, this.step.getEnvVaribleFile(), taskListener);
                    taskListener.getLogger().println("Found the following environment for the vsif: " + string4);
                }
                if (this.step.isAttrValues()) {
                    if (this.step.getAttrValuesFile() == null || this.step.getAttrValuesFile().trim().equals("")) {
                        taskListener.getLogger().println("The attribute values file chosen is dynamic. Attribute values File directory dynamic workspace directory: '" + string2 + "'");
                    } else {
                        taskListener.getLogger().println("The attribute values file chosen is static. Attribute values file name is: '" + this.step.getAttrValuesFile().trim() + "'");
                    }
                    string5 = utils.loadJSONAttrValuesInput(string, n, "" + string2, this.step.getAttrValuesFile(), taskListener);
                    taskListener.getLogger().println("Found the following attribute values for the vsif: " + string5);
                }
                if ("dynamic".equals(this.step.getUserFarmType())) {
                    if (this.step.getCredentialInputFile() == null || this.step.getCredentialInputFile().trim().equals("")) {
                        taskListener.getLogger().println("The credential file chosen is dynamic. Credential directory dynamic workspace directory: '" + string2 + "'");
                    } else {
                        taskListener.getLogger().println("The credential file chosen is static. Credential file name is: '" + this.step.getCredentialInputFile().trim() + "'");
                    }
                    stringArray3 = utils.loadFileCredentials(string, n, "" + string2, this.step.getCredentialInputFile(), taskListener, this.step.isDeleteCredentialInputFile());
                    if (this.step.isUserPrivateSSHKey()) {
                        string6 = stringArray3[0];
                        string7 = stringArray3[1];
                    }
                }
            }
            String string8 = utils.executeVSIFLaunch(stringArray, this.step.getVAPIUrl(), this.step.isAuthRequired(), string6, string7, taskListener, this.step.isDynamicUserId(), string, n, "" + string2, this.step.getConnTimeout(), this.step.getReadTimeout(), this.step.isAdvConfig(), string4, this.step.isUseUserOnFarm(), this.step.getUserFarmType(), stringArray3, stepHolder, this.step.getEnvSourceInputFile(), string3, vMGRBuildArchiver, this.step.isUserPrivateSSHKey(), string5, this.step.getExecutionType(), stringArray2);
            if (!"success".equals(string8)) {
                taskListener.getLogger().println("Failed to launch vsifs for build " + string + " " + n + "\n");
                taskListener.getLogger().println(string8 + "\n");
                throw new Exception("Failed to launch vsifs for build " + string + " " + n + "\n");
            }
        }
        catch (Exception exception) {
            taskListener.getLogger().println(exception.getMessage());
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                taskListener.getLogger().println(" " + stackTraceElement);
            }
            throw exception;
        }
        return null;
    }
}

