/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class VMGRAPI
extends Builder {
    private final String vAPIUrl;
    private final boolean authRequired;
    private final String vAPIUser;
    private final String vAPIPassword;
    private final String vAPIInput;
    private final String vJsonInputFile;
    private final boolean deleteInputFile;
    private final boolean dynamicUserId;
    private final String apiType;
    private final String apiUrl;
    private final String requestMethod;
    private final boolean advConfig;
    private int connTimeout = 1;
    private int readTimeout = 30;

    @DataBoundConstructor
    public VMGRAPI(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, String string6, boolean bl3, String string7, String string8, boolean bl4, int n, int n2) {
        this.vAPIUrl = string;
        this.vAPIUser = string2;
        this.vAPIPassword = string3;
        this.vAPIInput = string4;
        this.vJsonInputFile = string5;
        this.authRequired = bl2;
        this.deleteInputFile = bl;
        this.apiType = string6;
        this.dynamicUserId = bl3;
        this.apiUrl = string7;
        this.requestMethod = string8;
        this.advConfig = bl4;
        this.connTimeout = n;
        this.readTimeout = n2;
    }

    public String getVAPIUrl() {
        return this.vAPIUrl;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getVAPIUser() {
        return this.vAPIUser;
    }

    public String getVAPIPassword() {
        return this.vAPIPassword;
    }

    public String getVAPIInput() {
        return this.vAPIInput;
    }

    public String getVJsonInputFile() {
        return this.vJsonInputFile;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isDeleteInputFile() {
        return this.deleteInputFile;
    }

    public boolean isDynamicUserId() {
        return this.dynamicUserId;
    }

    public String getApiType() {
        return this.apiType;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public boolean isAdvConfig() {
        return this.advConfig;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean perform(AbstractBuild abstractBuild, Launcher launcher, BuildListener buildListener) {
        buildListener.getLogger().println("The HOST for vAPI is: " + this.vAPIUrl);
        buildListener.getLogger().println("The vAPIUser for vAPI is: " + this.vAPIUser);
        buildListener.getLogger().println("The vAPIPassword for vAPI is: *******");
        buildListener.getLogger().println("The Static jSON query for vAPI is: " + this.vAPIInput);
        buildListener.getLogger().println("The Input file name for vAPI is: " + this.vJsonInputFile);
        buildListener.getLogger().println("The authRequired for vAPI is: " + this.authRequired);
        buildListener.getLogger().println("The deleteInputFile for vAPI is: " + this.deleteInputFile);
        buildListener.getLogger().println("The type of input file for vAPI is " + this.apiType);
        buildListener.getLogger().println("The api call for vAPI is: " + this.apiUrl);
        buildListener.getLogger().println("The id is: " + abstractBuild.getId());
        buildListener.getLogger().println("The number is: " + abstractBuild.getNumber());
        buildListener.getLogger().println("The workspace dir is: " + abstractBuild.getWorkspace());
        buildListener.getLogger().println("The request method dir is: " + this.requestMethod);
        if (this.advConfig) {
            buildListener.getLogger().println("The connection timeout is: " + this.connTimeout + " minutes");
            buildListener.getLogger().println("The read api timeout is: " + this.readTimeout + " minutes");
        } else {
            buildListener.getLogger().println("The connection timeout is: 1 minutes");
            buildListener.getLogger().println("The read api timeout is: 30 minutes");
        }
        try {
            Utils utils = new Utils();
            String string = null;
            if ("static".equals(this.apiType)) {
                buildListener.getLogger().println("The vAPI query string input chosen is static. jSON input is: '" + this.vAPIInput + "'");
                string = this.vAPIInput;
            } else {
                if (this.vJsonInputFile == null || this.vJsonInputFile.trim().equals("")) {
                    buildListener.getLogger().println("The vAPI query string chosen is dynamic. jSON input file dynamic workspace directory: '" + abstractBuild.getWorkspace() + "'");
                } else {
                    buildListener.getLogger().println("The vAPI query string chosen is dynamic. jSON input file static location: '" + this.vJsonInputFile.trim() + "'");
                }
                string = utils.loadJSONFromFile(abstractBuild.getId(), abstractBuild.getNumber(), "" + abstractBuild.getWorkspace(), this.vJsonInputFile, (TaskListener)buildListener, this.deleteInputFile);
            }
            String string2 = utils.executeAPI(string, this.apiUrl, this.vAPIUrl, this.authRequired, this.vAPIUser, this.vAPIPassword, this.requestMethod, (TaskListener)buildListener, this.dynamicUserId, abstractBuild.getId(), abstractBuild.getNumber(), "" + abstractBuild.getWorkspace(), this.connTimeout, this.readTimeout, this.advConfig);
            if (!"success".equals(string2)) {
                buildListener.getLogger().println("Failed to call vAPI for build " + abstractBuild.getId() + " " + abstractBuild.getNumber() + "\n");
                buildListener.getLogger().println(string2 + "\n");
                return false;
            }
        }
        catch (Exception exception) {
            buildListener.getLogger().println("Failed to call vAPI for build " + abstractBuild.getId() + " " + abstractBuild.getNumber());
            return false;
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckVAPIUrl(@QueryParameter String string) throws IOException, ServletException {
            if (string.length() == 0) {
                return FormValidation.error((String)"Please set the vManager vAPI HOST ");
            }
            if (string.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckApiUrl(@QueryParameter String string) throws IOException, ServletException {
            if (string.length() == 0) {
                return FormValidation.error((String)"Please set the vManager vAPI URL ");
            }
            if (string.length() < 8) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRequestMethod(@QueryParameter String string) throws IOException, ServletException {
            if (string == null || "".equals(string)) {
                return FormValidation.error((String)"Please choose the REST API request method (POST/GET/DELETE/PUT)");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillRequestMethodItems() {
            ListBoxModel listBoxModel = new ListBoxModel();
            listBoxModel.add("POST", "POST");
            listBoxModel.add("GET", "GET");
            listBoxModel.add("PUT", "PUT");
            listBoxModel.add("DELETE", "DELETE");
            return listBoxModel;
        }

        public boolean isApplicable(Class<? extends AbstractProject> clazz) {
            return true;
        }

        public String getDisplayName() {
            return "Cadence vManager API";
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject jSONObject) throws Descriptor.FormException {
            this.save();
            return super.configure(staplerRequest, jSONObject);
        }

        public FormValidation doTestConnection(@QueryParameter(value="vAPIUser") String string, @QueryParameter(value="vAPIPassword") String string2, @QueryParameter(value="vAPIUrl") String string3, @QueryParameter(value="authRequired") boolean bl) throws IOException, ServletException {
            try {
                Utils utils = new Utils();
                String string4 = utils.checkVAPIConnection(string3, bl, string, string2);
                if (!string4.startsWith("Failed")) {
                    return FormValidation.ok((String)("Success. " + string4));
                }
                return FormValidation.error((String)string4);
            }
            catch (Exception exception) {
                return FormValidation.error((String)("Client error : " + exception.getMessage()));
            }
        }
    }
}

