/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vmanager;

import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.vmanager.SessionStatusHolder;
import org.jenkinsci.plugins.vmanager.StepHolder;
import org.jenkinsci.plugins.vmanager.UnitTestFormatter;
import org.jenkinsci.plugins.vmanager.Utils;

public class LaunchHolder {
    private StepHolder stepHolder = null;
    private List<String> listOfSessions = null;
    private List<String> listOfSessionsForCountDown = null;
    private static long TIME_TO_SLEEP = 60000L;
    private static final String postData1 = "{\"filter\":{\"attName\":\"id\",\"operand\":\"EQUALS\",\"@c\":\".AttValueFilter\",\"attValue\":\"";
    private static final String postData2 = "\"},\"projection\": {\"type\":\"SELECTION_ONLY\",\"selection\":[\"session_status\",\"name\"]}}";
    private static final String runsList = "{\"filter\":{\"condition\":\"AND\",\"@c\":\".ChainedFilter\",\"chain\":[{\"@c\":\".RelationFilter\",\"relationName\":\"session\",\"filter\":{\"condition\":\"AND\",\"@c\":\".ChainedFilter\",\"chain\":[{\"@c\":\".InFilter\",\"attName\":\"id\",\"operand\":\"IN\",\"values\":[\"######\"]}]}}]},\"pageLength\":100000,\"settings\":{\"write-hidden\":true,\"stream-mode\":true},\"projection\": {\"type\": \"SELECTION_ONLY\",\"selection\":[\"test_name\",\"status\",\"duration\",\"test_group\",\"computed_seed\",\"id\",\"first_failure_name\",\"first_failure_description\"###ATTR###]}}";
    Map<String, String> extraAttrLabels = new HashMap<String, String>();

    public LaunchHolder(StepHolder stepHolder, List<String> list) {
        this.stepHolder = stepHolder;
        this.listOfSessions = list;
        this.listOfSessionsForCountDown = new ArrayList<String>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.listOfSessionsForCountDown.add(iterator.next());
        }
    }

    public StepHolder getStepHolder() {
        return this.stepHolder;
    }

    public void setStepHolder(StepHolder stepHolder) {
        this.stepHolder = stepHolder;
    }

    public List<String> getListOfSessions() {
        return this.listOfSessions;
    }

    public void setListOfSessions(List<String> list) {
        this.listOfSessions = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performWaiting(String string, boolean bl, String string2, String string3, TaskListener taskListener, boolean bl2, String string4, int n, String string5, int n2, int n3, boolean bl3, boolean bl4, String string6) throws Exception {
        String string7;
        JSONArray jSONArray;
        String string8;
        Object object;
        Object object2;
        OutputStream outputStream;
        JSONObject jSONObject;
        Object object3;
        String string9;
        CharSequence charSequence;
        Object object4;
        String string10 = "POST";
        String string11 = string + "/rest/sessions/list";
        boolean bl5 = true;
        Utils utils = new Utils();
        HttpURLConnection httpURLConnection = null;
        long l = new Date().getTime();
        long l2 = new Date().getTime();
        long l3 = this.stepHolder.getStepSessionTimeout() * 60 * 1000;
        long l4 = 1800000L;
        boolean bl6 = true;
        String string12 = null;
        if (bl4) {
            taskListener.getLogger().print("Waiting until all sessions will end...\n");
            taskListener.getLogger().print("Checking for state change every " + TIME_TO_SLEEP / 60000L + " minutes.\n");
            taskListener.getLogger().print("Printing out session state every " + l4 / 60000L + " minutes.\n");
        } else {
            System.out.println("Waiting until all sessions will end...\n");
            System.out.println("Checking for state change every " + TIME_TO_SLEEP / 60000L + " minutes.");
            System.out.println("Printing out session state every " + l4 / 60000L + " minutes.");
        }
        SessionStatusHolder sessionStatusHolder = new SessionStatusHolder(string, bl, string2, string3, taskListener, bl2, n, string5, string4, n2, n3, bl3, bl4, this.listOfSessions, this.stepHolder.isMarkBuildAsFailedIfAllRunFailed(), this.stepHolder.isFailJobIfAllRunFailed(), string6, this.stepHolder.isMarkBuildAsPassedIfAllRunPassed(), this.stepHolder.isFailJobUnlessAllRunPassed());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block22: while (bl5) {
            string12 = "";
            if (this.stepHolder.getStepSessionTimeout() != 0 && new Date().getTime() - l > l3) {
                string12 = "(" + new Date().toString() + ") - Timeout.  Waiting for more than " + this.stepHolder.getStepSessionTimeout() + " minutes. Marking build as failed.\n";
                if (bl4) {
                    taskListener.getLogger().print(string12);
                    break;
                }
                System.out.println(string12);
                break;
            }
            try {
                Thread.sleep(TIME_TO_SLEEP);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                break;
            }
            try {
                if (new Date().getTime() - l2 > l4) {
                    l2 = new Date().getTime();
                    bl6 = true;
                }
                object4 = this.listOfSessions.iterator();
                charSequence = null;
                string9 = null;
                object3 = null;
                jSONObject = null;
                while (object4.hasNext()) {
                    charSequence = object4.next();
                    string9 = postData1 + (String)charSequence + postData2;
                    try {
                        httpURLConnection = utils.getVAPIConnection(string11, bl, string2, string3, string10, bl2, string4, n, string5, taskListener, n2, n3, bl3);
                        outputStream = httpURLConnection.getOutputStream();
                        outputStream.write(string9.getBytes());
                        outputStream.flush();
                        if (!this.checkResponseCode(httpURLConnection)) continue;
                        object2 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                        object = new StringBuilder();
                        while ((string8 = ((BufferedReader)object2).readLine()) != null) {
                            ((StringBuilder)object).append(string8);
                        }
                        jSONArray = JSONArray.fromObject((Object)((StringBuilder)object).toString());
                        if (jSONArray.size() == 0) {
                            string12 = "(" + new Date().toString() + ") -  Session id (" + (String)charSequence + ") has been deleted on the vManager system.  Failing the build.\n";
                            if (bl4) {
                                taskListener.getLogger().print(string12);
                            } else {
                                System.out.println(string12);
                            }
                            bl5 = false;
                            continue block22;
                        }
                        string7 = jSONArray.getJSONObject(0);
                        object3 = string7.getString("session_status");
                        hashMap.put((String)charSequence, string7.getString("name"));
                        if (bl4) {
                            if (bl6) {
                                taskListener.getLogger().print("(" + new Date().toString() + ") - State of Session '" + string7.getString("name") + "' (" + (String)charSequence + ") = " + string7.getString("session_status") + "\n");
                            }
                        } else if (bl6) {
                            System.out.println("(" + new Date().toString() + ") - State of Session '" + string7.getString("name") + "' (" + (String)charSequence + ") = " + string7.getString("session_status"));
                        }
                        if (this.toContinue((String)object3, (String)charSequence)) {
                            string12 = "(" + new Date().toString() + ") - All sessions got into a state in which the build step can continue.\n";
                            if (bl4) {
                                taskListener.getLogger().print(string12);
                            } else {
                                System.out.println(string12);
                            }
                            string12 = "success";
                            bl5 = false;
                            continue block22;
                        }
                        if (this.toFail((String)object3, (String)charSequence)) {
                            string12 = "(" + new Date().toString() + ") - State of Session '" + string7.getString("name") + "' (" + (String)charSequence + ") = " + string7.getString("session_status") + " - Marking build failed.\n";
                            if (bl4) {
                                taskListener.getLogger().print(string12);
                            } else {
                                System.out.println(string12);
                            }
                            bl5 = false;
                            continue block22;
                        }
                        if (!this.toIgnore((String)object3, (String)charSequence)) continue;
                    }
                    catch (ConnectException connectException) {
                        if (bl4) {
                            if (!bl6) continue block22;
                            taskListener.getLogger().print("(" + new Date().toString() + ") - vManager Server is not responding or is down. Build will keep try to connect.\n");
                            continue block22;
                        }
                        System.out.println("(" + new Date().toString() + ") - vManager Server is not responding or is down. Build will keep try to connect.'");
                        continue block22;
                    }
                    catch (Exception exception) {
                        if (bl4) {
                            taskListener.getLogger().print(exception.getMessage());
                        }
                        exception.printStackTrace();
                    }
                    finally {
                        httpURLConnection.disconnect();
                        continue block22;
                    }
                }
            }
            catch (Exception exception) {
                if (bl4) {
                    taskListener.getLogger().print(exception.getMessage());
                }
                exception.printStackTrace();
            }
            finally {
                if (this.listOfSessions.size() > 1) {
                    if (bl4) {
                        if (bl6) {
                            taskListener.getLogger().print("\n");
                        }
                    } else if (bl6) {
                        System.out.println("\n");
                    }
                }
                bl6 = false;
                sessionStatusHolder.dumpSessionStatus(false, hashMap);
            }
        }
        sessionStatusHolder.dumpSessionStatus(true, hashMap);
        if (this.stepHolder.getjUnitRequestHolder() != null && this.stepHolder.getjUnitRequestHolder().isGenerateJUnitXML()) {
            Object object5;
            String string13;
            string11 = string + "/rest/$schema/response?action=list&component=runs&extended=true";
            httpURLConnection = utils.getVAPIConnection(string11, bl, string2, string3, "GET", bl2, string4, n, string5, taskListener, n2, n3, bl3);
            object4 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            charSequence = new StringBuilder();
            while ((string9 = ((BufferedReader)object4).readLine()) != null) {
                ((StringBuilder)charSequence).append(string9);
            }
            httpURLConnection.disconnect();
            object3 = JSONObject.fromObject((Object)((StringBuilder)charSequence).toString());
            jSONObject = JSONObject.fromObject((Object)object3.getString("items"));
            outputStream = JSONObject.fromObject((Object)jSONObject.getString("properties"));
            object2 = Arrays.asList(this.stepHolder.getjUnitRequestHolder().getStaticAttributeList().split("\\s*,\\s*"));
            object = object2.iterator();
            string8 = null;
            jSONArray = null;
            string7 = "";
            while (object.hasNext()) {
                string8 = (String)object.next();
                if (!outputStream.has(string8)) continue;
                jSONArray = JSONObject.fromObject((Object)outputStream.getString(string8));
                string13 = jSONArray.getString("title");
                this.extraAttrLabels.put(string8, string13);
                if (string8.indexOf(" ") > 0 || string8.equals("first_failure_name") || string8.equals("first_failure_description") || string8.equals("computed_seed") || string8.equals("test_group") || string8.equals("test_name")) continue;
                string7 = string7 + ",\"" + string8 + "\"";
            }
            string13 = string + "/rest/runs/list";
            Iterator<String> iterator = this.listOfSessions.iterator();
            String string14 = null;
            String string15 = null;
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                string14 = new String(runsList);
                string15 = iterator.next();
                string14 = string14.replaceAll("######", string15);
                string14 = string14.replaceAll("###ATTR###", string7);
                try {
                    String string16;
                    httpURLConnection = utils.getVAPIConnection(string13, bl, string2, string3, string10, bl2, string4, n, string5, taskListener, n2, n3, bl3);
                    object5 = httpURLConnection.getOutputStream();
                    ((OutputStream)object5).write(string14.getBytes());
                    ((OutputStream)object5).flush();
                    if (!this.checkResponseCode(httpURLConnection)) continue;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((string16 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string16);
                    }
                    JSONArray jSONArray2 = JSONArray.fromObject((Object)stringBuilder.toString());
                    Iterator iterator2 = jSONArray2.iterator();
                    while (iterator2.hasNext()) {
                        arrayList.add(iterator2.next());
                    }
                }
                catch (Exception exception) {
                    if (bl4) {
                        taskListener.getLogger().print(exception.getMessage());
                    }
                    exception.printStackTrace();
                }
                finally {
                    httpURLConnection.disconnect();
                }
            }
            if (arrayList.size() > 0) {
                object5 = new UnitTestFormatter(arrayList, string15, this.stepHolder.getjUnitRequestHolder(), this.extraAttrLabels);
                ((UnitTestFormatter)object5).dumpXMLFile(string5, n, string4);
            }
        }
        if (!"success".equals(string12)) {
            throw new Exception(string12);
        }
    }

    private boolean toContinue(String string, String string2) {
        return this.checkWhatNext(string, string2, "continue");
    }

    private boolean toFail(String string, String string2) {
        return this.checkWhatNext(string, string2, "fail");
    }

    private boolean toIgnore(String string, String string2) {
        return this.checkWhatNext(string, string2, "ignore");
    }

    private boolean checkWhatNext(String string, String string2, String string3) {
        if ("inaccessible".equals(string)) {
            if (this.stepHolder.getInaccessibleResolver().equals(string3)) {
                return this.stepResolver(string3, string2);
            }
        } else if ("stopped".equals(string)) {
            if (this.stepHolder.getStoppedResolver().equals(string3)) {
                return this.stepResolver(string3, string2);
            }
        } else if ("failed".equals(string)) {
            if (this.stepHolder.getFailedResolver().equals(string3)) {
                return this.stepResolver(string3, string2);
            }
        } else if ("done".equals(string)) {
            if (this.stepHolder.getDoneResolver().equals(string3)) {
                return this.stepResolver(string3, string2);
            }
        } else if ("suspended".equals(string)) {
            if (this.stepHolder.getSuspendedResolver().equals(string3)) {
                return this.stepResolver(string3, string2);
            }
        } else if ("completed".equals(string) && string3.equals("continue")) {
            return this.checkIfAllSessionsEnded(string2);
        }
        return false;
    }

    private boolean checkIfAllSessionsEnded(String string) {
        this.listOfSessionsForCountDown.remove(string);
        return this.listOfSessionsForCountDown.size() == 0;
    }

    private boolean stepResolver(String string, String string2) {
        if (string.equals("continue")) {
            return this.checkIfAllSessionsEnded(string2);
        }
        if (string.equals("fail")) {
            return true;
        }
        return string.equals("ignore");
    }

    private boolean checkResponseCode(HttpURLConnection httpURLConnection) {
        try {
            return httpURLConnection.getResponseCode() == 200 || httpURLConnection.getResponseCode() == 204 || httpURLConnection.getResponseCode() == 202 || httpURLConnection.getResponseCode() == 201 || httpURLConnection.getResponseCode() == 206 || httpURLConnection.getResponseCode() == 205 || httpURLConnection.getResponseCode() == 406;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }
}

