/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.vmanager;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.vmanager.BuildStatusMap;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.PriorityQueue;
import org.jenkinsci.plugins.vmanager.Utils;
import org.jenkinsci.plugins.vmanager.VMGRRun;
import org.kohsuke.stapler.DataBoundConstructor;

public class VmgrBuilds
extends DashboardPortlet {
    private int numBuilds = 10;
    private boolean pipelineBuild = false;

    @DataBoundConstructor
    public VmgrBuilds(String string, int n) {
        super(string);
        this.numBuilds = n;
    }

    public int getNumBuilds() {
        return this.numBuilds <= 0 ? 10 : this.numBuilds;
    }

    public String getTimestampSortData(VMGRRun vMGRRun) {
        return String.valueOf(vMGRRun.getRun().getTimeInMillis());
    }

    public String getBuildOwner(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "owner", true);
    }

    public String getSessionTriage(VMGRRun vMGRRun) {
        String string = BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "url", false);
        if ("NA".equals(string)) {
            return "NA";
        }
        String string2 = BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "id", false);
        if (string2 != null && string2.indexOf(",") > -1) {
            string2 = string2.substring(0, string2.indexOf(","));
        }
        return Utils.getRegressionURLFromVAPIURL(string) + "?sessionid=" + string2;
    }

    public String getSessionStatus(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "status", false);
    }

    public String getSessionName(VMGRRun vMGRRun) {
        String string = BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "name", false);
        if (!"NA".equals(string)) {
            String string2 = BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "session_code", false);
            string = string + " (" + string2 + ")";
        }
        return string;
    }

    public String getTotalRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "total_runs_in_session", false);
    }

    public String getPassedRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "passed_runs", false);
    }

    public String getFailedRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "failed_runs", false);
    }

    public String getOtherRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "other_runs", false);
    }

    public String getRunningRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "running", false);
    }

    public String getWaitingRuns(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "waiting", false);
    }

    public String getTotalSessions(VMGRRun vMGRRun) {
        return BuildStatusMap.getValue(vMGRRun.getRun().getId(), vMGRRun.getRun().getNumber(), vMGRRun.getJobWorkingDir() + "", "number_of_entities", false);
    }

    public String getTimestampString(VMGRRun vMGRRun) {
        return DateFormat.getDateTimeInstance(2, 2).format(new Date(vMGRRun.getRun().getTimeInMillis()));
    }

    public List<VMGRRun> getFinishedVMGRBuilds() {
        VMGRRun vMGRRun;
        VMGRRun vMGRRun2;
        Run run;
        List<Job> list = this.getDashboardJobs();
        String string = null;
        PriorityQueue<VMGRRun> priorityQueue = new PriorityQueue<VMGRRun>(this.numBuilds, VMGRRun.ORDER_BY_DATE);
        for (Job object2 : list) {
            run = object2.getLastBuild();
            if (run == null) continue;
            string = object2.getBuildDir().getAbsolutePath() + File.separator + run.getNumber();
            vMGRRun2 = null;
            vMGRRun2 = new VMGRRun(run, string, object2.getBuildDir().getAbsolutePath());
            priorityQueue.add(vMGRRun2);
        }
        ArrayList arrayList = new ArrayList(this.numBuilds);
        while ((vMGRRun = priorityQueue.poll()) != null) {
            arrayList.add(vMGRRun);
            if (arrayList.size() == this.numBuilds) break;
            run = vMGRRun.getRun().getPreviousBuild();
            if (run == null) continue;
            string = vMGRRun.getGeneralWorkingDir() + File.separator + run.getNumber();
            vMGRRun2 = new VMGRRun(run, string, vMGRRun.getGeneralWorkingDir());
            priorityQueue.add(vMGRRun2);
        }
        return arrayList;
    }

    protected List<Job> getDashboardJobs() {
        return this.getDashboard().getJobs();
    }

    public String getBuildColumnSortData(Run<?, ?> run) {
        return String.valueOf(run.getNumber());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return "vManager Latest Sessions";
        }
    }
}

