/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.simian;

import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Severity;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.parse.AbstractTypeParser;
import hudson.plugins.violations.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimianParser
extends AbstractTypeParser {
    static final String TYPE_NAME = "simian";
    private static final int LOW_LIMIT = 10;
    private static final int MEDIUM_LIMIT = 50;

    @Override
    protected void execute() throws IOException, XmlPullParserException {
        this.expectNextTag(TYPE_NAME);
        this.getParser().next();
        while (this.skipToTag("check")) {
            this.getParser().next();
            while (this.skipToTag("set")) {
                this.getParser().next();
                this.parseSetElement();
                this.endElement();
            }
            this.endElement();
        }
        this.endElement();
    }

    private void parseSetElement() throws IOException, XmlPullParserException {
        ArrayList<DuplicationBlock> blocks = new ArrayList<DuplicationBlock>();
        while (this.skipToTag("block")) {
            blocks.add(this.parseBlockElement());
            this.getParser().next();
            this.endElement();
        }
        for (DuplicationBlock block : blocks) {
            ArrayList<DuplicationBlock> otherBlocks = new ArrayList<DuplicationBlock>(blocks);
            otherBlocks.remove(block);
            Violation violation = this.createViolation(block);
            this.setViolationMessages(violation, block, otherBlocks);
            FullFileModel fileModel = this.getFileModel(block.absolutePath);
            fileModel.addViolation(violation);
        }
    }

    private DuplicationBlock parseBlockElement() throws XmlPullParserException, IOException {
        DuplicationBlock block = new DuplicationBlock();
        block.absolutePath = this.fixAbsolutePath(this.checkNotBlank("sourceFile")).replace('\\', '/');
        block.fileName = new File(block.absolutePath).getName();
        block.startLineNumber = Integer.parseInt(this.getString("startLineNumber"));
        block.endLineNumber = Integer.parseInt(this.getString("endLineNumber"));
        return block;
    }

    private void setViolationMessages(Violation violation, DuplicationBlock block, List<DuplicationBlock> otherBlocks) {
        StringBuilder popupMessage = new StringBuilder("Duplication of ");
        popupMessage.append(block.endLineNumber - block.startLineNumber + 1);
        popupMessage.append(" lines from ");
        StringBuilder message = new StringBuilder(popupMessage);
        int i = 0;
        int size = otherBlocks.size();
        for (DuplicationBlock otherViolation : otherBlocks) {
            String hrefString = this.getOtherHrefString(block, otherViolation);
            String duplicationString = this.getOtherDuplicationString(block, otherViolation);
            message.append("<a href='");
            message.append(hrefString);
            message.append("'>");
            message.append(duplicationString);
            message.append("</a>");
            popupMessage.append(duplicationString);
            String postfix = ++i < size - 1 ? ", " : (i == size - 1 ? " and " : ".");
            popupMessage.append(postfix);
            message.append(postfix);
        }
        violation.setPopupMessage(popupMessage.toString());
        violation.setMessage(message.toString());
    }

    private String getOtherHrefString(DuplicationBlock self, DuplicationBlock other) {
        String path = StringUtil.relativePath(self.absolutePath + "/bats", other.absolutePath);
        return path + "#line" + other.startLineNumber;
    }

    private String getOtherDuplicationString(DuplicationBlock self, DuplicationBlock other) {
        StringBuilder builder = new StringBuilder();
        builder.append("line ");
        builder.append(other.startLineNumber);
        if (!self.absolutePath.equals(other.absolutePath)) {
            builder.append(" in ");
            builder.append(other.fileName);
        }
        return builder.toString();
    }

    private Violation createViolation(DuplicationBlock block) {
        Violation violation = new Violation();
        violation.setType(TYPE_NAME);
        violation.setSource("duplication");
        int startLineNumber = block.startLineNumber;
        int endLineNumber = block.endLineNumber;
        int lineCount = endLineNumber - startLineNumber + 1;
        violation.setLine(startLineNumber);
        this.setViolationSeverity(violation, lineCount < 10 ? "Low" : (lineCount < 50 ? "Medium" : "High"));
        return violation;
    }

    private void setViolationSeverity(Violation v, String severity) {
        v.setSeverity(severity);
        v.setSeverityLevel(Severity.getSeverityLevel(severity));
    }

    class DuplicationBlock {
        String absolutePath;
        String fileName;
        int startLineNumber;
        int endLineNumber;

        DuplicationBlock() {
        }
    }
}

