/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.perlcritic;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Severity;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.util.AbsoluteFileFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PerlCriticParser
implements ViolationsParser {
    private static final String regex = "^(.*?): (.*) at line (\\d+), column (\\d+).\\s*(.*)\\.\\s*\\(Severity: (\\d)\\)$";
    private final transient int groups = 6;
    private final transient Pattern pattern;
    private transient AbsoluteFileFinder absoluteFileFinder = new AbsoluteFileFinder();

    public PerlCriticParser() {
        this.pattern = Pattern.compile(regex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(FullBuildModel model, File projectPath, String fileName, String[] sourcePaths) throws IOException {
        BufferedReader reader = null;
        this.absoluteFileFinder.addSourcePath(projectPath.getAbsolutePath());
        this.absoluteFileFinder.addSourcePaths(sourcePaths);
        try {
            String line;
            reader = new BufferedReader(new FileReader(new File(projectPath, fileName)));
            while ((line = reader.readLine()) != null) {
                this.parseLine(model, line, projectPath);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void parseLine(FullBuildModel model, String line, File projectPath) {
        PerlCriticViolation perlCriticViolation = this.getPerlCriticViolation(line);
        if (perlCriticViolation == null) {
            return;
        }
        String fileName = perlCriticViolation.getFileName();
        FullFileModel fileModel = this.getFileModel(model, fileName);
        fileModel.addViolation(perlCriticViolation);
    }

    private FullFileModel getFileModel(FullBuildModel model, String name) {
        File sourceFile = this.absoluteFileFinder.getFileForName(name);
        FullFileModel fileModel = model.getFileModel(name);
        File other = fileModel.getSourceFile();
        if (sourceFile == null || other != null && (other.equals(sourceFile) || other.exists())) {
            return fileModel;
        }
        fileModel.setSourceFile(sourceFile);
        fileModel.setLastModified(sourceFile.lastModified());
        return fileModel;
    }

    PerlCriticViolation getPerlCriticViolation(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.find() || matcher.groupCount() != this.groups) {
            return null;
        }
        return new PerlCriticViolation(matcher);
    }

    class PerlCriticViolation
    extends Violation {
        private int column;
        private String fileName;
        private static final int fields = 6;

        public PerlCriticViolation(Matcher matcher) {
            if (matcher.groupCount() < 6) {
                throw new IllegalArgumentException("The Regex matcher could not find enough information");
            }
            this.fileName = matcher.group(1);
            this.setMessage(matcher.group(2));
            this.setLine(matcher.group(3));
            this.setColumn(matcher.group(4));
            this.setSource(matcher.group(5));
            this.setViolationSeverity(matcher.group(6));
            this.setType("perlcritic");
        }

        private void setColumn(String column) {
            try {
                int c = Integer.parseInt(column);
                this.setColumn(c);
            }
            catch (Exception ex) {
                this.setColumn(-1);
            }
        }

        private void setColumn(int column) {
            this.column = column;
        }

        public int getColumn() {
            return this.column;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setViolationSeverity(int perlCriticSeverity) {
            int violationSeverity = 5 - perlCriticSeverity;
            this.setSeverityLevel(violationSeverity);
            this.setSeverity(Severity.NAMES[violationSeverity]);
        }

        public void setViolationSeverity(String perlCriticSeverity) {
            try {
                int severity = Integer.parseInt(perlCriticSeverity);
                this.setViolationSeverity(severity);
            }
            catch (Exception ex) {
                this.setViolationSeverity(5);
            }
        }
    }
}

