/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations.types.fxcop;

import hudson.plugins.violations.ViolationsParser;
import hudson.plugins.violations.model.FullBuildModel;
import hudson.plugins.violations.model.FullFileModel;
import hudson.plugins.violations.model.Violation;
import hudson.plugins.violations.types.fxcop.FxCopRule;
import hudson.plugins.violations.types.fxcop.FxCopRuleSet;
import hudson.plugins.violations.types.fxcop.XmlElementUtil;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FxCopParser
implements ViolationsParser {
    private transient FullBuildModel model;
    private transient File projectPath;
    private transient FxCopRuleSet ruleSet = new FxCopRuleSet();

    public void parse(FullBuildModel model, File projectPath, String fileName, String[] sourcePaths) throws IOException {
        this.projectPath = projectPath;
        this.model = model;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new FileInputStream(new File(projectPath, fileName)));
            NodeList mainNode = doc.getElementsByTagName("FxCopReport");
            Element rootElement = (Element)mainNode.item(0);
            this.parseRules(XmlElementUtil.getFirstElementByTagName(rootElement, "Rules"));
            this.parseNamespaces(XmlElementUtil.getFirstElementByTagName(rootElement, "Namespaces"), null);
            this.parseTargets(XmlElementUtil.getFirstElementByTagName(rootElement, "Targets"));
        }
        catch (ParserConfigurationException pce) {
            throw new IOException2((Throwable)pce);
        }
        catch (SAXException se) {
            throw new IOException2((Throwable)se);
        }
    }

    private void parseRules(Element rulesElement) {
        if (rulesElement != null) {
            for (Element rule : XmlElementUtil.getNamedChildElements(rulesElement, "Rule")) {
                this.ruleSet.addRule(rule);
            }
        }
    }

    private void parseTargets(Element targetsElement) {
        if (targetsElement != null) {
            for (Element target : XmlElementUtil.getNamedChildElements(targetsElement, "Target")) {
                String name = this.getString(target, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(target, "Messages"), name);
                this.parseModules(XmlElementUtil.getFirstElementByTagName(target, "Modules"), name);
                this.parseResources(XmlElementUtil.getFirstElementByTagName(target, "Resources"), name);
            }
        }
    }

    private void parseResources(Element resources, String parentName) {
        if (resources != null) {
            for (Element target : XmlElementUtil.getNamedChildElements(resources, "Resource")) {
                String name = this.getString(target, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(target, "Messages"), name);
            }
        }
    }

    private void parseModules(Element modulesElement, String parentName) {
        if (modulesElement != null) {
            for (Element module : XmlElementUtil.getNamedChildElements(modulesElement, "Module")) {
                String name = this.getString(module, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(module, "Messages"), name);
                this.parseNamespaces(XmlElementUtil.getFirstElementByTagName(module, "Namespaces"), name);
            }
        }
    }

    private void parseNamespaces(Element namespacesElement, String parentName) {
        if (namespacesElement != null) {
            for (Element namespace : XmlElementUtil.getNamedChildElements(namespacesElement, "Namespace")) {
                String name = this.getString(namespace, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(namespace, "Messages"), name);
                this.parseTypes(XmlElementUtil.getFirstElementByTagName(namespace, "Types"), name);
            }
        }
    }

    private void parseTypes(Element typesElement, String parentName) {
        if (typesElement != null) {
            for (Element type : XmlElementUtil.getNamedChildElements(typesElement, "Type")) {
                String name = parentName + "." + this.getString(type, "Name");
                this.parseMessages(XmlElementUtil.getFirstElementByTagName(type, "Messages"), name);
                this.parseMembers(XmlElementUtil.getFirstElementByTagName(type, "Members"), name);
            }
        }
    }

    private void parseMembers(Element membersElement, String parentName) {
        if (membersElement != null) {
            for (Element member : XmlElementUtil.getNamedChildElements(membersElement, "Member")) {
                this.parseMember(member, parentName);
            }
        }
    }

    private void parseAccessors(Element accessorsElement, String parentName) {
        if (accessorsElement != null) {
            for (Element member : XmlElementUtil.getNamedChildElements(accessorsElement, "Accessor")) {
                this.parseMember(member, parentName);
            }
        }
    }

    private void parseMember(Element member, String parentName) {
        this.parseMessages(XmlElementUtil.getFirstElementByTagName(member, "Messages"), parentName);
        this.parseAccessors(XmlElementUtil.getFirstElementByTagName(member, "Accessors"), parentName);
    }

    private void parseMessages(Element messages, String parentName) {
        this.parseMessages(messages, parentName, null);
    }

    private void parseMessages(Element messages, String parentName, String subName) {
        if (messages != null) {
            for (Element message : XmlElementUtil.getNamedChildElements(messages, "Message")) {
                for (Element issue : XmlElementUtil.getNamedChildElements(message, "Issue")) {
                    this.parseIssue(issue, message, parentName, subName);
                }
            }
        }
    }

    private void parseIssue(Element issue, Element parent, String parentName, String subName) {
        FullFileModel fileModel;
        FxCopRule rule;
        String typeName = this.getString(parent, "TypeName");
        String category = this.getString(parent, "Category");
        String checkId = this.getString(parent, "CheckId");
        Violation violation = new Violation();
        violation.setType("fxcop");
        violation.setSource(category + "#" + checkId);
        this.setSeverityLevel(violation, this.getString(issue, "Level"));
        StringBuilder msgBuilder = new StringBuilder();
        if (subName != null) {
            msgBuilder.append(subName);
            msgBuilder.append(" ");
        }
        if ((rule = this.ruleSet.getRule(category, checkId)) != null) {
            msgBuilder.append("<a href=\"");
            msgBuilder.append(rule.getUrl());
            msgBuilder.append("\">");
            msgBuilder.append(typeName);
            msgBuilder.append("</a>");
            violation.setPopupMessage(rule.getDescription());
        } else {
            msgBuilder.append(typeName);
        }
        msgBuilder.append(" - ");
        msgBuilder.append(issue.getTextContent());
        violation.setMessage(msgBuilder.toString());
        String filePath = this.getString(issue, "Path");
        String fileName = this.getString(issue, "File");
        String fileLine = this.getString(issue, "Line");
        if (filePath.length() > 0 && fileName.length() > 0 && fileLine.length() > 0) {
            File sourceFile;
            violation.setLine(fileLine);
            fileModel = this.model.getFileModel(this.resolveName(filePath + File.separatorChar + fileName));
            if (fileModel.getSourceFile() == null && (sourceFile = new File(filePath, fileName)).exists()) {
                fileModel.setSourceFile(sourceFile);
                fileModel.setLastModified(sourceFile.lastModified());
            }
        } else {
            fileModel = this.model.getFileModel(parentName);
        }
        fileModel.addViolation(violation);
    }

    private String resolveName(String absoluteName) {
        String remote = this.projectPath.getAbsolutePath().replace('\\', '/');
        String lcRemote = remote.toLowerCase(Locale.US);
        String name = absoluteName.replace('\\', '/');
        String lcName = name.toLowerCase(Locale.US);
        name = lcName.startsWith(lcRemote) ? name.substring(lcRemote.length()) : name.substring(2);
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    private String getString(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return "";
    }

    private void setSeverityLevel(Violation violation, String issueLevel) {
        if (issueLevel.contains("CriticalError")) {
            violation.setSeverity("High");
            violation.setSeverityLevel(0);
        } else if (issueLevel.contains("Error")) {
            violation.setSeverity("Medium High");
            violation.setSeverityLevel(1);
        } else if (issueLevel.contains("CriticalWarning")) {
            violation.setSeverity("Medium");
            violation.setSeverityLevel(2);
        } else if (issueLevel.contains("Warning")) {
            violation.setSeverity("Medium Low");
            violation.setSeverityLevel(3);
        } else {
            violation.setSeverity("Low");
            violation.setSeverityLevel(4);
        }
    }
}

