/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.violations;

import hudson.plugins.violations.util.HealthNumber;
import java.io.Serializable;

public class TypeConfig
implements Cloneable,
Serializable {
    public static final int DEFAULT_MIN = 10;
    public static final int DEFAULT_MAX = 999;
    public static final int DEFAULT_UNSTABLE = 999;
    public static final int UNSTABLE_BLANK = -4646;
    public static final int DEFAULT_FAIL = 99999;
    private final String type;
    private int min = 10;
    private int max = 999;
    private Integer unstable = 999;
    private Integer fail = null;
    private boolean usePattern = false;
    private String pattern = null;
    private static final long serialVersionUID = 1L;

    public TypeConfig(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.type;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public Integer getUnstable() {
        if (this.unstable == null) {
            this.unstable = 999;
        }
        if (this.unstable == -4646) {
            return null;
        }
        return this.unstable;
    }

    public void setUnstable(Integer unstable) {
        if (unstable <= 0) {
            unstable = -4646;
        }
        this.unstable = unstable;
    }

    public void setFail(Integer fail) {
        this.fail = fail == null || fail <= 0 ? null : fail;
    }

    public Integer getFail() {
        return this.fail;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setUsePattern(boolean usePattern) {
        this.usePattern = usePattern;
    }

    public boolean isUsePattern() {
        return this.usePattern;
    }

    public void fix() {
        if (this.min < 0) {
            this.min = 0;
        }
        if (this.max <= this.min) {
            this.max = this.min + 1;
        }
    }

    public int getHealthFor(int violations) {
        if (violations < 0) {
            return -1;
        }
        return new HealthNumber(this.min, this.max).calculate(violations);
    }

    public TypeConfig clone() {
        try {
            return (TypeConfig)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

