/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.jvctgl.perform;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gitlab4j.api.Constants;
import org.jenkinsci.plugins.jvctgl.config.CredentialsHelper;
import org.jenkinsci.plugins.jvctgl.config.ViolationConfig;
import org.jenkinsci.plugins.jvctgl.config.ViolationsToGitLabConfig;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.remoting.RoleChecker;
import se.bjurr.violations.comments.gitlab.lib.ViolationCommentsToGitLabApi;
import se.bjurr.violations.comments.lib.ViolationsLogger;
import se.bjurr.violations.lib.ViolationsApi;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.parsers.FindbugsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Filtering;

public class JvctglPerformer {
    private static Logger LOG = Logger.getLogger(JvctglPerformer.class.getSimpleName());

    @VisibleForTesting
    public static void doPerform(final ViolationsToGitLabConfig config, Optional<StringCredentials> apiTokenCredentials, File workspace, final TaskListener listener) throws MalformedURLException {
        if (config.getMergeRequestIid() == null) {
            listener.getLogger().println("No merge request id defined, will not send violation comments. \n\nPossible cause might be: mergeRequestId changed in version 2.0 and is now mergeRequestIid. If you just updated the plugin, mergeRequestIid should have the same value that you previously used for mergeRequestId. It is named wrong in the Java GitLab API and that wrong name has spread to this API.\n\n");
            return;
        }
        ArrayList allParsedViolations = Lists.newArrayList();
        for (ViolationConfig violationConfig : config.getViolationConfigs()) {
            if (Strings.isNullOrEmpty((String)violationConfig.getPattern())) continue;
            List parsedViolations = ViolationsApi.violationsApi().findAll(violationConfig.getParser()).withReporter(violationConfig.getReporter()).inFolder(workspace.getAbsolutePath()).withPattern(violationConfig.getPattern()).violations();
            SEVERITY minSeverity = config.getMinSeverity();
            if (minSeverity != null) {
                parsedViolations = Filtering.withAtLEastSeverity((List)parsedViolations, (SEVERITY)minSeverity);
            }
            allParsedViolations.addAll(parsedViolations);
            listener.getLogger().println("Found " + parsedViolations.size() + " violations from " + violationConfig + ".");
        }
        String apiToken = config.getApiToken();
        if (apiTokenCredentials.isPresent()) {
            apiToken = ((StringCredentials)apiTokenCredentials.get()).getSecret().getPlainText();
        }
        if (Strings.isNullOrEmpty((String)apiToken)) {
            throw new IllegalStateException("No credentials found!");
        }
        String hostUrl = config.getGitLabUrl();
        String projectId = config.getProjectId();
        String mergeRequestIid = config.getMergeRequestIid();
        listener.getLogger().println("Will comment PR " + hostUrl + " " + projectId + " " + mergeRequestIid);
        try {
            Constants.TokenType tokenType = config.getApiTokenPrivate() != false ? Constants.TokenType.PRIVATE : Constants.TokenType.ACCESS;
            Integer mergeRequestIidInteger = Integer.parseInt(mergeRequestIid);
            boolean shouldKeepOldComments = config.getKeepOldComments();
            boolean shouldSetWIP = config.getShouldSetWip();
            String commentTemplate = config.getCommentTemplate();
            ViolationsLogger violationsLogger = new ViolationsLogger(){

                public void log(Level level, String string) {
                    if (!config.getEnableLogging().booleanValue()) {
                        return;
                    }
                    listener.getLogger().println(level + " " + string);
                }

                public void log(Level level, String string, Throwable t) {
                    if (!config.getEnableLogging().booleanValue()) {
                        return;
                    }
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    listener.getLogger().println(level + " " + string + "\n" + sw.toString());
                }
            };
            ViolationCommentsToGitLabApi.violationCommentsToGitLabApi().setProxyServer(config.getProxyUri()).setProxyUser(config.getProxyUser()).setProxyPassword(config.getProxyPassword()).setHostUrl(hostUrl).setProjectId(projectId).setMergeRequestIid(mergeRequestIidInteger).setApiToken(apiToken).setTokenType(tokenType).setCommentOnlyChangedContent(config.getCommentOnlyChangedContent()).withShouldCommentOnlyChangedFiles(config.getCommentOnlyChangedFiles()).setCreateCommentWithAllSingleFileComments(config.getCreateCommentWithAllSingleFileComments()).setCreateSingleFileComments(config.getCreateSingleFileComments()).setIgnoreCertificateErrors(config.getIgnoreCertificateErrors().booleanValue()).setViolations((List)allParsedViolations).setShouldKeepOldComments(shouldKeepOldComments).setShouldSetWIP(shouldSetWIP).setCommentTemplate(commentTemplate).setViolationsLogger(violationsLogger).setMaxNumberOfViolations(config.getMaxNumberOfViolations()).toPullRequest();
        }
        catch (Exception e) {
            Logger.getLogger(JvctglPerformer.class.getName()).log(Level.SEVERE, "", e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            listener.getLogger().println(sw.toString());
        }
    }

    @VisibleForTesting
    static ViolationsToGitLabConfig expand(ViolationsToGitLabConfig config, EnvVars environment) {
        ViolationsToGitLabConfig expanded = new ViolationsToGitLabConfig();
        expanded.setGitLabUrl(environment.expand(config.getGitLabUrl()));
        expanded.setProjectId(environment.expand(config.getProjectId()));
        expanded.setMergeRequestIid(environment.expand(config.getMergeRequestIid()));
        expanded.setApiToken(config.getApiToken());
        expanded.setApiTokenCredentialsId(config.getApiTokenCredentialsId());
        expanded.setAuthMethodHeader(config.getAuthMethodHeader());
        expanded.setApiTokenPrivate(config.getApiTokenPrivate());
        expanded.setIgnoreCertificateErrors(config.getIgnoreCertificateErrors());
        expanded.setCommentOnlyChangedContent(config.getCommentOnlyChangedContent());
        expanded.setCommentOnlyChangedFiles(config.getCommentOnlyChangedFiles());
        expanded.setCreateCommentWithAllSingleFileComments(config.getCreateCommentWithAllSingleFileComments());
        expanded.setCreateSingleFileComments(config.getCreateSingleFileComments());
        expanded.setMinSeverity(config.getMinSeverity());
        expanded.setShouldSetWip(config.getShouldSetWip());
        expanded.setKeepOldComments(config.getKeepOldComments());
        expanded.setCommentTemplate(config.getCommentTemplate());
        expanded.setProxyUri(config.getProxyUri());
        expanded.setProxyUser(config.getProxyUser());
        expanded.setProxyPassword(config.getProxyPassword());
        expanded.setEnableLogging(config.getEnableLogging());
        expanded.setMaxNumberOfViolations(config.getMaxNumberOfViolations());
        for (ViolationConfig violationConfig : config.getViolationConfigs()) {
            String pattern = environment.expand(violationConfig.getPattern());
            String reporter = violationConfig.getReporter();
            Parser parser = violationConfig.getParser();
            if (Strings.isNullOrEmpty((String)pattern) || parser == null) {
                LOG.fine("Ignoring violationConfig because of null/empty -values: " + violationConfig);
                continue;
            }
            ViolationConfig p = new ViolationConfig();
            p.setPattern(pattern);
            p.setReporter(reporter);
            p.setParser(parser);
            expanded.getViolationConfigs().add(p);
        }
        return expanded;
    }

    public static void jvctsPerform(ViolationsToGitLabConfig configUnexpanded, FilePath fp, Run<?, ?> build, final TaskListener listener) {
        try {
            EnvVars env = build.getEnvironment(listener);
            final ViolationsToGitLabConfig configExpanded = JvctglPerformer.expand(configUnexpanded, env);
            listener.getLogger().println("---");
            listener.getLogger().println("--- Violation Comments to GitLab ---");
            listener.getLogger().println("---");
            JvctglPerformer.logConfiguration(configExpanded, build, listener);
            final Optional<StringCredentials> apiTokenCredentials = CredentialsHelper.findApiTokenCredentials((Item)build.getParent(), configExpanded.getApiTokenCredentialsId(), configExpanded.getGitLabUrl());
            listener.getLogger().println("Running Violation Comments To GitLab");
            listener.getLogger().println("Merge request: " + configExpanded.getMergeRequestIid());
            fp.act((FilePath.FileCallable)new FilePath.FileCallable<Void>(){
                private static final long serialVersionUID = -7686563245942529513L;

                public void checkRoles(RoleChecker checker) throws SecurityException {
                }

                public Void invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
                    JvctglPerformer.setupFindBugsMessages();
                    listener.getLogger().println("Workspace: " + workspace.getAbsolutePath());
                    JvctglPerformer.doPerform(configExpanded, (Optional<StringCredentials>)apiTokenCredentials, workspace, listener);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Logger.getLogger(JvctglPerformer.class.getName()).log(Level.SEVERE, "", e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            listener.getLogger().println(sw.toString());
            return;
        }
    }

    private static void logConfiguration(ViolationsToGitLabConfig config, Run<?, ?> build, TaskListener listener) {
        PrintStream logger = listener.getLogger();
        logger.println("gitLabUrl: " + config.getGitLabUrl());
        logger.println("projectId: " + config.getProjectId());
        logger.println("mergeRequestIid: " + config.getMergeRequestIid());
        logger.println("apiToken: " + !Strings.isNullOrEmpty((String)config.getApiToken()));
        logger.println("apiTokenCredentialsId: " + !Strings.isNullOrEmpty((String)config.getApiTokenCredentialsId()));
        logger.println("ignoreCertificateErrors: " + config.getIgnoreCertificateErrors());
        logger.println("apiTokenPrivate: " + config.getApiTokenPrivate());
        logger.println("authMethodHeader: " + config.getAuthMethodHeader());
        logger.println("createCommentWithAllSingleFileComments: " + config.getCreateCommentWithAllSingleFileComments());
        logger.println("createSingleFileComments: " + config.getCreateSingleFileComments());
        logger.println("commentOnlyChangedContent: " + config.getCommentOnlyChangedContent());
        logger.println("commentOnlyChangedFiles: " + config.getCommentOnlyChangedFiles());
        logger.println("maxNumberOfViolations:" + config.getMaxNumberOfViolations());
        logger.println("minSeverity: " + config.getMinSeverity());
        logger.println("keepOldComments: " + config.getKeepOldComments());
        logger.println("shouldSetWip: " + config.getShouldSetWip());
        logger.println("commentTemplate: " + config.getCommentTemplate());
        logger.println("proxyUri: " + config.getProxyUri());
        logger.println("proxyUser: " + (Strings.nullToEmpty((String)config.getProxyUser()).isEmpty() ? "no" : "yes"));
        logger.println("proxyPassword: " + (Strings.nullToEmpty((String)config.getProxyPassword()).isEmpty() ? "no" : "yes"));
        for (ViolationConfig violationConfig : config.getViolationConfigs()) {
            logger.println(violationConfig.getParser() + " with pattern " + violationConfig.getPattern());
        }
    }

    private static void setupFindBugsMessages() {
        try {
            String findbugsMessagesXml = CharStreams.toString((Readable)new InputStreamReader(JvctglPerformer.class.getResourceAsStream("findbugs-messages.xml"), Charsets.UTF_8));
            FindbugsParser.setFindbugsMessagesXml((String)findbugsMessagesXml);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

