/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.jvctgl.config;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class CredentialsHelper {
    public static ListBoxModel doFillApiTokenCredentialsIdItems(Item item, String credentialsId, String uri) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null ? !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return result.includeCurrentValue(credentialsId);
        }
        return result.includeEmptyValue().includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM, item, StandardCredentials.class, URIRequirementBuilder.fromUri((String)uri).build(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StringCredentials.class)})).includeCurrentValue(credentialsId);
    }

    public static FormValidation doCheckApiTokenCredentialsId(Item item, String credentialsId, String uri) {
        if (item == null ? !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return FormValidation.ok();
        }
        if (Strings.isNullOrEmpty((String)credentialsId)) {
            return FormValidation.ok();
        }
        if (!CredentialsHelper.findApiTokenCredentials(item, credentialsId, uri).isPresent()) {
            return FormValidation.error((String)"Cannot find currently selected credentials");
        }
        return FormValidation.ok();
    }

    public static Optional<StringCredentials> findApiTokenCredentials(Item item, String credentialsId, String uri) {
        if (Strings.isNullOrEmpty((String)credentialsId)) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)uri).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(StringCredentials.class)})));
    }
}

