/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.view26.ci.plugin.model.AutomationTestResult;
import com.view26.ci.plugin.model.Configuration;
import com.view26.ci.plugin.model.SubmittedDataColumnMeta;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class SubmittedData {
    @JsonProperty(value="columns")
    private ArrayList<SubmittedDataColumnMeta> columns = new ArrayList();
    @JsonProperty(value="dsAPIKey")
    private String apiKey = null;
    @JsonProperty(value="data")
    private ArrayList<ArrayList> data;

    public SubmittedData() {
        this.columns.add(new SubmittedDataColumnMeta("name", "Name", null, "String"));
        this.columns.add(new SubmittedDataColumnMeta("jenkins_test_set", "Jenkins Test Set", null, "String"));
        this.columns.add(new SubmittedDataColumnMeta("status", "Status", "status", "LookupList"));
        this.columns.add(new SubmittedDataColumnMeta("exe_start_date", "Execution Start Date", "exec-date", "Date"));
        this.columns.add(new SubmittedDataColumnMeta("exe_end_date", "Execution End Date", null, "Date"));
        this.columns.add(new SubmittedDataColumnMeta("automation_content", "Automation Content", null, "String"));
        this.columns.add(new SubmittedDataColumnMeta("buildNumber", "Build Number", null, "Number"));
        this.columns.add(new SubmittedDataColumnMeta("buildPath", "Build Path", null, "String"));
        this.columns.add(new SubmittedDataColumnMeta("assignee", "Assignee", "owner", "UsersList"));
        this.columns.add(new SubmittedDataColumnMeta("release_name", "Release", null, "String"));
        this.columns.add(new SubmittedDataColumnMeta("duration", "Time", null, "String"));
        this.columns.add(new SubmittedDataColumnMeta("exec_type", "Execution Type", null, "LookupList"));
        this.columns.add(new SubmittedDataColumnMeta("test_type", "Test Type", null, "LookupList"));
        this.columns.add(new SubmittedDataColumnMeta("priority", "Priority", null, "String"));
        this.columns.add(new SubmittedDataColumnMeta("ci_tool", "CI Tool", null, "String"));
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setData(String userName, String projectName, String buildNumber, String buildPath, List<AutomationTestResult> testResults, Configuration configuration) {
        this.setApiKey(configuration.getAppSecretKey());
        this.data = new ArrayList();
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
        for (AutomationTestResult item : testResults) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(item.getName());
            row.add(projectName + "_" + timeStamp);
            row.add(item.getStatus());
            row.add(item.getExecutedStartDate().toString());
            row.add(item.getExecutedEndDate().toString());
            row.add(item.getAutomationContent());
            row.add(buildNumber);
            row.add(buildPath);
            row.add(userName);
            row.add(configuration.getReleaseName());
            row.add(item.getDuration().toString());
            row.add(item.getExecutionType());
            row.add(item.getTestType());
            row.add(item.getPriority());
            row.add(item.getCiTool());
            this.data.add(row);
        }
    }
}

