/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.action;

import com.view26.ci.plugin.ConfigService;
import com.view26.ci.plugin.ResourceBundle;
import com.view26.ci.plugin.exception.StoreResultException;
import com.view26.ci.plugin.exception.SubmittedException;
import com.view26.ci.plugin.model.AutomationTestResult;
import com.view26.ci.plugin.model.Configuration;
import com.view26.ci.plugin.model.view26.Setting;
import com.view26.ci.plugin.parse.JunitTestResultParser;
import com.view26.ci.plugin.parse.ParseRequest;
import com.view26.ci.plugin.submitter.JunitSubmitter;
import com.view26.ci.plugin.submitter.JunitSubmitterRequest;
import com.view26.ci.plugin.submitter.JunitSubmitterResult;
import com.view26.ci.plugin.submitter.JunitView26SubmitterImpl;
import com.view26.ci.plugin.utils.HttpClientUtils;
import com.view26.ci.plugin.utils.JsonUtils;
import com.view26.ci.plugin.utils.LoggerUtils;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.User;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class PushingResultAction
extends Notifier {
    private static final Logger LOG = Logger.getLogger(PushingResultAction.class.getName());
    private Configuration configuration;

    public PushingResultAction(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        JunitView26SubmitterImpl junitSubmitter = new JunitView26SubmitterImpl();
        if (Result.ABORTED.equals(build.getResult())) {
            LoggerUtils.formatWarn(logger, "Abort build action.", new Object[0]);
            this.storeWhenNotSuccess(junitSubmitter, build, logger, "Canceled");
            return true;
        }
        this.showInfo(logger);
        if (!this.validateConfig(this.configuration).booleanValue()) {
            LoggerUtils.formatWarn(logger, "Invalid configuration to View26, reject submit test results.", new Object[0]);
            this.storeWhenNotSuccess(junitSubmitter, build, logger, "Failed");
            return true;
        }
        List<AutomationTestResult> automationTestResults = this.readTestResults(build, launcher, listener, logger, junitSubmitter);
        if (automationTestResults.isEmpty()) {
            return true;
        }
        JunitSubmitterResult result = this.submitTestResult(build, listener, junitSubmitter, automationTestResults);
        if (null == result) {
            return true;
        }
        this.storeResult(build, junitSubmitter, result, logger);
        LoggerUtils.formatHR(logger);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean storeWhenNotSuccess(JunitSubmitter junitSubmitter, AbstractBuild build, PrintStream logger, String status) {
        try {
            String timeStamp = new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
            junitSubmitter.storeSubmittedResult(build, new JunitSubmitterResult().setTestSuiteName((String)build.getEnvironment().get((Object)"JOB_NAME") + "_" + timeStamp).setNumberOfTestResult(0).setSubmittedStatus(status));
        }
        catch (StoreResultException e) {
            LoggerUtils.formatError(logger, e.getMessage(), new Object[0]);
            e.printStackTrace(logger);
        }
        finally {
            return true;
        }
    }

    private void showInfo(PrintStream logger) {
        LoggerUtils.formatInfo(logger, "", new Object[0]);
        LoggerUtils.formatHR(logger);
        LoggerUtils.formatInfo(logger, ResourceBundle.DISPLAY_NAME, new Object[0]);
        LoggerUtils.formatInfo(logger, String.format("Build Version: %s", ConfigService.getBuildVersion()), new Object[0]);
        LoggerUtils.formatHR(logger);
        LoggerUtils.formatInfo(logger, "Submit Junit test result to view26 at: %s", this.configuration.getUrl());
        LoggerUtils.formatInfo(logger, "With project: %s (id=%s).", this.configuration.getProjectName(), this.configuration.getProjectId());
        LoggerUtils.formatInfo(logger, "With release: %s (id=%s).", this.configuration.getReleaseName(), this.configuration.getReleaseId());
        if (this.configuration.getEnvironmentId() > 0L) {
            LoggerUtils.formatInfo(logger, "With environment: %s (id=%s).", this.configuration.getEnvironmentName(), this.configuration.getEnvironmentId());
        } else {
            LoggerUtils.formatInfo(logger, "With no environment.", new Object[0]);
        }
        LoggerUtils.formatInfo(logger, "", new Object[0]);
    }

    private Boolean validateConfig(Configuration configuration) {
        return configuration != null && !StringUtils.isEmpty((String)configuration.getUrl()) && !StringUtils.isEmpty((String)configuration.getAppSecretKey()) && !StringUtils.isEmpty((String)configuration.getReleaseName());
    }

    private List<AutomationTestResult> readTestResults(AbstractBuild build, Launcher launcher, BuildListener listener, PrintStream logger, JunitSubmitter junitSubmitter) {
        List<AutomationTestResult> automationTestResults;
        long start = System.currentTimeMillis();
        LoggerUtils.formatHR(logger);
        try {
            automationTestResults = JunitTestResultParser.parse(new ParseRequest().setBuild(build).setConfiguration(this.configuration).setLauncher(launcher).setListener(listener));
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage());
            LoggerUtils.formatError(logger, e.getMessage(), new Object[0]);
            automationTestResults = Collections.emptyList();
        }
        if (automationTestResults.isEmpty()) {
            LoggerUtils.formatWarn(logger, "No JUnit test result found.", new Object[0]);
            this.storeWhenNotSuccess(junitSubmitter, build, logger, "Skipped");
            LoggerUtils.formatHR(logger);
            return Collections.emptyList();
        }
        LoggerUtils.formatInfo(logger, "JUnit test result found: %s, time elapsed: %s", automationTestResults.size(), LoggerUtils.elapsedTime(start));
        LoggerUtils.formatHR(logger);
        LoggerUtils.formatInfo(logger, "", new Object[0]);
        return automationTestResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private JunitSubmitterResult submitTestResult(AbstractBuild build, BuildListener listener, JunitSubmitter junitSubmitter, List<AutomationTestResult> automationTestResults) {
        Boolean isSuccess;
        PrintStream logger = listener.getLogger();
        JunitSubmitterResult result = null;
        JunitSubmitterRequest tempReq = null;
        LoggerUtils.formatInfo(logger, "Begin submit test results to view26 at: " + JsonUtils.getCurrentDateString(), new Object[0]);
        long start = System.currentTimeMillis();
        try {
            tempReq = new JunitSubmitterRequest().setConfiguration(this.configuration).setTestResults(automationTestResults).setBuildNumber(build.getNumber() + "").setBuildPath(build.getUrl()).setProjectName((String)build.getEnvironment().get((Object)"JOB_NAME")).setListener(listener);
            try {
                String testerName = this.configuration.getTesterName();
                if (StringUtils.isNotBlank((String)testerName)) {
                    tempReq.setUserName(testerName);
                } else {
                    tempReq.setUserName(((Cause.UserIdCause)build.getCause(Cause.UserIdCause.class)).getUserName());
                }
            }
            catch (Exception e) {
                tempReq.setUserName("anonymous");
            }
            result = junitSubmitter.submit(tempReq);
            isSuccess = null != result && "Completed".equals(result.getSubmittedStatus());
        }
        catch (SubmittedException e) {
            LoggerUtils.formatError(logger, "Cannot submit test results to View26:", new Object[0]);
            LoggerUtils.formatError(logger, "   status code: " + e.getStatus(), new Object[0]);
            LoggerUtils.formatError(logger, "   error: " + e.getMessage(), new Object[0]);
            Boolean isSuccess2 = null != result && "Completed".equals(result.getSubmittedStatus());
            LoggerUtils.formatHR(logger);
            LoggerUtils.formatInfo(logger, isSuccess2 != false ? "SUBMIT SUCCESS" : "SUBMIT FAILED", new Object[0]);
            LoggerUtils.formatHR(logger);
            LoggerUtils.formatInfo(logger, "Time elapsed: %s", LoggerUtils.elapsedTime(start));
            LoggerUtils.formatInfo(logger, "End submit test results to view26 at: %s", JsonUtils.getCurrentDateString());
            LoggerUtils.formatInfo(logger, "", new Object[0]);
        }
        catch (Exception e2) {
            LoggerUtils.formatError(logger, "Cannot submit test results to View26:", new Object[0]);
            LoggerUtils.formatError(logger, "   error: " + e2.getMessage(), new Object[0]);
            Boolean isSuccess3 = null != result && "Completed".equals(result.getSubmittedStatus());
            {
                catch (Throwable throwable) {
                    Boolean isSuccess4 = null != result && "Completed".equals(result.getSubmittedStatus());
                    LoggerUtils.formatHR(logger);
                    LoggerUtils.formatInfo(logger, isSuccess4 != false ? "SUBMIT SUCCESS" : "SUBMIT FAILED", new Object[0]);
                    LoggerUtils.formatHR(logger);
                    LoggerUtils.formatInfo(logger, "Time elapsed: %s", LoggerUtils.elapsedTime(start));
                    LoggerUtils.formatInfo(logger, "End submit test results to view26 at: %s", JsonUtils.getCurrentDateString());
                    LoggerUtils.formatInfo(logger, "", new Object[0]);
                    throw throwable;
                }
            }
            LoggerUtils.formatHR(logger);
            LoggerUtils.formatInfo(logger, isSuccess3 != false ? "SUBMIT SUCCESS" : "SUBMIT FAILED", new Object[0]);
            LoggerUtils.formatHR(logger);
            LoggerUtils.formatInfo(logger, "Time elapsed: %s", LoggerUtils.elapsedTime(start));
            LoggerUtils.formatInfo(logger, "End submit test results to view26 at: %s", JsonUtils.getCurrentDateString());
            LoggerUtils.formatInfo(logger, "", new Object[0]);
        }
        LoggerUtils.formatHR(logger);
        LoggerUtils.formatInfo(logger, isSuccess != false ? "SUBMIT SUCCESS" : "SUBMIT FAILED", new Object[0]);
        LoggerUtils.formatHR(logger);
        LoggerUtils.formatInfo(logger, "Time elapsed: %s", LoggerUtils.elapsedTime(start));
        LoggerUtils.formatInfo(logger, "End submit test results to view26 at: %s", JsonUtils.getCurrentDateString());
        LoggerUtils.formatInfo(logger, "", new Object[0]);
        return result;
    }

    private void storeResult(AbstractBuild build, JunitSubmitter junitSubmitter, JunitSubmitterResult result, PrintStream logger) {
        try {
            junitSubmitter.storeSubmittedResult(build, result);
            LoggerUtils.formatInfo(logger, "Store submission result to workspace success.", new Object[0]);
        }
        catch (Exception e) {
            LoggerUtils.formatError(logger, "Cannot store submission result: " + e.getMessage(), new Object[0]);
            e.printStackTrace(logger);
        }
        LoggerUtils.formatInfo(logger, "", new Object[0]);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(PushingResultAction.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return ResourceBundle.DISPLAY_NAME;
        }

        public String getHelpFile() {
            return ResourceBundle.CONFIG_HELP_FILE;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String testerName = "";
            try {
                testerName = User.current().getDisplayName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Configuration configuration = (Configuration)((Object)req.bindParameters(Configuration.class, "config."));
            configuration.setJenkinsServerUrl(HttpClientUtils.getServerUrl(req));
            configuration.setReadFromJenkins(true);
            if (!StringUtils.isBlank((String)testerName)) {
                configuration.setTesterName(testerName);
            }
            configuration.setEachMethodAsTestCase(formData.getBoolean("eachMethodAsTestCase"));
            configuration = ConfigService.validateConfiguration(configuration, formData);
            if (!StringUtils.isEmpty((String)configuration.getUrl())) {
                Setting setting = null;
                String tempResponseBody = "{\"id\": 938,\"ci_server\": \"http://http://localhost:8080/jenkins\",\"ci_project\": \"poc new api\",\"project_id\": 38914,\"release_id\": 149229,\"module_id\": 2178693,\"environment_id\": 0,\"consolidate_test_run\": false,\"ci_type\": \"jenkins\",\"ciid\": \"ef4773f0470bf31b687b78a366daca88\"}";
                setting = JsonUtils.fromJson(tempResponseBody, Setting.class);
                configuration.setModuleId(setting.getModuleId());
                configuration.setId(setting.getId());
            }
            return new PushingResultAction(configuration);
        }

        public FormValidation doCheckAppSecretKey(@QueryParameter String value, @QueryParameter(value="config.url") String url, @AncestorInPath AbstractProject project) throws IOException, ServletException {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)ResourceBundle.MSG_INVALID_API_KEY);
            }
            if (!ConfigService.validateApiKey(url, value).booleanValue()) {
                return FormValidation.error((String)ResourceBundle.MSG_INVALID_API_KEY);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckReleaseName(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)ResourceBundle.MSG_INVALID_RELEASE);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckResultPattern(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Please set a valid pattern");
            }
            return FormValidation.ok();
        }
    }
}

