/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class JsonUtils {
    public static final String UTC_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private static final Logger LOG = Logger.getLogger(JsonUtils.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();

    private JsonUtils() {
    }

    public static ObjectNode newNode() {
        return mapper.createObjectNode();
    }

    public static String getCurrentDateString() {
        return new SimpleDateFormat(UTC_DATE_FORMAT).format(new Date());
    }

    public static String getText(JsonNode node, String field) {
        if (null == node || node.get(field) == null) {
            return "";
        }
        return node.get(field).asText();
    }

    public static int getInt(JsonNode node, String field) {
        if (null == node || node.get(field) == null) {
            return 0;
        }
        return node.get(field).asInt();
    }

    public static JsonNode readTree(String body) {
        JsonNode node = null;
        try {
            node = JsonUtils.parseTree(body);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "readTree: Cannot readTree from body string.", e);
        }
        return node;
    }

    public static JsonNode parseTree(String body) throws IOException {
        JsonNode node = null;
        if (StringUtils.isEmpty((String)body)) {
            return node;
        }
        return mapper.readTree(body);
    }

    public static Long getLong(JsonNode node, String field) {
        if (null == node || node.get(field) == null) {
            return 0L;
        }
        return node.get(field).asLong(0L);
    }

    public static <T> T fromJson(String body, Class<T> valueType) {
        try {
            return JsonUtils.parseJson(body, valueType);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, String.format("Cannot mapping from JSON to %s", valueType), e);
            return null;
        }
    }

    public static <T> T parseJson(String body, Class<T> valueType) throws IOException {
        if (StringUtils.isEmpty((String)body)) {
            return null;
        }
        return (T)mapper.readValue(body, valueType);
    }

    public static <T> T fromJson(String body, TypeReference<T> type) {
        try {
            if (StringUtils.isEmpty((String)body)) {
                return null;
            }
            return (T)mapper.readValue(body, type);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, String.format("Cannot mapping from JSON to %s", type), e);
            return null;
        }
    }

    public static JsonNode toJsonNode(Object data) {
        if (null == data) {
            return JsonUtils.newNode();
        }
        ObjectNode node = null;
        try {
            node = (ObjectNode)mapper.valueToTree(data);
        }
        catch (IllegalArgumentException e) {
            return JsonUtils.newNode();
        }
        return node;
    }

    public static String toJson(Object data) {
        if (null == data) {
            return "";
        }
        try {
            return mapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            LOG.log(Level.WARNING, "Cannot serial object to JSON.", e);
            return "";
        }
    }

    static {
        mapper.setDateFormat((DateFormat)new SimpleDateFormat(UTC_DATE_FORMAT));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

