/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.view26.ci.plugin.OauthProvider;
import com.view26.ci.plugin.action.PushingResultAction;
import com.view26.ci.plugin.exception.SaveSettingException;
import com.view26.ci.plugin.model.Configuration;
import com.view26.ci.plugin.model.Error;
import com.view26.ci.plugin.model.view26.Setting;
import com.view26.ci.plugin.utils.ClientRequestException;
import com.view26.ci.plugin.utils.HttpClientUtils;
import com.view26.ci.plugin.utils.JsonUtils;
import com.view26.ci.plugin.utils.ResponseEntity;
import hudson.model.AbstractProject;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class ConfigService {
    private static final Logger LOG = Logger.getLogger(ConfigService.class.getName());
    private static final String FIELD_ORIGIN_NAME = "original_name";
    private static final String FIELD_ENVIRONMENT_ORIGIN_NAME = "EnvironmentTestSuite";

    private ConfigService() {
    }

    public static Boolean validateview26Url(String url) {
        String versionUrl = String.format("%s%s", url, "/version");
        try {
            ResponseEntity entity = HttpClientUtils.get(versionUrl, null);
            if (!StringUtils.isEmpty((String)entity.getBody())) {
                JsonNode node = JsonUtils.readTree(entity.getBody());
                String name = JsonUtils.getText(node, "name");
                return "test-conductor".equalsIgnoreCase(name) || "${pom.name}".equalsIgnoreCase(name);
            }
        }
        catch (ClientRequestException e) {
            LOG.log(Level.WARNING, "Cannot connect to view26." + e.getMessage());
        }
        return false;
    }

    public static Boolean validateApiKey(String url, String apiKey) {
        Boolean valid = true;
        StringBuilder sb = new StringBuilder().append(url).append("/datasources/jenkins/validate?key=").append(HttpClientUtils.encode(apiKey));
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            ResponseEntity responseEntity = HttpClientUtils.get(sb.toString(), headers);
            if (200 != responseEntity.getStatusCode()) {
                LOG.log(Level.WARNING, String.format("Invalid API key: %s", apiKey));
                return valid == false;
            }
        }
        catch (Exception e) {
            return valid == false;
        }
        return valid;
    }

    public static String formatTestSuiteLink(String url, Long projectId, Long testSuiteId) {
        return String.format("%s/p/%s/portal/project#tab=testexecution&object=2&id=%s", url, projectId, testSuiteId);
    }

    public static Configuration getPluginConfiguration(AbstractProject project) {
        DescribableList publishers = project.getPublishersList();
        for (int i = 0; i < publishers.size(); ++i) {
            if (!(publishers.get(i) instanceof PushingResultAction)) continue;
            return ((PushingResultAction)((Object)publishers.get(i))).getConfiguration();
        }
        return null;
    }

    public static Object getProjects(String view26Url, String apiKey) {
        String url = String.format("%s/api/v3/projects?assigned=true", view26Url);
        try {
            ResponseEntity responseEntity = HttpClientUtils.get(url, OauthProvider.buildHeaders(view26Url, apiKey, null));
            if (200 != responseEntity.getStatusCode()) {
                return null;
            }
            return responseEntity.getBody();
        }
        catch (ClientRequestException e) {
            LOG.log(Level.WARNING, "Cannot get projects from: " + view26Url + "," + e.getMessage());
            return null;
        }
    }

    public static Object getProject(String view26Url, String accessToken, Long projectId) {
        String url = String.format("%s/api/v3/projects/%s", view26Url, projectId);
        try {
            ResponseEntity responseEntity = HttpClientUtils.get(url, OauthProvider.buildHeaders(accessToken, null));
            if (200 != responseEntity.getStatusCode()) {
                return null;
            }
            return responseEntity.getBody();
        }
        catch (ClientRequestException e) {
            LOG.log(Level.WARNING, "Cannot get project from: " + view26Url + "," + e.getMessage());
            return null;
        }
    }

    public static Object getReleases(String view26Url, String accessToken, Long projectId) {
        String url = String.format("%s/api/v3/projects/%s/releases?includeClosed=true", view26Url, projectId);
        try {
            ResponseEntity responseEntity = HttpClientUtils.get(url, OauthProvider.buildHeaders(accessToken, null));
            if (200 != responseEntity.getStatusCode()) {
                return null;
            }
            return responseEntity.getBody();
        }
        catch (ClientRequestException e) {
            LOG.log(Level.WARNING, "Cannot get release from: " + view26Url + "," + e.getMessage());
            return null;
        }
    }

    public static Object getEnvironments(String view26Url, String accessToken, Long projectId) {
        String url = String.format("%s/api/v3/projects/%s/settings/test-suites/fields?includeInactive=true", view26Url, projectId);
        try {
            JSONArray fields;
            ResponseEntity responseEntity = HttpClientUtils.get(url, OauthProvider.buildHeaders(accessToken, null));
            if (200 != responseEntity.getStatusCode()) {
                return null;
            }
            JSONArray jSONArray = fields = StringUtils.isEmpty((String)responseEntity.getBody()) ? null : JSONArray.fromObject((Object)responseEntity.getBody());
            if (null == fields || fields.size() <= 0) {
                return null;
            }
            JSONObject envObject = null;
            for (int i = 0; i < fields.size(); ++i) {
                JSONObject fieldObject = fields.getJSONObject(i);
                if (null == fieldObject || !FIELD_ENVIRONMENT_ORIGIN_NAME.equalsIgnoreCase(fieldObject.getString(FIELD_ORIGIN_NAME))) continue;
                envObject = fieldObject;
                break;
            }
            return envObject;
        }
        catch (ClientRequestException e) {
            LOG.log(Level.WARNING, "Cannot get environment values from: " + view26Url + "," + e.getMessage());
            return null;
        }
    }

    public static Object getConfiguration(Setting setting, String view26Url, String accessToken) {
        Boolean getById = setting.getId() != null && setting.getId() > 0L;
        String urlById = String.format("%s/api/v3/projects/%s/ci/%s", view26Url, setting.getProjectId(), setting.getId());
        String urlByProject = String.format("%s/api/v3/projects/%s/ci?server=%s&project=%s&type=jenkins&ciid=%s", view26Url, setting.getProjectId(), setting.getJenkinsServer(), HttpClientUtils.encode(setting.getJenkinsProjectName()), HttpClientUtils.encode(setting.getServerId()));
        try {
            Map<String, String> headers = OauthProvider.buildHeaders(accessToken, null);
            ResponseEntity responseEntity = HttpClientUtils.get(getById != false ? urlById : urlByProject, headers);
            if (200 != responseEntity.getStatusCode() && getById.booleanValue()) {
                responseEntity = HttpClientUtils.get(urlByProject, headers);
            }
            if (200 != responseEntity.getStatusCode()) {
                LOG.log(Level.WARNING, String.format("Cannot get config from view26: %s, server: %s, project: %s, id: %s, serverId: %s, error: %s", view26Url, setting.getJenkinsServer(), setting.getJenkinsProjectName(), setting.getId(), setting.getServerId(), responseEntity.getBody()));
                return null;
            }
            LOG.info(String.format("Get config from view26: %s,%s", view26Url, responseEntity.getBody()));
            Setting res = JsonUtils.fromJson(responseEntity.getBody(), Setting.class);
            if (null != res && "jenkins".equalsIgnoreCase(res.getCiType()) && (StringUtils.isEmpty((String)res.getServerId()) || setting.getServerId().equalsIgnoreCase(res.getServerId()))) {
                return responseEntity.getBody();
            }
            return null;
        }
        catch (ClientRequestException e) {
            return null;
        }
    }

    public static Configuration validateConfiguration(Configuration configuration, JSONObject formData) {
        configuration.setEnvironmentId(0L);
        configuration.setEnvironmentName("");
        configuration.setProjectId(0L);
        configuration.setProjectName("");
        configuration.setReleaseId(0L);
        configuration.setId(0L);
        configuration.setModuleId(0L);
        if (StringUtils.isEmpty((String)formData.getString("releaseName"))) {
            configuration.setReleaseName("");
        }
        return configuration;
    }

    public static Setting saveConfiguration(Configuration configuration) throws SaveSettingException {
        LOG.info("Save configuration to view26:" + (Object)((Object)configuration));
        try {
            String url;
            String accessToken = "abc";
            Setting setting = configuration.toSetting();
            setting.setServerId(ConfigService.getServerId(configuration.getJenkinsServerUrl()));
            Object savedObject = ConfigService.getConfiguration(setting, configuration.getUrl(), accessToken);
            Setting savedSetting = null == savedObject ? null : JsonUtils.fromJson(savedObject.toString(), Setting.class);
            Map<String, String> headers = null;
            setting.setCiType("jenkins");
            ResponseEntity responseEntity = null;
            if (savedSetting != null && savedSetting.getId() > 0L) {
                url = String.format("%s/api/v3/projects/%s/ci/%s", configuration.getUrl(), configuration.getProjectId(), savedSetting.getId());
                responseEntity = HttpClientUtils.put(url, headers, JsonUtils.toJson(setting));
            } else {
                url = String.format("%s/api/v3/projects/%s/ci", configuration.getUrl(), configuration.getProjectId());
                responseEntity = HttpClientUtils.post(url, headers, JsonUtils.toJson(setting));
            }
            if (200 != responseEntity.getStatusCode()) {
                LOG.log(Level.WARNING, String.format("Cannot save config to view26, statusCode:%s, error:%s", responseEntity.getStatusCode(), responseEntity.getBody()));
                throw new SaveSettingException(ConfigService.getErrorMessage(responseEntity.getBody()), responseEntity.getStatusCode());
            }
            Setting res = JsonUtils.fromJson(responseEntity.getBody(), Setting.class);
            LOG.info("Saved from view26:" + responseEntity.getBody());
            return res;
        }
        catch (ClientRequestException e) {
            throw new SaveSettingException(e.getMessage(), -1);
        }
    }

    public static String getBuildVersion() {
        Package pkg = ConfigService.class.getPackage();
        return StringUtils.isEmpty((String)pkg.getImplementationVersion()) ? pkg.getSpecificationVersion() : pkg.getImplementationVersion();
    }

    public static String getErrorMessage(String body) {
        Error error = null;
        try {
            error = JsonUtils.parseJson(body, Error.class);
        }
        catch (IOException e) {
            error = null;
        }
        return null == error ? body : error.getMessage();
    }

    public static String getServerId(String jenkinsUrl) {
        String hmac = null;
        try {
            String macAddress = HttpClientUtils.getMacAddress();
            if (!StringUtils.isEmpty((String)macAddress)) {
                hmac = String.format("%s:%s", macAddress, HttpClientUtils.getPort(jenkinsUrl));
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Cannot get mac address:port:" + e.getMessage());
        }
        if (!StringUtils.isEmpty(hmac)) {
            return hmac;
        }
        try {
            hmac = Jenkins.getInstance().getLegacyInstanceId();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Cannot get server id:" + e.getMessage());
        }
        return StringUtils.isEmpty((String)hmac) ? "UNKNOWN_JENKINS_SERVER_ID" : hmac;
    }
}

