/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.utils;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;

public class LoggerUtils {
    private static final String HR_TEXT = "------------------------------------------------------------------------";

    private LoggerUtils() {
    }

    public static void formatHR(PrintStream logger) {
        LoggerUtils.formatInfo(logger, HR_TEXT, new Object[0]);
    }

    public static void formatInfo(PrintStream logger, String msg, Object ... args) {
        LoggerUtils.format(logger, "INFO", msg, args);
    }

    public static void formatError(PrintStream logger, String msg, Object ... args) {
        LoggerUtils.format(logger, "ERROR", msg, args);
    }

    public static void formatWarn(PrintStream logger, String msg, Object ... args) {
        LoggerUtils.format(logger, "WARN", msg, args);
    }

    public static void format(PrintStream logger, String level, String msg, Object ... args) {
        logger.println(String.format("[view26] [%s] %s", level, String.format(msg, args)));
    }

    public static String elapsedTime(long start) {
        Long end = System.currentTimeMillis();
        Long duration = end - start;
        return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(duration), TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration)));
    }
}

