/*
 * Decompiled with CFR 0.152.
 */
package com.view26.ci.plugin.store;

import com.view26.ci.plugin.ConfigService;
import com.view26.ci.plugin.exception.StoreResultException;
import com.view26.ci.plugin.model.Configuration;
import com.view26.ci.plugin.model.SubmittedResult;
import com.view26.ci.plugin.store.ReadSubmitLogRequest;
import com.view26.ci.plugin.store.ReadSubmitLogResult;
import com.view26.ci.plugin.store.StoreResultService;
import com.view26.ci.plugin.store.file.FileReader;
import com.view26.ci.plugin.utils.JsonUtils;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.remoting.VirtualChannel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.remoting.RoleChecker;

public class StoreResultServiceImpl
implements StoreResultService {
    private static final Integer BREAK_FILE_BY = 20000;
    private static final String RESULT_FOLDER = "jview26_results";
    private static final String RESULT_FILE = "submitted";
    private static final String RESULT_FILE_EXT = ".result";

    @Override
    public Boolean store(AbstractProject project, final SubmittedResult result) throws StoreResultException {
        FilePath resultFolder = StoreResultServiceImpl.getResultFolder(project);
        try {
            resultFolder.mkdirs();
        }
        catch (Exception e) {
            throw new StoreResultException(String.format("Cannot make result folder:%s, %s", resultFolder.getName(), e.getMessage()));
        }
        FilePath resultFile = StoreResultServiceImpl.getResultFile(resultFolder, result.getBuildNumber() / BREAK_FILE_BY);
        try {
            resultFile.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
                    BufferedWriter writer = null;
                    try {
                        writer = new BufferedWriter(new FileWriter(file.getPath(), true));
                        writer.write(JsonUtils.toJson(result));
                        writer.newLine();
                        String string = null;
                        return string;
                    }
                    finally {
                        if (null != writer) {
                            writer.close();
                        }
                    }
                }

                public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                }
            });
        }
        catch (Exception e) {
            throw new StoreResultException("Cannot store result to file:" + e.getMessage());
        }
        return true;
    }

    @Override
    public ReadSubmitLogResult fetch(ReadSubmitLogRequest request) throws StoreResultException {
        FilePath resultPath = StoreResultServiceImpl.getResultFolder(request.getProject());
        int numOrder = request.getCurrentBuildNumber() / BREAK_FILE_BY;
        List<FileReader> readerList = StoreResultServiceImpl.getReaderList(resultPath, numOrder);
        Configuration configuration = ConfigService.getPluginConfiguration(request.getProject());
        String view26Url = configuration == null ? "" : configuration.getUrl();
        Long projectId = configuration == null ? 0L : configuration.getProjectId();
        int total = 0;
        HashMap<Integer, SubmittedResult> resultMap = new HashMap<Integer, SubmittedResult>();
        for (FileReader reader : readerList) {
            total += reader.size();
            try {
                resultMap.putAll(StoreResultServiceImpl.buildSubmittedResult(reader.readAll(), view26Url, projectId));
            }
            catch (IOException e) {
                throw new StoreResultException(e.getMessage(), e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new StoreResultException(e.getMessage(), e);
                }
            }
        }
        return new ReadSubmitLogResult().setTotal(total).setResults(resultMap);
    }

    private static List<FileReader> getReaderList(FilePath resultPath, int numOrder) {
        ArrayList<FileReader> readerList = new ArrayList<FileReader>();
        if (numOrder <= 0) {
            FilePath resultFile = StoreResultServiceImpl.getResultFile(resultPath, numOrder);
            try {
                readerList.add(new FileReader(new File(resultFile.getName())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            for (int i = 0; i < numOrder; ++i) {
                FilePath resultFile = StoreResultServiceImpl.getResultFile(resultPath, numOrder);
                try {
                    readerList.add(new FileReader(new File(resultFile.getName())));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return readerList;
    }

    @Override
    public ReadSubmitLogResult fetchAll(ReadSubmitLogRequest request) throws StoreResultException {
        FilePath resultPath = StoreResultServiceImpl.getResultFolder(request.getProject());
        HashMap<Integer, SubmittedResult> buildResults = new HashMap<Integer, SubmittedResult>();
        int numOrder = request.getCurrentBuildNumber() / BREAK_FILE_BY;
        Configuration configuration = ConfigService.getPluginConfiguration(request.getProject());
        String view26Url = configuration == null ? "" : configuration.getUrl();
        Long projectId = configuration == null ? 0L : configuration.getProjectId();
        try {
            if (numOrder <= 0) {
                FilePath resultFile = StoreResultServiceImpl.getResultFile(resultPath, numOrder);
                buildResults.putAll(StoreResultServiceImpl.readResult(resultFile, view26Url, projectId));
            } else {
                for (int i = 0; i < numOrder; ++i) {
                    FilePath resultFile = StoreResultServiceImpl.getResultFile(resultPath, i);
                    buildResults.putAll(StoreResultServiceImpl.readResult(resultFile, view26Url, projectId));
                }
            }
        }
        catch (Exception e) {
            throw new StoreResultException(e);
        }
        return new ReadSubmitLogResult().setResults(buildResults).setTotal(buildResults.size());
    }

    private static Map<Integer, SubmittedResult> readResult(FilePath resultFile, String url, Long projectId) throws StoreResultException {
        SortedMap lines = null;
        try {
            lines = (SortedMap)resultFile.act((FilePath.FileCallable)new FilePath.FileCallable<SortedMap<Integer, String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public SortedMap<Integer, String> invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
                    SortedMap<Integer, String> lines;
                    FileReader fileReader = new FileReader(file);
                    try {
                        lines = fileReader.readAll();
                    }
                    finally {
                        if (null != fileReader) {
                            fileReader.close();
                        }
                    }
                    return lines;
                }

                public void checkRoles(RoleChecker roleChecker) throws SecurityException {
                }
            });
        }
        catch (Exception e) {
            throw new StoreResultException(String.format("Cannot read from result file:%s, %s", resultFile.getName(), e.getMessage()));
        }
        return StoreResultServiceImpl.buildSubmittedResult(lines, url, projectId);
    }

    private static Map<Integer, SubmittedResult> buildSubmittedResult(Map<Integer, String> lines, String url, Long projectId) {
        HashMap<Integer, SubmittedResult> buildResults = new HashMap<Integer, SubmittedResult>();
        for (Map.Entry<Integer, String> entry : lines.entrySet()) {
            SubmittedResult submitResult = JsonUtils.fromJson(entry.getValue(), SubmittedResult.class);
            if (null == submitResult) continue;
            if (StringUtils.isEmpty((String)submitResult.getUrl())) {
                submitResult.setTestSuiteLink(ConfigService.formatTestSuiteLink(url, projectId, submitResult.getTestSuiteId()));
            } else {
                submitResult.setTestSuiteLink(ConfigService.formatTestSuiteLink(submitResult.getUrl(), 0L, submitResult.getTestSuiteId()));
            }
            buildResults.put(submitResult.getBuildNumber(), submitResult);
        }
        return buildResults;
    }

    private static FilePath getResultFolder(AbstractProject project) {
        FilePath projectFolder = new FilePath(project.getConfigFile().getFile()).getParent();
        return new FilePath(projectFolder, RESULT_FOLDER);
    }

    private static FilePath getResultFile(FilePath resultFolder, int fileOrder) {
        return new FilePath(resultFolder, String.format("%s_%s%s", RESULT_FILE, fileOrder, RESULT_FILE_EXT));
    }
}

