/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vboxwrapper;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.slaves.OfflineCause;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BatchFile;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VBoxBuildWrapper
extends BuildWrapper {
    private static final int CONNECT_TIMEOUT = 45;
    private static final int CONNECT_TOTAL_TIMEOUT = 180;
    private final List<String> virtualSlaves;
    private final boolean useSetup;
    private final boolean useTeardown;

    @DataBoundConstructor
    public VBoxBuildWrapper(List<String> virtualSlaves, boolean useSetup, boolean useTeardown) {
        this.virtualSlaves = virtualSlaves;
        this.useSetup = useSetup;
        this.useTeardown = useTeardown;
    }

    public List<String> getVirtualSlaves() {
        return this.virtualSlaves;
    }

    public boolean isUseSetup() {
        return this.useSetup;
    }

    public boolean isUseTeardown() {
        return this.useTeardown;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.dumpSettings(listener);
        if (this.isUseSetup()) {
            this.invokeVBoxCommand(this.getDescriptor().getSetupCommand(), build, launcher, listener);
            this.connectSlaves(listener);
        }
        return new VBoxEnvironment(launcher);
    }

    private void invokeVBoxCommand(String body, AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException {
        BatchFile interpreter;
        if (body == null || body.equals("")) {
            return;
        }
        StringBuilder sb = new StringBuilder(body);
        for (String slave : this.getVirtualSlaves()) {
            sb.append(" ");
            sb.append(slave);
        }
        String commandLine = sb.toString();
        listener.getLogger().println("Expect to launch command " + commandLine);
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        Object object = interpreter = isWindows ? new BatchFile(commandLine) : new Shell(commandLine);
        if (!interpreter.perform(build, launcher, listener)) {
            listener.error("VBox setup shell failed");
        }
    }

    private void dumpSettings(BuildListener listener) {
        listener.getLogger().format("useSetup %b\n", this.isUseSetup());
        listener.getLogger().format("useTeardown %b\n", this.isUseTeardown());
        listener.getLogger().format("setup command %s\n", this.getDescriptor().getSetupCommand());
        listener.getLogger().format("teardown command %s\n", this.getDescriptor().getTeardownCommand());
    }

    private ArrayList<SlaveComputer> getSlaveComputers(boolean collectOffline) throws IOException {
        ArrayList<SlaveComputer> computers = new ArrayList<SlaveComputer>();
        for (String slave : this.getVirtualSlaves()) {
            Computer computer = Jenkins.getInstance().getComputer(slave);
            if (computer == null) {
                throw new IOException("Cannot find registered slave " + slave);
            }
            if (!(computer instanceof SlaveComputer) || computer.isOffline() != collectOffline) continue;
            computers.add((SlaveComputer)computer);
        }
        return computers;
    }

    private void executeTasks(ArrayList<SlaveComputer> computers, List<Callable<Boolean>> callables, BuildListener listener) throws IOException {
        ExecutorService es = Executors.newFixedThreadPool(computers.size());
        try {
            List<Future<Boolean>> futures = es.invokeAll(callables);
            if (!this.futureAll(futures).booleanValue()) {
                throw new IOException("Some slaves are still in a previous state");
            }
        }
        catch (Exception e) {
            throw new IOException("Node waiting failed", e);
        }
        listener.getLogger().format("Successfully awaited %d slaves\n", computers.size());
    }

    private void disconnectSlaves(final BuildListener listener) throws IOException {
        ArrayList<SlaveComputer> computers = this.getSlaveComputers(false);
        if (computers.isEmpty()) {
            return;
        }
        ArrayList<Callable<Boolean>> callables = new ArrayList<Callable<Boolean>>();
        for (final SlaveComputer computer : computers) {
            callables.add(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    BuildListener buildListener = listener;
                    synchronized (buildListener) {
                        listener.getLogger().format("Disconnecting slave %s\n", computer.getName());
                    }
                    Future future = computer.disconnect((OfflineCause)new OfflineCause.ByCLI("disconnect to connect"));
                    try {
                        future.get(45L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        BuildListener buildListener2 = listener;
                        synchronized (buildListener2) {
                            listener.getLogger().format("Disconnect timed out or failed: %s\n", e.getMessage());
                        }
                    }
                    return true;
                }
            });
        }
        this.executeTasks(computers, callables, listener);
    }

    private void connectSlaves(final BuildListener listener) throws IOException {
        ArrayList<SlaveComputer> computers = this.getSlaveComputers(true);
        if (computers.isEmpty()) {
            return;
        }
        ArrayList<Callable<Boolean>> callables = new ArrayList<Callable<Boolean>>();
        for (final SlaveComputer computer : computers) {
            callables.add(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    BuildListener buildListener = listener;
                    synchronized (buildListener) {
                        listener.getLogger().format("Disconnecting slave %s at first\n", computer.getName());
                    }
                    Future future = computer.disconnect((OfflineCause)new OfflineCause.ByCLI("disconnect to connect"));
                    try {
                        future.get(45L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        BuildListener buildListener2 = listener;
                        synchronized (buildListener2) {
                            listener.getLogger().format("Disconnect timed out or failed: %s\n", e.getMessage());
                        }
                    }
                    int total_elapsed = 0;
                    int retry = 0;
                    while (total_elapsed < 180) {
                        if (computer.isOnline()) {
                            return true;
                        }
                        BuildListener buildListener3 = listener;
                        synchronized (buildListener3) {
                            listener.getLogger().format("Reconnecting to %s, try %d...\n", computer.getName(), retry + 1);
                        }
                        long elapsed = System.currentTimeMillis();
                        future = computer.connect(false);
                        try {
                            future.get(45L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            BuildListener buildListener4 = listener;
                            synchronized (buildListener4) {
                                listener.getLogger().format("Connect timed out or failed: %s\n", e.getMessage());
                            }
                        }
                        elapsed = Math.max(1L, System.currentTimeMillis() - elapsed) / 1000L;
                        total_elapsed = (int)((long)total_elapsed + elapsed);
                        ++retry;
                    }
                    return computer.isOnline();
                }
            });
        }
        this.executeTasks(computers, callables, listener);
    }

    private Boolean futureAll(Collection<Future<Boolean>> futures) throws InterruptedException, ExecutionException {
        boolean result = true;
        for (Future<Boolean> future : futures) {
            result = result && future.get() != false;
        }
        return result;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private String setupCommand;
        private String teardownCommand;

        public DescriptorImpl() {
            this.load();
        }

        public String getSetupCommand() {
            return this.setupCommand;
        }

        public String getTeardownCommand() {
            return this.teardownCommand;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.setupCommand = json.getString("setupCommand");
            this.teardownCommand = json.getString("teardownCommand");
            this.save();
            return super.configure(req, json);
        }

        public String getDisplayName() {
            return "VirtualBox setup/teardown tasks";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }

    class VBoxEnvironment
    extends BuildWrapper.Environment {
        private final Launcher launcher;

        public VBoxEnvironment(Launcher launcher) {
            super((BuildWrapper)VBoxBuildWrapper.this);
            this.launcher = launcher;
        }

        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            if (VBoxBuildWrapper.this.isUseTeardown()) {
                VBoxBuildWrapper.this.disconnectSlaves(listener);
                VBoxBuildWrapper.this.invokeVBoxCommand(VBoxBuildWrapper.this.getDescriptor().getTeardownCommand(), build, this.launcher, listener);
            }
            return true;
        }
    }
}

