/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger.service;

import java.util.Date;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.urltrigger.URLTriggerEntry;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentType;
import org.jenkinsci.plugins.urltrigger.service.URLResponse;

public class URLTriggerService {
    private static URLTriggerService INSTANCE = new URLTriggerService();

    private URLTriggerService() {
    }

    public static URLTriggerService getInstance() {
        return INSTANCE;
    }

    public void initContent(URLResponse clientResponse, URLTriggerEntry entry, XTriggerLog log) throws XTriggerException {
        if (clientResponse == null) {
            throw new NullPointerException("The given clientResponse object is not set.");
        }
        if (entry == null) {
            throw new NullPointerException("The given entry object is not set.");
        }
        Date lastModified = clientResponse.getLastModified();
        if (lastModified != null) {
            entry.setLastModificationDate(lastModified.getTime());
        } else {
            entry.setLastModificationDate(0L);
        }
        if (entry.isInspectingContent()) {
            for (URLTriggerContentType type : entry.getContentTypes()) {
                String stringContent = clientResponse.getContent();
                if (stringContent == null) {
                    throw new XTriggerException("The URL content is empty.");
                }
                type.initForContent(stringContent, log);
            }
        }
    }

    public boolean isSchedulingAndGetRefresh(URLResponse clientResponse, URLTriggerEntry entry, XTriggerLog log) throws XTriggerException {
        boolean job2Schedule = false;
        if (entry.isCheckStatus()) {
            job2Schedule = this.checkStatus(entry, log, clientResponse.getStatus());
        }
        if (entry.isCheckETag()) {
            String entityTagValue = clientResponse.getEntityTagValue();
            if (entityTagValue != null) {
                job2Schedule = job2Schedule || this.checkEntityTag(entry, log, entityTagValue);
            }
            this.refreshETag(entry, entityTagValue);
        }
        if (entry.isCheckLastModificationDate()) {
            Date lastModificationDate = clientResponse.getLastModified();
            job2Schedule = job2Schedule || this.checkLastModificationDate(entry, log, lastModificationDate);
            this.refreshLastModificationDate(entry, lastModificationDate);
        }
        if (entry.isInspectingContent()) {
            if (!clientResponse.isSuccessfullFamily()) {
                log.info("[WARNING] - Checking content requires success responses. Actual: " + clientResponse.getStatus());
                return false;
            }
            String content = clientResponse.getContent();
            job2Schedule = job2Schedule || this.checkContent(entry, log, content);
            this.refreshContent(entry, content, log);
        }
        return job2Schedule;
    }

    private void refreshETag(URLTriggerEntry entry, String entityTag) {
        entry.setETag(entityTag);
    }

    private void refreshLastModificationDate(URLTriggerEntry entry, Date lastModificationDate) {
        if (lastModificationDate != null) {
            entry.setLastModificationDate(lastModificationDate.getTime());
        } else {
            entry.setLastModificationDate(0L);
        }
    }

    private void refreshContent(URLTriggerEntry entry, String content, XTriggerLog log) throws XTriggerException {
        URLTriggerContentType[] contentTypes = entry.getContentTypes();
        if (contentTypes != null) {
            for (URLTriggerContentType type : contentTypes) {
                if (type == null) continue;
                type.initForContent(content, log);
            }
        }
    }

    private boolean checkStatus(URLTriggerEntry entry, XTriggerLog log, int status) throws XTriggerException {
        if (status == entry.getStatusCode()) {
            log.info(String.format("The returned status matches the expected status: \n %s", entry.getUrl()));
            return true;
        }
        return false;
    }

    private boolean checkEntityTag(URLTriggerEntry entry, XTriggerLog log, String entityTag) throws XTriggerException {
        String previousETag;
        boolean isTriggering = false;
        if (entityTag != null && !entityTag.equals(previousETag = entry.getETag())) {
            log.info("The ETag header has changed.");
            isTriggering = true;
        }
        return isTriggering;
    }

    private boolean checkLastModificationDate(URLTriggerEntry entry, XTriggerLog log, Date clientLastModificationDate) throws XTriggerException {
        boolean isTriggering = false;
        if (clientLastModificationDate != null) {
            long newLastModifiedDateTime = clientLastModificationDate.getTime();
            long previousLastModificationDateTime = entry.getLastModificationDate();
            if (previousLastModificationDateTime != 0L && previousLastModificationDateTime != newLastModifiedDateTime) {
                log.info("The last modification date has changed.");
                isTriggering = true;
            }
        }
        return isTriggering;
    }

    private boolean checkContent(URLTriggerEntry entry, XTriggerLog log, String content) throws XTriggerException {
        if (content == null) {
            return false;
        }
        URLTriggerContentType[] contentTypes = entry.getContentTypes();
        if (contentTypes == null) {
            log.info("You have to add at least one content nature type to check.");
            return false;
        }
        log.info("Inspecting the content");
        for (URLTriggerContentType type : contentTypes) {
            boolean isTriggering;
            if (type == null || !(isTriggering = type.isTriggering(content, log))) continue;
            return true;
        }
        return false;
    }
}

