/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source.config;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.tuleap_api.client.TuleapApiGuiceModule;
import io.jenkins.plugins.tuleap_credentials.AccessKeyChecker;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import io.jenkins.plugins.tuleap_credentials.exceptions.InvalidAccessKeyException;
import io.jenkins.plugins.tuleap_credentials.exceptions.InvalidScopesForAccessKeyException;
import io.jenkins.plugins.tuleap_server_configuration.TuleapConfiguration;
import java.util.List;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public class TuleapConnector {
    public static ListBoxModel listScanCredentials(@AncestorInPath @CheckForNull Item context, @QueryParameter String apiUri, @QueryParameter String credentialsId, boolean includeEmpty) {
        if (context == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(Item.EXTENDED_READ)) {
            return new StandardListBoxModel().includeCurrentValue(credentialsId);
        }
        StandardListBoxModel model = new StandardListBoxModel();
        if (includeEmpty) {
            model.includeEmptyValue();
        }
        return model.includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, context, TuleapAccessToken.class, TuleapConnector.TuleapDomainRequirements(apiUri), TuleapConnector.allTuleapAccessTokenMatch());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static FormValidation checkCredentials(@AncestorInPath Item item, String apiUri, String credentialsId) {
        if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return FormValidation.ok();
        }
        if (Util.fixEmpty((String)credentialsId) == null) {
            return FormValidation.error((String)"Tuleap Access Token is required !");
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new TuleapApiGuiceModule()});
        AccessKeyChecker checker = (AccessKeyChecker)injector.getInstance(AccessKeyChecker.class);
        TuleapAccessToken token = TuleapConnector.lookupScanCredentials(item, apiUri, credentialsId);
        try {
            checker.verifyAccessKey(Objects.requireNonNull(token).getToken());
            return FormValidation.ok();
        }
        catch (InvalidAccessKeyException | InvalidScopesForAccessKeyException exception) {
            return FormValidation.error((String)"Failed to validate the provided credentials");
        }
    }

    @CheckForNull
    public static TuleapAccessToken lookupScanCredentials(@CheckForNull Item context, @CheckForNull String apiUri, @CheckForNull String scanCredentialsId) {
        if (Util.fixEmpty((String)scanCredentialsId) == null) {
            return null;
        }
        return (TuleapAccessToken)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(TuleapAccessToken.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), TuleapConnector.TuleapDomainRequirements(apiUri)), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)scanCredentialsId), TuleapConnector.allTuleapAccessTokenMatch()}));
    }

    private static List<DomainRequirement> TuleapDomainRequirements(@CheckForNull String apiUri) {
        return URIRequirementBuilder.fromUri((String)((String)StringUtils.defaultIfEmpty((CharSequence)apiUri, (CharSequence)TuleapConfiguration.get().getApiBaseUrl()))).build();
    }

    private static CredentialsMatcher allTuleapAccessTokenMatch() {
        return CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(TuleapAccessToken.class)});
    }
}

